/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.testutil.generator;

import io.deephaven.chunk.ByteChunk;
import io.deephaven.chunk.attributes.Values;
import io.deephaven.engine.rowset.RowSet;
import io.deephaven.engine.rowset.RowSetFactory;
import io.deephaven.engine.rowset.WritableRowSet;
import io.deephaven.engine.testutil.generator.PrimitiveGeneratorFunctions;
import io.deephaven.engine.testutil.generator.UniqueTestDataGenerator;
import io.deephaven.util.type.TypeUtils;
import it.unimi.dsi.fastutil.bytes.ByteOpenHashSet;
import it.unimi.dsi.fastutil.longs.Long2ByteOpenHashMap;
import java.util.Random;

public class UniqueByteGenerator
implements UniqueTestDataGenerator<Byte, Byte> {
    final Long2ByteOpenHashMap currentValues = new Long2ByteOpenHashMap();
    final WritableRowSet currentRowSet = RowSetFactory.empty();
    private final byte to;
    private final byte from;
    private final double nullFraction;

    public UniqueByteGenerator(byte from, byte to) {
        this(from, to, 0.0);
    }

    public UniqueByteGenerator(byte from, byte to, double nullFraction) {
        this.from = from;
        this.to = to;
        this.nullFraction = nullFraction;
    }

    public ByteChunk<Values> populateChunk(RowSet toAdd, Random random) {
        if (toAdd.isEmpty()) {
            return ByteChunk.getEmptyChunk();
        }
        byte[] result = new byte[toAdd.intSize()];
        this.doRemoveValues(toAdd);
        ByteOpenHashSet usedValues = new ByteOpenHashSet(this.currentValues.values());
        int offset = 0;
        RowSet.Iterator iterator = toAdd.iterator();
        while (iterator.hasNext()) {
            long nextKey = iterator.nextLong();
            byte value = this.getNextUniqueValue(usedValues, random);
            usedValues.add(value);
            result[offset++] = value;
            this.currentValues.put(nextKey, value);
        }
        this.currentRowSet.insert(toAdd);
        return ByteChunk.chunkWrap((byte[])result);
    }

    private void doRemoveValues(RowSet toAdd) {
        toAdd.forAllRowKeys(arg_0 -> ((Long2ByteOpenHashMap)this.currentValues).remove(arg_0));
        this.currentRowSet.remove(toAdd);
    }

    @Override
    public void onRemove(RowSet toRemove) {
        this.doRemoveValues(toRemove);
    }

    @Override
    public void shift(long start, long end, long delta) {
        long kk;
        if (delta < 0L) {
            for (kk = start; kk <= end; ++kk) {
                if (!this.currentValues.containsKey(kk)) continue;
                this.currentValues.put(kk + delta, this.currentValues.remove(kk));
            }
        } else {
            for (kk = end; kk >= start; --kk) {
                if (!this.currentValues.containsKey(kk)) continue;
                this.currentValues.put(kk + delta, this.currentValues.remove(kk));
            }
        }
        try (WritableRowSet toShift = this.currentRowSet.subSetByKeyRange(start, end);){
            this.currentRowSet.removeRange(start, end);
            this.currentRowSet.insertWithShift(delta, (RowSet)toShift);
        }
    }

    private byte getNextUniqueValue(ByteOpenHashSet usedValues, Random random) {
        byte candidate;
        int triesLeft = 20;
        do {
            if (triesLeft-- > 0) continue;
            throw new RuntimeException("Could not generate unique value!");
        } while (usedValues.contains(candidate = this.nextValue(random)));
        return candidate;
    }

    private byte nextValue(Random random) {
        if (this.nullFraction > 0.0 && random.nextDouble() < this.nullFraction) {
            return -128;
        }
        return PrimitiveGeneratorFunctions.generateByte(random, this.from, this.to);
    }

    @Override
    public boolean hasValues() {
        return this.currentRowSet.isNonempty();
    }

    @Override
    public Byte getRandomValue(Random random) {
        int size = this.currentRowSet.intSize();
        int randpos = random.nextInt(size);
        long randKey = this.currentRowSet.get((long)randpos);
        return TypeUtils.box((byte)this.currentValues.get(randKey));
    }

    @Override
    public Class<Byte> getType() {
        return Byte.class;
    }

    @Override
    public Class<Byte> getColumnType() {
        return this.getType();
    }
}

