/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.testutil.generator;

import io.deephaven.chunk.CharChunk;
import io.deephaven.chunk.attributes.Values;
import io.deephaven.engine.rowset.RowSet;
import io.deephaven.engine.rowset.RowSetFactory;
import io.deephaven.engine.rowset.WritableRowSet;
import io.deephaven.engine.testutil.generator.PrimitiveGeneratorFunctions;
import io.deephaven.engine.testutil.generator.UniqueTestDataGenerator;
import io.deephaven.util.type.TypeUtils;
import it.unimi.dsi.fastutil.chars.CharOpenHashSet;
import it.unimi.dsi.fastutil.longs.Long2CharOpenHashMap;
import java.util.Random;

public class UniqueCharGenerator
implements UniqueTestDataGenerator<Character, Character> {
    final Long2CharOpenHashMap currentValues = new Long2CharOpenHashMap();
    final WritableRowSet currentRowSet = RowSetFactory.empty();
    private final char to;
    private final char from;
    private final double nullFraction;

    public UniqueCharGenerator(char from, char to) {
        this(from, to, 0.0);
    }

    public UniqueCharGenerator(char from, char to, double nullFraction) {
        this.from = from;
        this.to = to;
        this.nullFraction = nullFraction;
    }

    public CharChunk<Values> populateChunk(RowSet toAdd, Random random) {
        if (toAdd.isEmpty()) {
            return CharChunk.getEmptyChunk();
        }
        char[] result = new char[toAdd.intSize()];
        this.doRemoveValues(toAdd);
        CharOpenHashSet usedValues = new CharOpenHashSet(this.currentValues.values());
        int offset = 0;
        RowSet.Iterator iterator = toAdd.iterator();
        while (iterator.hasNext()) {
            long nextKey = iterator.nextLong();
            char value = this.getNextUniqueValue(usedValues, random);
            usedValues.add(value);
            result[offset++] = value;
            this.currentValues.put(nextKey, value);
        }
        this.currentRowSet.insert(toAdd);
        return CharChunk.chunkWrap((char[])result);
    }

    private void doRemoveValues(RowSet toAdd) {
        toAdd.forAllRowKeys(arg_0 -> ((Long2CharOpenHashMap)this.currentValues).remove(arg_0));
        this.currentRowSet.remove(toAdd);
    }

    @Override
    public void onRemove(RowSet toRemove) {
        this.doRemoveValues(toRemove);
    }

    @Override
    public void shift(long start, long end, long delta) {
        long kk;
        if (delta < 0L) {
            for (kk = start; kk <= end; ++kk) {
                if (!this.currentValues.containsKey(kk)) continue;
                this.currentValues.put(kk + delta, this.currentValues.remove(kk));
            }
        } else {
            for (kk = end; kk >= start; --kk) {
                if (!this.currentValues.containsKey(kk)) continue;
                this.currentValues.put(kk + delta, this.currentValues.remove(kk));
            }
        }
        try (WritableRowSet toShift = this.currentRowSet.subSetByKeyRange(start, end);){
            this.currentRowSet.removeRange(start, end);
            this.currentRowSet.insertWithShift(delta, (RowSet)toShift);
        }
    }

    private char getNextUniqueValue(CharOpenHashSet usedValues, Random random) {
        char candidate;
        int triesLeft = 20;
        do {
            if (triesLeft-- > 0) continue;
            throw new RuntimeException("Could not generate unique value!");
        } while (usedValues.contains(candidate = this.nextValue(random)));
        return candidate;
    }

    private char nextValue(Random random) {
        if (this.nullFraction > 0.0 && random.nextDouble() < this.nullFraction) {
            return '\uffff';
        }
        return PrimitiveGeneratorFunctions.generateChar(random, this.from, this.to);
    }

    @Override
    public boolean hasValues() {
        return this.currentRowSet.isNonempty();
    }

    @Override
    public Character getRandomValue(Random random) {
        int size = this.currentRowSet.intSize();
        int randpos = random.nextInt(size);
        long randKey = this.currentRowSet.get((long)randpos);
        return TypeUtils.box((char)this.currentValues.get(randKey));
    }

    @Override
    public Class<Character> getType() {
        return Character.class;
    }

    @Override
    public Class<Character> getColumnType() {
        return this.getType();
    }
}

