/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.testutil.generator;

import gnu.trove.list.array.TIntArrayList;
import io.deephaven.chunk.ObjectChunk;
import io.deephaven.chunk.WritableObjectChunk;
import io.deephaven.chunk.attributes.Values;
import io.deephaven.engine.testutil.generator.AbstractAdaptableUniqueGenerator;
import java.util.List;
import java.util.Random;

public class UniqueIntArrayGenerator
extends AbstractAdaptableUniqueGenerator<TIntArrayList, int[]> {
    private final int minSize;
    private final int maxSize;
    private final int min;
    private final int max;

    public UniqueIntArrayGenerator(int min, int max, int minSize, int maxSize) {
        this.min = min;
        this.max = max;
        this.minSize = minSize;
        this.maxSize = maxSize;
    }

    @Override
    public Class<int[]> getType() {
        return int[].class;
    }

    ObjectChunk<int[], Values> makeChunk(List<int[]> list) {
        return WritableObjectChunk.writableChunkWrap((Object[])((int[][])list.toArray((T[])new int[list.size()][])));
    }

    @Override
    TIntArrayList nextValue(long key, Random random) {
        int size = random.nextInt(this.maxSize - this.minSize) + this.minSize;
        TIntArrayList list = new TIntArrayList(size);
        for (int ii = 0; ii < size; ++ii) {
            list.add(random.nextInt(this.max - this.min) + this.min);
        }
        return list;
    }

    @Override
    int[] adapt(TIntArrayList value) {
        return value.toArray();
    }

    @Override
    TIntArrayList invert(int[] value) {
        return new TIntArrayList(value);
    }
}

