/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.testutil.generator;

import io.deephaven.chunk.IntChunk;
import io.deephaven.chunk.attributes.Values;
import io.deephaven.engine.rowset.RowSet;
import io.deephaven.engine.rowset.RowSetFactory;
import io.deephaven.engine.rowset.WritableRowSet;
import io.deephaven.engine.testutil.generator.PrimitiveGeneratorFunctions;
import io.deephaven.engine.testutil.generator.UniqueTestDataGenerator;
import io.deephaven.util.type.TypeUtils;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import java.util.Random;

public class UniqueIntGenerator
implements UniqueTestDataGenerator<Integer, Integer> {
    final Long2IntOpenHashMap currentValues = new Long2IntOpenHashMap();
    final WritableRowSet currentRowSet = RowSetFactory.empty();
    private final int to;
    private final int from;
    private final double nullFraction;

    public UniqueIntGenerator(int from, int to) {
        this(from, to, 0.0);
    }

    public UniqueIntGenerator(int from, int to, double nullFraction) {
        this.from = from;
        this.to = to;
        this.nullFraction = nullFraction;
    }

    public IntChunk<Values> populateChunk(RowSet toAdd, Random random) {
        if (toAdd.isEmpty()) {
            return IntChunk.getEmptyChunk();
        }
        int[] result = new int[toAdd.intSize()];
        this.doRemoveValues(toAdd);
        IntOpenHashSet usedValues = new IntOpenHashSet(this.currentValues.values());
        int offset = 0;
        RowSet.Iterator iterator = toAdd.iterator();
        while (iterator.hasNext()) {
            long nextKey = iterator.nextLong();
            int value = this.getNextUniqueValue(usedValues, random);
            usedValues.add(value);
            result[offset++] = value;
            this.currentValues.put(nextKey, value);
        }
        this.currentRowSet.insert(toAdd);
        return IntChunk.chunkWrap((int[])result);
    }

    private void doRemoveValues(RowSet toAdd) {
        toAdd.forAllRowKeys(arg_0 -> ((Long2IntOpenHashMap)this.currentValues).remove(arg_0));
        this.currentRowSet.remove(toAdd);
    }

    @Override
    public void onRemove(RowSet toRemove) {
        this.doRemoveValues(toRemove);
    }

    @Override
    public void shift(long start, long end, long delta) {
        long kk;
        if (delta < 0L) {
            for (kk = start; kk <= end; ++kk) {
                if (!this.currentValues.containsKey(kk)) continue;
                this.currentValues.put(kk + delta, this.currentValues.remove(kk));
            }
        } else {
            for (kk = end; kk >= start; --kk) {
                if (!this.currentValues.containsKey(kk)) continue;
                this.currentValues.put(kk + delta, this.currentValues.remove(kk));
            }
        }
        try (WritableRowSet toShift = this.currentRowSet.subSetByKeyRange(start, end);){
            this.currentRowSet.removeRange(start, end);
            this.currentRowSet.insertWithShift(delta, (RowSet)toShift);
        }
    }

    private int getNextUniqueValue(IntOpenHashSet usedValues, Random random) {
        int candidate;
        int triesLeft = 20;
        do {
            if (triesLeft-- > 0) continue;
            throw new RuntimeException("Could not generate unique value!");
        } while (usedValues.contains(candidate = this.nextValue(random)));
        return candidate;
    }

    private int nextValue(Random random) {
        if (this.nullFraction > 0.0 && random.nextDouble() < this.nullFraction) {
            return Integer.MIN_VALUE;
        }
        return PrimitiveGeneratorFunctions.generateInt(random, this.from, this.to);
    }

    @Override
    public boolean hasValues() {
        return this.currentRowSet.isNonempty();
    }

    @Override
    public Integer getRandomValue(Random random) {
        int size = this.currentRowSet.intSize();
        int randpos = random.nextInt(size);
        long randKey = this.currentRowSet.get((long)randpos);
        return TypeUtils.box((int)this.currentValues.get(randKey));
    }

    @Override
    public Class<Integer> getType() {
        return Integer.class;
    }

    @Override
    public Class<Integer> getColumnType() {
        return this.getType();
    }
}

