/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.testutil.generator;

import io.deephaven.chunk.LongChunk;
import io.deephaven.chunk.attributes.Values;
import io.deephaven.engine.rowset.RowSet;
import io.deephaven.engine.rowset.RowSetFactory;
import io.deephaven.engine.rowset.WritableRowSet;
import io.deephaven.engine.testutil.generator.PrimitiveGeneratorFunctions;
import io.deephaven.engine.testutil.generator.UniqueTestDataGenerator;
import io.deephaven.util.type.TypeUtils;
import it.unimi.dsi.fastutil.longs.Long2LongOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.util.Random;

public class UniqueLongGenerator
implements UniqueTestDataGenerator<Long, Long> {
    final Long2LongOpenHashMap currentValues = new Long2LongOpenHashMap();
    final WritableRowSet currentRowSet = RowSetFactory.empty();
    private final long to;
    private final long from;
    private final double nullFraction;

    public UniqueLongGenerator(long from, long to) {
        this(from, to, 0.0);
    }

    public UniqueLongGenerator(long from, long to, double nullFraction) {
        this.from = from;
        this.to = to;
        this.nullFraction = nullFraction;
    }

    public LongChunk<Values> populateChunk(RowSet toAdd, Random random) {
        if (toAdd.isEmpty()) {
            return LongChunk.getEmptyChunk();
        }
        long[] result = new long[toAdd.intSize()];
        this.doRemoveValues(toAdd);
        LongOpenHashSet usedValues = new LongOpenHashSet(this.currentValues.values());
        int offset = 0;
        RowSet.Iterator iterator = toAdd.iterator();
        while (iterator.hasNext()) {
            long nextKey = iterator.nextLong();
            long value = this.getNextUniqueValue(usedValues, random);
            usedValues.add(value);
            result[offset++] = value;
            this.currentValues.put(nextKey, value);
        }
        this.currentRowSet.insert(toAdd);
        return LongChunk.chunkWrap((long[])result);
    }

    private void doRemoveValues(RowSet toAdd) {
        toAdd.forAllRowKeys(arg_0 -> ((Long2LongOpenHashMap)this.currentValues).remove(arg_0));
        this.currentRowSet.remove(toAdd);
    }

    @Override
    public void onRemove(RowSet toRemove) {
        this.doRemoveValues(toRemove);
    }

    @Override
    public void shift(long start, long end, long delta) {
        long kk;
        if (delta < 0L) {
            for (kk = start; kk <= end; ++kk) {
                if (!this.currentValues.containsKey(kk)) continue;
                this.currentValues.put(kk + delta, this.currentValues.remove(kk));
            }
        } else {
            for (kk = end; kk >= start; --kk) {
                if (!this.currentValues.containsKey(kk)) continue;
                this.currentValues.put(kk + delta, this.currentValues.remove(kk));
            }
        }
        try (WritableRowSet toShift = this.currentRowSet.subSetByKeyRange(start, end);){
            this.currentRowSet.removeRange(start, end);
            this.currentRowSet.insertWithShift(delta, (RowSet)toShift);
        }
    }

    private long getNextUniqueValue(LongOpenHashSet usedValues, Random random) {
        long candidate;
        int triesLeft = 20;
        do {
            if (triesLeft-- > 0) continue;
            throw new RuntimeException("Could not generate unique value!");
        } while (usedValues.contains(candidate = this.nextValue(random)));
        return candidate;
    }

    private long nextValue(Random random) {
        if (this.nullFraction > 0.0 && random.nextDouble() < this.nullFraction) {
            return Long.MIN_VALUE;
        }
        return PrimitiveGeneratorFunctions.generateLong(random, this.from, this.to);
    }

    @Override
    public boolean hasValues() {
        return this.currentRowSet.isNonempty();
    }

    @Override
    public Long getRandomValue(Random random) {
        int size = this.currentRowSet.intSize();
        int randpos = random.nextInt(size);
        long randKey = this.currentRowSet.get((long)randpos);
        return TypeUtils.box((long)this.currentValues.get(randKey));
    }

    @Override
    public Class<Long> getType() {
        return Long.class;
    }

    @Override
    public Class<Long> getColumnType() {
        return this.getType();
    }
}

