/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.testutil.generator;

import io.deephaven.chunk.ShortChunk;
import io.deephaven.chunk.attributes.Values;
import io.deephaven.engine.rowset.RowSet;
import io.deephaven.engine.rowset.RowSetFactory;
import io.deephaven.engine.rowset.WritableRowSet;
import io.deephaven.engine.testutil.generator.PrimitiveGeneratorFunctions;
import io.deephaven.engine.testutil.generator.UniqueTestDataGenerator;
import io.deephaven.util.type.TypeUtils;
import it.unimi.dsi.fastutil.longs.Long2ShortOpenHashMap;
import it.unimi.dsi.fastutil.shorts.ShortOpenHashSet;
import java.util.Random;

public class UniqueShortGenerator
implements UniqueTestDataGenerator<Short, Short> {
    final Long2ShortOpenHashMap currentValues = new Long2ShortOpenHashMap();
    final WritableRowSet currentRowSet = RowSetFactory.empty();
    private final short to;
    private final short from;
    private final double nullFraction;

    public UniqueShortGenerator(short from, short to) {
        this(from, to, 0.0);
    }

    public UniqueShortGenerator(short from, short to, double nullFraction) {
        this.from = from;
        this.to = to;
        this.nullFraction = nullFraction;
    }

    public ShortChunk<Values> populateChunk(RowSet toAdd, Random random) {
        if (toAdd.isEmpty()) {
            return ShortChunk.getEmptyChunk();
        }
        short[] result = new short[toAdd.intSize()];
        this.doRemoveValues(toAdd);
        ShortOpenHashSet usedValues = new ShortOpenHashSet(this.currentValues.values());
        int offset = 0;
        RowSet.Iterator iterator = toAdd.iterator();
        while (iterator.hasNext()) {
            long nextKey = iterator.nextLong();
            short value = this.getNextUniqueValue(usedValues, random);
            usedValues.add(value);
            result[offset++] = value;
            this.currentValues.put(nextKey, value);
        }
        this.currentRowSet.insert(toAdd);
        return ShortChunk.chunkWrap((short[])result);
    }

    private void doRemoveValues(RowSet toAdd) {
        toAdd.forAllRowKeys(arg_0 -> ((Long2ShortOpenHashMap)this.currentValues).remove(arg_0));
        this.currentRowSet.remove(toAdd);
    }

    @Override
    public void onRemove(RowSet toRemove) {
        this.doRemoveValues(toRemove);
    }

    @Override
    public void shift(long start, long end, long delta) {
        long kk;
        if (delta < 0L) {
            for (kk = start; kk <= end; ++kk) {
                if (!this.currentValues.containsKey(kk)) continue;
                this.currentValues.put(kk + delta, this.currentValues.remove(kk));
            }
        } else {
            for (kk = end; kk >= start; --kk) {
                if (!this.currentValues.containsKey(kk)) continue;
                this.currentValues.put(kk + delta, this.currentValues.remove(kk));
            }
        }
        try (WritableRowSet toShift = this.currentRowSet.subSetByKeyRange(start, end);){
            this.currentRowSet.removeRange(start, end);
            this.currentRowSet.insertWithShift(delta, (RowSet)toShift);
        }
    }

    private short getNextUniqueValue(ShortOpenHashSet usedValues, Random random) {
        short candidate;
        int triesLeft = 20;
        do {
            if (triesLeft-- > 0) continue;
            throw new RuntimeException("Could not generate unique value!");
        } while (usedValues.contains(candidate = this.nextValue(random)));
        return candidate;
    }

    private short nextValue(Random random) {
        if (this.nullFraction > 0.0 && random.nextDouble() < this.nullFraction) {
            return Short.MIN_VALUE;
        }
        return PrimitiveGeneratorFunctions.generateShort(random, this.from, this.to);
    }

    @Override
    public boolean hasValues() {
        return this.currentRowSet.isNonempty();
    }

    @Override
    public Short getRandomValue(Random random) {
        int size = this.currentRowSet.intSize();
        int randpos = random.nextInt(size);
        long randKey = this.currentRowSet.get((long)randpos);
        return TypeUtils.box((short)this.currentValues.get(randKey));
    }

    @Override
    public Class<Short> getType() {
        return Short.class;
    }

    @Override
    public Class<Short> getColumnType() {
        return this.getType();
    }
}

