/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.testutil.generator;

import io.deephaven.chunk.ObjectChunk;
import io.deephaven.chunk.WritableObjectChunk;
import io.deephaven.chunk.attributes.Values;
import io.deephaven.datastructures.util.CollectionUtil;
import io.deephaven.engine.testutil.generator.AbstractAdaptableUniqueGenerator;
import java.util.Arrays;
import java.util.List;
import java.util.Random;

public class UniqueStringArrayGenerator
extends AbstractAdaptableUniqueGenerator<List<String>, String[]> {
    private final int minSize;
    private final int maxSize;

    public UniqueStringArrayGenerator(int minSize, int maxSize) {
        this.minSize = minSize;
        this.maxSize = maxSize;
    }

    @Override
    public Class<String[]> getType() {
        return String[].class;
    }

    ObjectChunk<String[], Values> makeChunk(List<String[]> list) {
        return WritableObjectChunk.writableChunkWrap((Object[])((String[][])list.toArray((T[])new String[list.size()][])));
    }

    @Override
    List<String> nextValue(long key, Random random) {
        int size = random.nextInt(this.maxSize - this.minSize) + this.minSize;
        String[] arr = new String[size];
        for (int ii = 0; ii < size; ++ii) {
            arr[ii] = Long.toString(random.nextLong(), 35);
        }
        return Arrays.asList(arr);
    }

    @Override
    String[] adapt(List<String> value) {
        return value.toArray(CollectionUtil.ZERO_LENGTH_STRING_ARRAY);
    }

    @Override
    List<String> invert(String[] value) {
        return Arrays.asList(value);
    }
}

