/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.testutil.generator;

import io.deephaven.engine.testutil.generator.AbstractReinterpretedGenerator;
import io.deephaven.time.DateTimeUtils;
import java.time.Instant;
import java.util.Random;

public class UnsortedInstantLongGenerator
extends AbstractReinterpretedGenerator<Instant, Long> {
    private final Instant minTime;
    private final Instant maxTime;
    private final double nullFrac;

    public UnsortedInstantLongGenerator(Instant minTime, Instant maxTime) {
        this(minTime, maxTime, 0.0);
    }

    public UnsortedInstantLongGenerator(Instant minTime, Instant maxTime, double nullFrac) {
        this.minTime = minTime;
        this.maxTime = maxTime;
        this.nullFrac = nullFrac;
    }

    @Override
    public Class<Long> getType() {
        return Long.class;
    }

    @Override
    public Class<Instant> getColumnType() {
        return Instant.class;
    }

    @Override
    Long nextValue(Random random) {
        if (this.nullFrac > 0.0 && random.nextDouble() < this.nullFrac) {
            return null;
        }
        long longFloor = DateTimeUtils.epochNanos((Instant)this.minTime);
        long longCeiling = DateTimeUtils.epochNanos((Instant)this.maxTime);
        long range = longCeiling - longFloor + 1L;
        long nextLong = Math.abs(random.nextLong()) % range;
        return longFloor + nextLong % range;
    }
}

