/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.testutil.locations;

import io.deephaven.base.log.LogOutput;
import io.deephaven.engine.context.ExecutionContext;
import io.deephaven.engine.updategraph.AbstractNotification;
import io.deephaven.engine.updategraph.NotificationQueue;
import io.deephaven.engine.updategraph.UpdateGraph;
import io.deephaven.engine.updategraph.UpdateSourceRegistrar;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class DependentRegistrar
implements UpdateSourceRegistrar,
Runnable {
    private final NotificationQueue.Dependency[] dependencies;
    private final UpdateGraph updateGraph;
    private final List<Runnable> dependentSources = new ArrayList<Runnable>();

    public DependentRegistrar(NotificationQueue.Dependency ... dependencies) {
        this.dependencies = dependencies;
        this.updateGraph = ExecutionContext.getContext().getUpdateGraph();
        this.updateGraph.addSource((Runnable)this);
    }

    public synchronized void addSource(@NotNull Runnable updateSource) {
        this.dependentSources.add(updateSource);
    }

    public synchronized void removeSource(@NotNull Runnable updateSource) {
        this.dependentSources.remove(updateSource);
    }

    public void requestRefresh() {
        this.updateGraph.requestRefresh();
    }

    @Override
    public void run() {
        this.updateGraph.addNotification((NotificationQueue.Notification)new AbstractNotification(false){

            public boolean canExecute(long step) {
                return DependentRegistrar.this.satisfied(step);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                DependentRegistrar dependentRegistrar = DependentRegistrar.this;
                synchronized (dependentRegistrar) {
                    int sourcesSize = DependentRegistrar.this.dependentSources.size();
                    for (int si = sourcesSize - 1; si >= 0; --si) {
                        DependentRegistrar.this.dependentSources.get(si).run();
                    }
                }
            }
        });
    }

    public LogOutput append(LogOutput logOutput) {
        return logOutput.append((CharSequence)"DependentRegistrar[").append(LogOutput.APPENDABLE_ARRAY_FORMATTER, (Object)this.dependencies).append(']');
    }

    public boolean satisfied(long step) {
        return this.updateGraph.satisfied(step) && Arrays.stream(this.dependencies).allMatch(dependency -> dependency.satisfied(step));
    }

    public UpdateGraph getUpdateGraph() {
        return this.updateGraph;
    }
}

