/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.testutil.locations;

import io.deephaven.chunk.WritableChunk;
import io.deephaven.chunk.attributes.Values;
import io.deephaven.engine.rowset.RowSequence;
import io.deephaven.engine.rowset.RowSequenceFactory;
import io.deephaven.engine.table.ChunkSource;
import io.deephaven.engine.table.ColumnDefinition;
import io.deephaven.engine.table.ColumnSource;
import io.deephaven.engine.table.impl.locations.TableLocation;
import io.deephaven.engine.table.impl.locations.impl.AbstractColumnLocation;
import io.deephaven.engine.table.impl.sources.ReinterpretUtils;
import io.deephaven.engine.table.impl.sources.regioned.ColumnRegionByte;
import io.deephaven.engine.table.impl.sources.regioned.ColumnRegionChar;
import io.deephaven.engine.table.impl.sources.regioned.ColumnRegionDouble;
import io.deephaven.engine.table.impl.sources.regioned.ColumnRegionFloat;
import io.deephaven.engine.table.impl.sources.regioned.ColumnRegionInt;
import io.deephaven.engine.table.impl.sources.regioned.ColumnRegionLong;
import io.deephaven.engine.table.impl.sources.regioned.ColumnRegionObject;
import io.deephaven.engine.table.impl.sources.regioned.ColumnRegionShort;
import io.deephaven.engine.testutil.locations.TableBackedTableLocation;
import io.deephaven.generic.region.AppendOnlyFixedSizePageRegionByte;
import io.deephaven.generic.region.AppendOnlyFixedSizePageRegionChar;
import io.deephaven.generic.region.AppendOnlyFixedSizePageRegionDouble;
import io.deephaven.generic.region.AppendOnlyFixedSizePageRegionFloat;
import io.deephaven.generic.region.AppendOnlyFixedSizePageRegionInt;
import io.deephaven.generic.region.AppendOnlyFixedSizePageRegionLong;
import io.deephaven.generic.region.AppendOnlyFixedSizePageRegionObject;
import io.deephaven.generic.region.AppendOnlyFixedSizePageRegionShort;
import io.deephaven.generic.region.AppendOnlyRegionAccessor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TableBackedColumnLocation
extends AbstractColumnLocation
implements AppendOnlyRegionAccessor<Values> {
    private static final int PAGE_SIZE = 65536;
    private final ColumnSource<?> columnSource;

    TableBackedColumnLocation(@NotNull TableBackedTableLocation tableLocation, @NotNull String name) {
        super((TableLocation)tableLocation, name);
        this.columnSource = tableLocation.table().getDefinition().getColumnNameSet().contains(name) ? ReinterpretUtils.maybeConvertToPrimitive((ColumnSource)tableLocation.table().getColumnSource(name)) : null;
    }

    public boolean exists() {
        return this.columnSource != null;
    }

    @Nullable
    public <METADATA_TYPE> METADATA_TYPE getMetadata(@NotNull ColumnDefinition<?> columnDefinition) {
        return null;
    }

    public ColumnRegionChar<Values> makeColumnRegionChar(@NotNull ColumnDefinition<?> columnDefinition) {
        return new AppendOnlyFixedSizePageRegionChar(0x7FFFFFFFFFFL, 65536, (AppendOnlyRegionAccessor)this);
    }

    public ColumnRegionByte<Values> makeColumnRegionByte(@NotNull ColumnDefinition<?> columnDefinition) {
        return new AppendOnlyFixedSizePageRegionByte(0x7FFFFFFFFFFL, 65536, (AppendOnlyRegionAccessor)this);
    }

    public ColumnRegionShort<Values> makeColumnRegionShort(@NotNull ColumnDefinition<?> columnDefinition) {
        return new AppendOnlyFixedSizePageRegionShort(0x7FFFFFFFFFFL, 65536, (AppendOnlyRegionAccessor)this);
    }

    public ColumnRegionInt<Values> makeColumnRegionInt(@NotNull ColumnDefinition<?> columnDefinition) {
        return new AppendOnlyFixedSizePageRegionInt(0x7FFFFFFFFFFL, 65536, (AppendOnlyRegionAccessor)this);
    }

    public ColumnRegionLong<Values> makeColumnRegionLong(@NotNull ColumnDefinition<?> columnDefinition) {
        return new AppendOnlyFixedSizePageRegionLong(0x7FFFFFFFFFFL, 65536, (AppendOnlyRegionAccessor)this);
    }

    public ColumnRegionFloat<Values> makeColumnRegionFloat(@NotNull ColumnDefinition<?> columnDefinition) {
        return new AppendOnlyFixedSizePageRegionFloat(0x7FFFFFFFFFFL, 65536, (AppendOnlyRegionAccessor)this);
    }

    public ColumnRegionDouble<Values> makeColumnRegionDouble(@NotNull ColumnDefinition<?> columnDefinition) {
        return new AppendOnlyFixedSizePageRegionDouble(0x7FFFFFFFFFFL, 65536, (AppendOnlyRegionAccessor)this);
    }

    public <TYPE> ColumnRegionObject<TYPE, Values> makeColumnRegionObject(@NotNull ColumnDefinition<TYPE> columnDefinition) {
        return new AppendOnlyFixedSizePageRegionObject(0x7FFFFFFFFFFL, 65536, (AppendOnlyRegionAccessor)this);
    }

    public long size() {
        return this.getTableLocation().getSize();
    }

    public void readChunkPage(long firstRowPosition, int minimumSize, @NotNull WritableChunk<Values> destination) {
        try (ChunkSource.FillContext fillContext = this.columnSource.makeFillContext(minimumSize);
             RowSequence rows = RowSequenceFactory.forRange((long)firstRowPosition, (long)(firstRowPosition + (long)minimumSize - 1L));){
            this.columnSource.fillChunk(fillContext, destination, rows);
        }
    }
}

