/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.testutil.locations;

import io.deephaven.engine.rowset.RowSet;
import io.deephaven.engine.table.impl.QueryTable;
import io.deephaven.engine.table.impl.locations.ColumnLocation;
import io.deephaven.engine.table.impl.locations.TableDataException;
import io.deephaven.engine.table.impl.locations.TableLocationKey;
import io.deephaven.engine.table.impl.locations.impl.AbstractTableLocation;
import io.deephaven.engine.table.impl.locations.impl.StandaloneTableKey;
import io.deephaven.engine.testutil.locations.TableBackedColumnLocation;
import io.deephaven.engine.testutil.locations.TableBackedTableLocationKey;
import io.deephaven.engine.updategraph.UpdateSourceRegistrar;
import org.jetbrains.annotations.NotNull;

public final class TableBackedTableLocation
extends AbstractTableLocation {
    private final UpdateSourceRegistrar registrar;
    private Runnable token;

    public TableBackedTableLocation(@NotNull UpdateSourceRegistrar registrar, @NotNull TableBackedTableLocationKey tableLocationKey) {
        super(StandaloneTableKey.getInstance(), (TableLocationKey)tableLocationKey, tableLocationKey.table.isRefreshing());
        this.registrar = registrar;
    }

    public QueryTable table() {
        return ((TableBackedTableLocationKey)this.getKey()).table;
    }

    protected void activateUnderlyingDataSource() {
        this.token = this::refresh;
        this.registrar.addSource(this.token);
        this.refresh();
        this.activationSuccessful(this.token);
    }

    protected void deactivateUnderlyingDataSource() {
        this.registrar.removeSource(this.token);
        this.token = null;
    }

    protected <T> boolean matchSubscriptionToken(T token) {
        return token == this.token;
    }

    public void refresh() {
        if (this.table().isFailed()) {
            if (this.token == null) {
                throw new TableDataException("Can't refresh from a failed table");
            }
            this.activationFailed(this.token, new TableDataException("Can't maintain subscription to a failed table"));
        } else {
            this.handleUpdate((RowSet)this.table().getRowSet().copy(), -1L);
        }
    }

    @NotNull
    protected ColumnLocation makeColumnLocation(@NotNull String name) {
        return new TableBackedColumnLocation(this, name);
    }
}

