/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.testutil.locations;

import io.deephaven.base.log.LogOutput;
import io.deephaven.base.log.LogOutputAppendable;
import io.deephaven.engine.table.impl.QueryTable;
import io.deephaven.engine.table.impl.locations.ImmutableTableLocationKey;
import io.deephaven.engine.table.impl.locations.TableLocationKey;
import io.deephaven.engine.table.impl.locations.UnknownPartitionKeyException;
import io.deephaven.io.log.impl.LogOutputStringImpl;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TableBackedTableLocationKey
implements ImmutableTableLocationKey {
    private static final String NAME = TableBackedTableLocationKey.class.getSimpleName();
    final QueryTable table;

    public TableBackedTableLocationKey(@NotNull QueryTable table) {
        this.table = table;
    }

    public QueryTable table() {
        return this.table;
    }

    public String getImplementationName() {
        return NAME;
    }

    public LogOutput append(LogOutput logOutput) {
        return logOutput.append((CharSequence)NAME).append('[').append((LogOutputAppendable)this.table).append(']');
    }

    public String toString() {
        return new LogOutputStringImpl().append((LogOutputAppendable)this).toString();
    }

    public int compareTo(@NotNull TableLocationKey other) {
        return Integer.compare((Integer)this.table.getAttribute("ID"), (Integer)((TableBackedTableLocationKey)other).table.getAttribute("ID"));
    }

    public int hashCode() {
        return System.identityHashCode(this.table);
    }

    public boolean equals(@Nullable Object other) {
        return other == this || other instanceof TableBackedTableLocationKey && ((TableBackedTableLocationKey)other).table == this.table;
    }

    public <PARTITION_VALUE_TYPE extends Comparable<PARTITION_VALUE_TYPE>> PARTITION_VALUE_TYPE getPartitionValue(@NotNull String partitionKey) {
        throw new UnknownPartitionKeyException(partitionKey, (TableLocationKey)this);
    }

    public Set<String> getPartitionKeys() {
        return Collections.emptySet();
    }
}

