/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.testutil.locations;

import io.deephaven.base.verify.Assert;
import io.deephaven.engine.table.Table;
import io.deephaven.engine.table.impl.QueryTable;
import io.deephaven.engine.table.impl.locations.TableLocation;
import io.deephaven.engine.table.impl.locations.TableLocationKey;
import io.deephaven.engine.table.impl.locations.impl.AbstractTableLocationProvider;
import io.deephaven.engine.table.impl.locations.impl.StandaloneTableKey;
import io.deephaven.engine.testutil.locations.TableBackedTableLocation;
import io.deephaven.engine.testutil.locations.TableBackedTableLocationKey;
import io.deephaven.engine.updategraph.UpdateSourceRegistrar;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.commons.lang3.mutable.MutableInt;
import org.jetbrains.annotations.NotNull;

public final class TableBackedTableLocationProvider
extends AbstractTableLocationProvider {
    public static final String LOCATION_ID_ATTR = "ID";
    private final UpdateSourceRegistrar registrar;
    private final List<Table> pending = new ArrayList<Table>();
    private final MutableInt nextId = new MutableInt();

    public TableBackedTableLocationProvider(@NotNull UpdateSourceRegistrar registrar, boolean supportsSubscriptions, Table ... tables) {
        super(StandaloneTableKey.getInstance(), supportsSubscriptions);
        this.registrar = registrar;
        this.processPending(Arrays.stream(tables));
    }

    private void processPending(@NotNull Stream<Table> tableStream) {
        tableStream.map(table -> (QueryTable)table.coalesce().withAttributes(Map.of(LOCATION_ID_ATTR, this.nextId.getAndIncrement()))).peek(table -> Assert.assertion((boolean)table.isAppendOnly(), (String)"table is append only")).map(TableBackedTableLocationKey::new).forEach(arg_0 -> ((TableBackedTableLocationProvider)this).handleTableLocationKey(arg_0));
    }

    public synchronized void addPending(@NotNull Table toAdd) {
        this.pending.add(toAdd);
    }

    protected void activateUnderlyingDataSource() {
        this.activationSuccessful((Object)this);
    }

    protected <T> boolean matchSubscriptionToken(T token) {
        return token == this;
    }

    protected void deactivateUnderlyingDataSource() {
    }

    public void refresh() {
        if (this.pending.isEmpty()) {
            return;
        }
        this.processPending(this.pending.stream());
        this.pending.clear();
    }

    @NotNull
    protected TableLocation makeTableLocation(@NotNull TableLocationKey locationKey) {
        return new TableBackedTableLocation(this.registrar, (TableBackedTableLocationKey)locationKey);
    }
}

