/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.testutil.sources;

import io.deephaven.base.verify.Assert;
import io.deephaven.chunk.ByteChunk;
import io.deephaven.chunk.Chunk;
import io.deephaven.chunk.ChunkType;
import io.deephaven.chunk.ObjectChunk;
import io.deephaven.chunk.attributes.Values;
import io.deephaven.engine.rowset.RowSet;
import io.deephaven.engine.rowset.RowSetBuilderRandom;
import io.deephaven.engine.rowset.RowSetFactory;
import io.deephaven.engine.rowset.WritableRowSet;
import io.deephaven.engine.table.impl.AbstractColumnSource;
import io.deephaven.engine.table.impl.MutableColumnSourceGetDefaults;
import io.deephaven.engine.testutil.sources.TestColumnSource;
import io.deephaven.engine.updategraph.UpdateCommitter;
import io.deephaven.util.type.TypeUtils;
import it.unimi.dsi.fastutil.longs.Long2ByteMap;
import it.unimi.dsi.fastutil.longs.Long2ByteOpenHashMap;
import java.util.function.LongConsumer;
import org.apache.commons.lang3.mutable.MutableInt;

public class ByteTestSource
extends AbstractColumnSource<Byte>
implements MutableColumnSourceGetDefaults.ForByte,
TestColumnSource<Byte> {
    private long lastAdditionTime;
    protected final Long2ByteOpenHashMap data = new Long2ByteOpenHashMap();
    protected Long2ByteOpenHashMap prevData;
    private final UpdateCommitter<ByteTestSource> prevFlusher = new UpdateCommitter((Object)this, this.updateGraph, ByteTestSource::flushPrevious);

    public ByteTestSource() {
        this((RowSet)RowSetFactory.empty(), (Chunk<Values>)ByteChunk.getEmptyChunk());
    }

    public ByteTestSource(RowSet rowSet, Chunk<Values> data) {
        super(Byte.TYPE);
        this.lastAdditionTime = this.updateGraph.clock().currentStep();
        this.add(rowSet, data);
        this.setDefaultReturnValue(this.data);
        this.prevData = this.data;
    }

    private void setDefaultReturnValue(Long2ByteOpenHashMap data) {
        data.defaultReturnValue((byte)-128);
    }

    public synchronized void checkIndex(RowSet rowSet) {
        Assert.eq((long)this.data.size(), (String)"data.size()", (long)rowSet.size(), (String)"rowSet.size()");
        RowSetBuilderRandom builder = RowSetFactory.builderRandom();
        this.data.keySet().forEach(arg_0 -> ((RowSetBuilderRandom)builder).addKey(arg_0));
        WritableRowSet dataRowSet = builder.build();
        Assert.equals((Object)dataRowSet, (String)"dataRowSet", (Object)rowSet, (String)"rowSet");
    }

    @Override
    public synchronized void add(RowSet rowSet, Chunk<Values> vs) {
        this.setGroupToRange(null);
        if (rowSet.size() != (long)vs.size()) {
            throw new IllegalArgumentException("Index=" + rowSet + ", data size=" + vs.size());
        }
        this.maybeInitializePrevForStep();
        if (vs.getChunkType() == ChunkType.Byte) {
            final ByteChunk vcs = vs.asByteChunk();
            rowSet.forAllRowKeys(new LongConsumer(){
                private final MutableInt ii = new MutableInt(0);

                @Override
                public void accept(long v) {
                    ByteTestSource.this.data.put(v, vcs.get(this.ii.intValue()));
                    this.ii.increment();
                }
            });
        } else if (vs.getChunkType() == ChunkType.Object) {
            final ObjectChunk vcs = vs.asObjectChunk();
            rowSet.forAllRowKeys(new LongConsumer(){
                private final MutableInt ii = new MutableInt(0);

                @Override
                public void accept(long v) {
                    ByteTestSource.this.data.put(v, TypeUtils.unbox((Byte)((Byte)vcs.get(this.ii.intValue()))));
                    this.ii.increment();
                }
            });
        } else {
            throw new IllegalArgumentException("Invalid chunk type for " + this.getClass() + ": " + vs.getChunkType());
        }
    }

    private void maybeInitializePrevForStep() {
        long currentStep = this.updateGraph.clock().currentStep();
        if (currentStep == this.lastAdditionTime) {
            return;
        }
        this.prevFlusher.maybeActivate();
        this.prevData = new Long2ByteOpenHashMap((Long2ByteMap)this.data);
        this.setDefaultReturnValue(this.prevData);
        this.lastAdditionTime = currentStep;
    }

    @Override
    public synchronized void remove(RowSet rowSet) {
        this.setGroupToRange(null);
        this.maybeInitializePrevForStep();
        rowSet.forAllRowKeys(arg_0 -> ((Long2ByteOpenHashMap)this.data).remove(arg_0));
    }

    @Override
    public synchronized void shift(long startKeyInclusive, long endKeyInclusive, long shiftDelta) {
        long offset;
        this.maybeInitializePrevForStep();
        this.setGroupToRange(null);
        long dir = shiftDelta > 0L ? -1L : 1L;
        long len = endKeyInclusive - startKeyInclusive + 1L;
        long l = offset = dir < 0L ? len - 1L : 0L;
        while (dir < 0L ? offset >= 0L : offset < len) {
            if (this.data.containsKey(startKeyInclusive + offset)) {
                this.data.put(startKeyInclusive + offset + shiftDelta, this.data.remove(startKeyInclusive + offset));
            }
            offset += dir;
        }
    }

    public Byte get(long index) {
        return TypeUtils.box((byte)this.getByte(index));
    }

    public synchronized byte getByte(long index) {
        if (index == -1L) {
            return -128;
        }
        byte retVal = this.data.get(index);
        if (retVal == -128 && !this.data.containsKey(index)) {
            throw new IllegalStateException("Asking for a non-existent key: " + index);
        }
        return retVal;
    }

    public boolean isImmutable() {
        return false;
    }

    public Byte getPrev(long index) {
        return TypeUtils.box((byte)this.getPrevByte(index));
    }

    public synchronized byte getPrevByte(long index) {
        if (index == -1L) {
            return -128;
        }
        if (this.prevData == null) {
            return this.getByte(index);
        }
        byte retVal = this.prevData.get(index);
        if (retVal == -128 && !this.prevData.containsKey(index)) {
            throw new IllegalStateException("Asking for a non-existent previous key: " + index);
        }
        return retVal;
    }

    public static void flushPrevious(ByteTestSource source) {
        source.prevData = null;
    }

    public void startTrackingPrevValues() {
    }
}

