/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.testutil.sources;

import io.deephaven.base.verify.Assert;
import io.deephaven.chunk.Chunk;
import io.deephaven.chunk.ChunkType;
import io.deephaven.chunk.DoubleChunk;
import io.deephaven.chunk.ObjectChunk;
import io.deephaven.chunk.attributes.Values;
import io.deephaven.engine.rowset.RowSet;
import io.deephaven.engine.rowset.RowSetBuilderSequential;
import io.deephaven.engine.rowset.RowSetFactory;
import io.deephaven.engine.rowset.WritableRowSet;
import io.deephaven.engine.table.impl.AbstractColumnSource;
import io.deephaven.engine.table.impl.ImmutableColumnSourceGetDefaults;
import io.deephaven.engine.testutil.sources.TestColumnSource;
import io.deephaven.util.type.TypeUtils;
import it.unimi.dsi.fastutil.longs.Long2DoubleOpenHashMap;
import java.util.function.LongConsumer;
import org.apache.commons.lang3.mutable.MutableInt;

public class ImmutableDoubleTestSource
extends AbstractColumnSource<Double>
implements ImmutableColumnSourceGetDefaults.ForDouble,
TestColumnSource<Double> {
    protected final Long2DoubleOpenHashMap data = new Long2DoubleOpenHashMap();

    public ImmutableDoubleTestSource() {
        this((RowSet)RowSetFactory.empty(), (Chunk<Values>)DoubleChunk.getEmptyChunk());
    }

    public ImmutableDoubleTestSource(RowSet rowSet, Chunk<Values> data) {
        super(Double.TYPE);
        this.add(rowSet, data);
        this.setDefaultReturnValue(this.data);
    }

    private void setDefaultReturnValue(Long2DoubleOpenHashMap data) {
        data.defaultReturnValue(-1.7976931348623157E308);
    }

    public synchronized void checkIndex(RowSet rowSet) {
        Assert.eq((long)this.data.size(), (String)"data.size()", (long)rowSet.size(), (String)"rowSet.size()");
        RowSetBuilderSequential builder = RowSetFactory.builderSequential();
        this.data.keySet().forEach(arg_0 -> ((RowSetBuilderSequential)builder).appendKey(arg_0));
        WritableRowSet dataRowSet = builder.build();
        Assert.equals((Object)dataRowSet, (String)"dataRowSet", (Object)rowSet, (String)"rowSet");
    }

    @Override
    public synchronized void add(RowSet rowSet, Chunk<Values> vs) {
        this.setGroupToRange(null);
        if (rowSet.size() != (long)vs.size()) {
            throw new IllegalArgumentException("Index=" + rowSet + ", data size=" + vs.size());
        }
        if (vs.getChunkType() == ChunkType.Double) {
            final DoubleChunk vcs = vs.asDoubleChunk();
            rowSet.forAllRowKeys(new LongConsumer(){
                private final MutableInt ii = new MutableInt(0);

                @Override
                public void accept(long v) {
                    if (!ImmutableDoubleTestSource.this.data.containsKey(v)) {
                        ImmutableDoubleTestSource.this.data.put(v, vcs.get(this.ii.intValue()));
                    }
                    this.ii.increment();
                }
            });
        } else if (vs.getChunkType() == ChunkType.Object) {
            final ObjectChunk vcs = vs.asObjectChunk();
            rowSet.forAllRowKeys(new LongConsumer(){
                private final MutableInt ii = new MutableInt(0);

                @Override
                public void accept(long v) {
                    if (!ImmutableDoubleTestSource.this.data.containsKey(v)) {
                        ImmutableDoubleTestSource.this.data.put(v, TypeUtils.unbox((Double)((Double)vcs.get(this.ii.intValue()))));
                    }
                    this.ii.increment();
                }
            });
        }
    }

    @Override
    public synchronized void remove(RowSet rowSet) {
        throw new IllegalStateException();
    }

    @Override
    public synchronized void shift(long startKeyInclusive, long endKeyInclusive, long shiftDelta) {
        throw new IllegalStateException();
    }

    public Double get(long index) {
        return TypeUtils.box((double)this.getDouble(index));
    }

    public synchronized double getDouble(long index) {
        if (index == -1L) {
            return -1.7976931348623157E308;
        }
        double retVal = this.data.get(index);
        if (retVal == -1.7976931348623157E308 && !this.data.containsKey(index)) {
            throw new IllegalStateException("Asking for a non-existent key: " + index);
        }
        return retVal;
    }

    public boolean isImmutable() {
        return true;
    }

    public void startTrackingPrevValues() {
    }
}

