/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.testutil.sources;

import io.deephaven.chunk.Chunk;
import io.deephaven.chunk.ChunkType;
import io.deephaven.chunk.LongChunk;
import io.deephaven.chunk.ObjectChunk;
import io.deephaven.chunk.attributes.Values;
import io.deephaven.engine.rowset.RowSet;
import io.deephaven.engine.table.ColumnSource;
import io.deephaven.engine.table.impl.AbstractColumnSource;
import io.deephaven.engine.table.impl.MutableColumnSourceGetDefaults;
import io.deephaven.engine.testutil.sources.ImmutableLongTestSource;
import io.deephaven.engine.testutil.sources.TestColumnSource;
import io.deephaven.engine.testutil.sources.UnboxedInstantTestSource;
import io.deephaven.time.DateTimeUtils;
import io.deephaven.util.type.TypeUtils;
import java.time.Instant;
import org.jetbrains.annotations.NotNull;

public class ImmutableInstantTestSource
extends AbstractColumnSource<Instant>
implements MutableColumnSourceGetDefaults.ForObject<Instant>,
TestColumnSource<Instant> {
    private final ImmutableLongTestSource longTestSource;
    private final UnboxedInstantTestSource alternateColumnSource;

    public ImmutableInstantTestSource() {
        super(Instant.class);
        this.longTestSource = new ImmutableLongTestSource();
        this.alternateColumnSource = new UnboxedInstantTestSource((ColumnSource<Instant>)this, this.longTestSource);
    }

    public ImmutableInstantTestSource(RowSet rowSet, Chunk<Values> data) {
        super(Instant.class);
        this.longTestSource = data.getChunkType() == ChunkType.Long ? new ImmutableLongTestSource(rowSet, (Chunk<Values>)data.asLongChunk()) : new ImmutableLongTestSource(rowSet, (Chunk<Values>)this.mapData(data.asObjectChunk()));
        this.alternateColumnSource = new UnboxedInstantTestSource((ColumnSource<Instant>)this, this.longTestSource);
    }

    private LongChunk<Values> mapData(ObjectChunk<?, Values> data) {
        long[] result = new long[data.size()];
        if (result.length > 0 && data.get(0) instanceof Long) {
            ObjectChunk boxedLongChunk = data.asObjectChunk();
            for (int ii = 0; ii < result.length; ++ii) {
                result[ii] = TypeUtils.unbox((Long)((Long)boxedLongChunk.get(ii)));
            }
        } else {
            ObjectChunk dtc = data.asObjectChunk();
            for (int ii = 0; ii < result.length; ++ii) {
                Instant dt = (Instant)dtc.get(ii);
                result[ii] = dt == null ? Long.MIN_VALUE : DateTimeUtils.epochNanos((Instant)dt);
            }
        }
        return LongChunk.chunkWrap((long[])result);
    }

    @Override
    public void add(RowSet rowSet, Chunk<Values> data) {
        if (data.getChunkType() == ChunkType.Long) {
            this.longTestSource.add(rowSet, (Chunk<Values>)data.asLongChunk());
        } else if (data.getChunkType() == ChunkType.Object) {
            this.longTestSource.add(rowSet, (Chunk<Values>)this.mapData(data.asObjectChunk()));
        } else {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public void remove(RowSet rowSet) {
        this.longTestSource.remove(rowSet);
    }

    @Override
    public void shift(long startKeyInclusive, long endKeyInclusive, long shiftDelta) {
        this.longTestSource.shift(startKeyInclusive, endKeyInclusive, shiftDelta);
    }

    public Instant get(long index) {
        Long v = this.longTestSource.get(index);
        return v == null ? null : DateTimeUtils.epochNanosToInstant((long)v);
    }

    public boolean isImmutable() {
        return false;
    }

    public long getLong(long index) {
        return this.longTestSource.getLong(index);
    }

    public Instant getPrev(long index) {
        Long v = (Long)this.longTestSource.getPrev(index);
        return v == null ? null : DateTimeUtils.epochNanosToInstant((long)v);
    }

    public long getPrevLong(long rowKey) {
        return this.longTestSource.getPrevLong(rowKey);
    }

    public <ALTERNATE_DATA_TYPE> boolean allowsReinterpret(@NotNull Class<ALTERNATE_DATA_TYPE> alternateDataType) {
        return alternateDataType == Long.TYPE;
    }

    public <ALTERNATE_DATA_TYPE> ColumnSource<ALTERNATE_DATA_TYPE> doReinterpret(@NotNull Class<ALTERNATE_DATA_TYPE> alternateDataType) throws IllegalArgumentException {
        return this.alternateColumnSource;
    }
}

