/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.testutil.sources;

import io.deephaven.base.verify.Assert;
import io.deephaven.chunk.Chunk;
import io.deephaven.chunk.ChunkType;
import io.deephaven.chunk.IntChunk;
import io.deephaven.chunk.ObjectChunk;
import io.deephaven.chunk.attributes.Values;
import io.deephaven.engine.rowset.RowSet;
import io.deephaven.engine.rowset.RowSetBuilderSequential;
import io.deephaven.engine.rowset.RowSetFactory;
import io.deephaven.engine.rowset.WritableRowSet;
import io.deephaven.engine.table.impl.AbstractColumnSource;
import io.deephaven.engine.table.impl.ImmutableColumnSourceGetDefaults;
import io.deephaven.engine.testutil.sources.TestColumnSource;
import io.deephaven.util.type.TypeUtils;
import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import java.util.function.LongConsumer;
import org.apache.commons.lang3.mutable.MutableInt;

public class ImmutableIntTestSource
extends AbstractColumnSource<Integer>
implements ImmutableColumnSourceGetDefaults.ForInt,
TestColumnSource<Integer> {
    protected final Long2IntOpenHashMap data = new Long2IntOpenHashMap();

    public ImmutableIntTestSource() {
        this((RowSet)RowSetFactory.empty(), (Chunk<Values>)IntChunk.getEmptyChunk());
    }

    public ImmutableIntTestSource(RowSet rowSet, Chunk<Values> data) {
        super(Integer.TYPE);
        this.add(rowSet, data);
        this.setDefaultReturnValue(this.data);
    }

    private void setDefaultReturnValue(Long2IntOpenHashMap data) {
        data.defaultReturnValue(Integer.MIN_VALUE);
    }

    public synchronized void checkIndex(RowSet rowSet) {
        Assert.eq((long)this.data.size(), (String)"data.size()", (long)rowSet.size(), (String)"rowSet.size()");
        RowSetBuilderSequential builder = RowSetFactory.builderSequential();
        this.data.keySet().forEach(arg_0 -> ((RowSetBuilderSequential)builder).appendKey(arg_0));
        WritableRowSet dataRowSet = builder.build();
        Assert.equals((Object)dataRowSet, (String)"dataRowSet", (Object)rowSet, (String)"rowSet");
    }

    @Override
    public synchronized void add(RowSet rowSet, Chunk<Values> vs) {
        this.setGroupToRange(null);
        if (rowSet.size() != (long)vs.size()) {
            throw new IllegalArgumentException("Index=" + rowSet + ", data size=" + vs.size());
        }
        if (vs.getChunkType() == ChunkType.Int) {
            final IntChunk vcs = vs.asIntChunk();
            rowSet.forAllRowKeys(new LongConsumer(){
                private final MutableInt ii = new MutableInt(0);

                @Override
                public void accept(long v) {
                    if (!ImmutableIntTestSource.this.data.containsKey(v)) {
                        ImmutableIntTestSource.this.data.put(v, vcs.get(this.ii.intValue()));
                    }
                    this.ii.increment();
                }
            });
        } else if (vs.getChunkType() == ChunkType.Object) {
            final ObjectChunk vcs = vs.asObjectChunk();
            rowSet.forAllRowKeys(new LongConsumer(){
                private final MutableInt ii = new MutableInt(0);

                @Override
                public void accept(long v) {
                    if (!ImmutableIntTestSource.this.data.containsKey(v)) {
                        ImmutableIntTestSource.this.data.put(v, TypeUtils.unbox((Integer)((Integer)vcs.get(this.ii.intValue()))));
                    }
                    this.ii.increment();
                }
            });
        }
    }

    @Override
    public synchronized void remove(RowSet rowSet) {
        throw new IllegalStateException();
    }

    @Override
    public synchronized void shift(long startKeyInclusive, long endKeyInclusive, long shiftDelta) {
        throw new IllegalStateException();
    }

    public Integer get(long index) {
        return TypeUtils.box((int)this.getInt(index));
    }

    public synchronized int getInt(long index) {
        if (index == -1L) {
            return Integer.MIN_VALUE;
        }
        int retVal = this.data.get(index);
        if (retVal == Integer.MIN_VALUE && !this.data.containsKey(index)) {
            throw new IllegalStateException("Asking for a non-existent key: " + index);
        }
        return retVal;
    }

    public boolean isImmutable() {
        return true;
    }

    public void startTrackingPrevValues() {
    }
}

