/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.testutil.sources;

import io.deephaven.base.verify.Assert;
import io.deephaven.chunk.Chunk;
import io.deephaven.chunk.ChunkType;
import io.deephaven.chunk.LongChunk;
import io.deephaven.chunk.ObjectChunk;
import io.deephaven.chunk.attributes.Values;
import io.deephaven.engine.rowset.RowSet;
import io.deephaven.engine.rowset.RowSetBuilderSequential;
import io.deephaven.engine.rowset.RowSetFactory;
import io.deephaven.engine.rowset.WritableRowSet;
import io.deephaven.engine.table.impl.AbstractColumnSource;
import io.deephaven.engine.table.impl.ImmutableColumnSourceGetDefaults;
import io.deephaven.engine.testutil.sources.TestColumnSource;
import io.deephaven.util.type.TypeUtils;
import it.unimi.dsi.fastutil.longs.Long2LongOpenHashMap;
import java.util.function.LongConsumer;
import org.apache.commons.lang3.mutable.MutableInt;

public class ImmutableLongTestSource
extends AbstractColumnSource<Long>
implements ImmutableColumnSourceGetDefaults.ForLong,
TestColumnSource<Long> {
    protected final Long2LongOpenHashMap data = new Long2LongOpenHashMap();

    public ImmutableLongTestSource() {
        this((RowSet)RowSetFactory.empty(), (Chunk<Values>)LongChunk.getEmptyChunk());
    }

    public ImmutableLongTestSource(RowSet rowSet, Chunk<Values> data) {
        super(Long.TYPE);
        this.add(rowSet, data);
        this.setDefaultReturnValue(this.data);
    }

    private void setDefaultReturnValue(Long2LongOpenHashMap data) {
        data.defaultReturnValue(Long.MIN_VALUE);
    }

    public synchronized void checkIndex(RowSet rowSet) {
        Assert.eq((long)this.data.size(), (String)"data.size()", (long)rowSet.size(), (String)"rowSet.size()");
        RowSetBuilderSequential builder = RowSetFactory.builderSequential();
        this.data.keySet().forEach(arg_0 -> ((RowSetBuilderSequential)builder).appendKey(arg_0));
        WritableRowSet dataRowSet = builder.build();
        Assert.equals((Object)dataRowSet, (String)"dataRowSet", (Object)rowSet, (String)"rowSet");
    }

    @Override
    public synchronized void add(RowSet rowSet, Chunk<Values> vs) {
        this.setGroupToRange(null);
        if (rowSet.size() != (long)vs.size()) {
            throw new IllegalArgumentException("Index=" + rowSet + ", data size=" + vs.size());
        }
        if (vs.getChunkType() == ChunkType.Long) {
            final LongChunk vcs = vs.asLongChunk();
            rowSet.forAllRowKeys(new LongConsumer(){
                private final MutableInt ii = new MutableInt(0);

                @Override
                public void accept(long v) {
                    if (!ImmutableLongTestSource.this.data.containsKey(v)) {
                        ImmutableLongTestSource.this.data.put(v, vcs.get(this.ii.intValue()));
                    }
                    this.ii.increment();
                }
            });
        } else if (vs.getChunkType() == ChunkType.Object) {
            final ObjectChunk vcs = vs.asObjectChunk();
            rowSet.forAllRowKeys(new LongConsumer(){
                private final MutableInt ii = new MutableInt(0);

                @Override
                public void accept(long v) {
                    if (!ImmutableLongTestSource.this.data.containsKey(v)) {
                        ImmutableLongTestSource.this.data.put(v, TypeUtils.unbox((Long)((Long)vcs.get(this.ii.intValue()))));
                    }
                    this.ii.increment();
                }
            });
        }
    }

    @Override
    public synchronized void remove(RowSet rowSet) {
        throw new IllegalStateException();
    }

    @Override
    public synchronized void shift(long startKeyInclusive, long endKeyInclusive, long shiftDelta) {
        throw new IllegalStateException();
    }

    public Long get(long index) {
        return TypeUtils.box((long)this.getLong(index));
    }

    public synchronized long getLong(long index) {
        if (index == -1L) {
            return Long.MIN_VALUE;
        }
        long retVal = this.data.get(index);
        if (retVal == Long.MIN_VALUE && !this.data.containsKey(index)) {
            throw new IllegalStateException("Asking for a non-existent key: " + index);
        }
        return retVal;
    }

    public boolean isImmutable() {
        return true;
    }

    public void startTrackingPrevValues() {
    }
}

