/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.testutil.sources;

import io.deephaven.base.verify.Assert;
import io.deephaven.chunk.Chunk;
import io.deephaven.chunk.ObjectChunk;
import io.deephaven.chunk.attributes.Values;
import io.deephaven.engine.rowset.RowSet;
import io.deephaven.engine.rowset.RowSetBuilderSequential;
import io.deephaven.engine.rowset.RowSetFactory;
import io.deephaven.engine.rowset.WritableRowSet;
import io.deephaven.engine.table.impl.AbstractColumnSource;
import io.deephaven.engine.table.impl.ImmutableColumnSourceGetDefaults;
import io.deephaven.engine.testutil.sources.TestColumnSource;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.function.LongConsumer;
import org.apache.commons.lang3.mutable.MutableInt;

public class ImmutableObjectTestSource<T>
extends AbstractColumnSource<T>
implements ImmutableColumnSourceGetDefaults.ForObject<T>,
TestColumnSource<T> {
    protected final Long2ObjectOpenHashMap<T> data = new Long2ObjectOpenHashMap();

    public ImmutableObjectTestSource(Class<T> type) {
        this(type, (RowSet)RowSetFactory.empty(), (Chunk<Values>)ObjectChunk.getEmptyChunk());
    }

    public ImmutableObjectTestSource(Class<T> type, RowSet rowSet, Chunk<Values> data) {
        super(type);
        this.add(rowSet, data);
        this.setDefaultReturnValue(this.data);
    }

    private void setDefaultReturnValue(Long2ObjectOpenHashMap<T> data) {
        data.defaultReturnValue(null);
    }

    public synchronized void checkIndex(RowSet rowSet) {
        Assert.eq((long)this.data.size(), (String)"data.size()", (long)rowSet.size(), (String)"rowSet.size()");
        RowSetBuilderSequential builder = RowSetFactory.builderSequential();
        this.data.keySet().forEach(arg_0 -> ((RowSetBuilderSequential)builder).appendKey(arg_0));
        WritableRowSet dataRowSet = builder.build();
        Assert.equals((Object)dataRowSet, (String)"dataRowSet", (Object)rowSet, (String)"rowSet");
    }

    @Override
    public synchronized void add(RowSet rowSet, Chunk<Values> vs) {
        this.setGroupToRange(null);
        if (rowSet.size() != (long)vs.size()) {
            throw new IllegalArgumentException("rowSet=" + rowSet + ", data size=" + vs.size());
        }
        final ObjectChunk vcs = vs.asObjectChunk();
        rowSet.forAllRowKeys(new LongConsumer(){
            private final MutableInt ii = new MutableInt(0);

            @Override
            public void accept(long v) {
                if (!ImmutableObjectTestSource.this.data.containsKey(v)) {
                    ImmutableObjectTestSource.this.data.put(v, vcs.get(this.ii.intValue()));
                }
                this.ii.increment();
            }
        });
    }

    @Override
    public synchronized void remove(RowSet rowSet) {
        throw new IllegalStateException();
    }

    @Override
    public synchronized void shift(long startKeyInclusive, long endKeyInclusive, long shiftDelta) {
        throw new IllegalStateException();
    }

    public synchronized T get(long index) {
        if (index == -1L) {
            return null;
        }
        Object retVal = this.data.get(index);
        if (retVal == null && !this.data.containsKey(index)) {
            throw new IllegalStateException("Asking for a non-existent key: " + index);
        }
        return (T)retVal;
    }

    public boolean isImmutable() {
        return true;
    }

    public void startTrackingPrevValues() {
    }
}

