/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.testutil.sources;

import io.deephaven.base.verify.Assert;
import io.deephaven.chunk.Chunk;
import io.deephaven.chunk.ChunkType;
import io.deephaven.chunk.ObjectChunk;
import io.deephaven.chunk.ShortChunk;
import io.deephaven.chunk.attributes.Values;
import io.deephaven.engine.rowset.RowSet;
import io.deephaven.engine.rowset.RowSetBuilderSequential;
import io.deephaven.engine.rowset.RowSetFactory;
import io.deephaven.engine.rowset.WritableRowSet;
import io.deephaven.engine.table.impl.AbstractColumnSource;
import io.deephaven.engine.table.impl.ImmutableColumnSourceGetDefaults;
import io.deephaven.engine.testutil.sources.TestColumnSource;
import io.deephaven.util.type.TypeUtils;
import it.unimi.dsi.fastutil.longs.Long2ShortOpenHashMap;
import java.util.function.LongConsumer;
import org.apache.commons.lang3.mutable.MutableInt;

public class ImmutableShortTestSource
extends AbstractColumnSource<Short>
implements ImmutableColumnSourceGetDefaults.ForShort,
TestColumnSource<Short> {
    protected final Long2ShortOpenHashMap data = new Long2ShortOpenHashMap();

    public ImmutableShortTestSource() {
        this((RowSet)RowSetFactory.empty(), (Chunk<Values>)ShortChunk.getEmptyChunk());
    }

    public ImmutableShortTestSource(RowSet rowSet, Chunk<Values> data) {
        super(Short.TYPE);
        this.add(rowSet, data);
        this.setDefaultReturnValue(this.data);
    }

    private void setDefaultReturnValue(Long2ShortOpenHashMap data) {
        data.defaultReturnValue((short)Short.MIN_VALUE);
    }

    public synchronized void checkIndex(RowSet rowSet) {
        Assert.eq((long)this.data.size(), (String)"data.size()", (long)rowSet.size(), (String)"rowSet.size()");
        RowSetBuilderSequential builder = RowSetFactory.builderSequential();
        this.data.keySet().forEach(arg_0 -> ((RowSetBuilderSequential)builder).appendKey(arg_0));
        WritableRowSet dataRowSet = builder.build();
        Assert.equals((Object)dataRowSet, (String)"dataRowSet", (Object)rowSet, (String)"rowSet");
    }

    @Override
    public synchronized void add(RowSet rowSet, Chunk<Values> vs) {
        this.setGroupToRange(null);
        if (rowSet.size() != (long)vs.size()) {
            throw new IllegalArgumentException("Index=" + rowSet + ", data size=" + vs.size());
        }
        if (vs.getChunkType() == ChunkType.Short) {
            final ShortChunk vcs = vs.asShortChunk();
            rowSet.forAllRowKeys(new LongConsumer(){
                private final MutableInt ii = new MutableInt(0);

                @Override
                public void accept(long v) {
                    if (!ImmutableShortTestSource.this.data.containsKey(v)) {
                        ImmutableShortTestSource.this.data.put(v, vcs.get(this.ii.intValue()));
                    }
                    this.ii.increment();
                }
            });
        } else if (vs.getChunkType() == ChunkType.Object) {
            final ObjectChunk vcs = vs.asObjectChunk();
            rowSet.forAllRowKeys(new LongConsumer(){
                private final MutableInt ii = new MutableInt(0);

                @Override
                public void accept(long v) {
                    if (!ImmutableShortTestSource.this.data.containsKey(v)) {
                        ImmutableShortTestSource.this.data.put(v, TypeUtils.unbox((Short)((Short)vcs.get(this.ii.intValue()))));
                    }
                    this.ii.increment();
                }
            });
        }
    }

    @Override
    public synchronized void remove(RowSet rowSet) {
        throw new IllegalStateException();
    }

    @Override
    public synchronized void shift(long startKeyInclusive, long endKeyInclusive, long shiftDelta) {
        throw new IllegalStateException();
    }

    public Short get(long index) {
        return TypeUtils.box((short)this.getShort(index));
    }

    public synchronized short getShort(long index) {
        if (index == -1L) {
            return Short.MIN_VALUE;
        }
        short retVal = this.data.get(index);
        if (retVal == Short.MIN_VALUE && !this.data.containsKey(index)) {
            throw new IllegalStateException("Asking for a non-existent key: " + index);
        }
        return retVal;
    }

    public boolean isImmutable() {
        return true;
    }

    public void startTrackingPrevValues() {
    }
}

