/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.testutil.sources;

import io.deephaven.chunk.Chunk;
import io.deephaven.chunk.ChunkType;
import io.deephaven.chunk.LongChunk;
import io.deephaven.chunk.ObjectChunk;
import io.deephaven.chunk.attributes.Values;
import io.deephaven.engine.rowset.RowSet;
import io.deephaven.engine.table.ColumnSource;
import io.deephaven.engine.table.impl.AbstractColumnSource;
import io.deephaven.engine.table.impl.MutableColumnSourceGetDefaults;
import io.deephaven.engine.testutil.sources.LongTestSource;
import io.deephaven.engine.testutil.sources.TestColumnSource;
import io.deephaven.engine.testutil.sources.UnboxedInstantTestSource;
import io.deephaven.time.DateTimeUtils;
import io.deephaven.util.type.TypeUtils;
import java.time.Instant;
import org.jetbrains.annotations.NotNull;

public class InstantTestSource
extends AbstractColumnSource<Instant>
implements MutableColumnSourceGetDefaults.ForObject<Instant>,
TestColumnSource<Instant> {
    private final LongTestSource longTestSource;
    private final UnboxedInstantTestSource alternateColumnSource;

    public InstantTestSource() {
        super(Instant.class);
        this.longTestSource = new LongTestSource();
        this.alternateColumnSource = new UnboxedInstantTestSource((ColumnSource<Instant>)this, this.longTestSource);
    }

    public InstantTestSource(RowSet rowSet, Instant[] data) {
        super(Instant.class);
        this.longTestSource = new LongTestSource(rowSet, (Chunk<Values>)this.mapData(data));
        this.alternateColumnSource = new UnboxedInstantTestSource((ColumnSource<Instant>)this, this.longTestSource);
    }

    public InstantTestSource(RowSet rowSet, Chunk<Values> data) {
        super(Instant.class);
        this.longTestSource = data.getChunkType() == ChunkType.Long ? new LongTestSource(rowSet, (Chunk<Values>)data.asLongChunk()) : new LongTestSource(rowSet, (Chunk<Values>)this.mapData(data.asObjectChunk()));
        this.alternateColumnSource = new UnboxedInstantTestSource((ColumnSource<Instant>)this, this.longTestSource);
    }

    private LongChunk<Values> mapData(Instant[] data) {
        long[] result = new long[data.length];
        for (int ii = 0; ii < result.length; ++ii) {
            Instant dt = data[ii];
            result[ii] = dt == null ? Long.MIN_VALUE : DateTimeUtils.epochNanos((Instant)dt);
        }
        return LongChunk.chunkWrap((long[])result);
    }

    private LongChunk<Values> mapData(ObjectChunk<?, Values> data) {
        long[] result = new long[data.size()];
        if (result.length > 0 && data.get(0) instanceof Long) {
            ObjectChunk boxedLongChunk = data.asObjectChunk();
            for (int ii = 0; ii < result.length; ++ii) {
                result[ii] = TypeUtils.unbox((Long)((Long)boxedLongChunk.get(ii)));
            }
        } else {
            ObjectChunk dtc = data.asObjectChunk();
            for (int ii = 0; ii < result.length; ++ii) {
                Instant dt = (Instant)dtc.get(ii);
                result[ii] = dt == null ? Long.MIN_VALUE : DateTimeUtils.epochNanos((Instant)dt);
            }
        }
        return LongChunk.chunkWrap((long[])result);
    }

    public void add(RowSet rowSet, Instant[] data) {
        this.longTestSource.add(rowSet, (Chunk<Values>)this.mapData(data));
    }

    @Override
    public void add(RowSet rowSet, Chunk<Values> data) {
        if (data.getChunkType() == ChunkType.Long) {
            this.longTestSource.add(rowSet, (Chunk<Values>)data.asLongChunk());
        } else if (data.getChunkType() == ChunkType.Object) {
            this.longTestSource.add(rowSet, (Chunk<Values>)this.mapData(data.asObjectChunk()));
        } else {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public void remove(RowSet rowSet) {
        this.longTestSource.remove(rowSet);
    }

    @Override
    public void shift(long startKeyInclusive, long endKeyInclusive, long shiftDelta) {
        this.longTestSource.shift(startKeyInclusive, endKeyInclusive, shiftDelta);
    }

    public Instant get(long rowKey) {
        Long v = this.longTestSource.get(rowKey);
        return v == null ? null : DateTimeUtils.epochNanosToInstant((long)v);
    }

    public boolean isImmutable() {
        return false;
    }

    public long getLong(long rowKey) {
        return this.longTestSource.getLong(rowKey);
    }

    public Instant getPrev(long rowKey) {
        Long v = this.longTestSource.getPrev(rowKey);
        return v == null ? null : DateTimeUtils.epochNanosToInstant((long)v);
    }

    public long getPrevLong(long rowKey) {
        return this.longTestSource.getPrevLong(rowKey);
    }

    public <ALTERNATE_DATA_TYPE> boolean allowsReinterpret(@NotNull Class<ALTERNATE_DATA_TYPE> alternateDataType) {
        return alternateDataType == Long.TYPE;
    }

    public <ALTERNATE_DATA_TYPE> ColumnSource<ALTERNATE_DATA_TYPE> doReinterpret(@NotNull Class<ALTERNATE_DATA_TYPE> alternateDataType) throws IllegalArgumentException {
        return this.alternateColumnSource;
    }
}

