/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.testutil.sources;

import io.deephaven.base.verify.Assert;
import io.deephaven.chunk.Chunk;
import io.deephaven.chunk.ChunkType;
import io.deephaven.chunk.IntChunk;
import io.deephaven.chunk.ObjectChunk;
import io.deephaven.chunk.attributes.Values;
import io.deephaven.engine.rowset.RowSet;
import io.deephaven.engine.rowset.RowSetBuilderRandom;
import io.deephaven.engine.rowset.RowSetFactory;
import io.deephaven.engine.rowset.WritableRowSet;
import io.deephaven.engine.table.impl.AbstractColumnSource;
import io.deephaven.engine.table.impl.MutableColumnSourceGetDefaults;
import io.deephaven.engine.testutil.sources.TestColumnSource;
import io.deephaven.engine.updategraph.UpdateCommitter;
import io.deephaven.util.type.TypeUtils;
import it.unimi.dsi.fastutil.longs.Long2IntMap;
import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import java.util.function.LongConsumer;
import org.apache.commons.lang3.mutable.MutableInt;

public class IntTestSource
extends AbstractColumnSource<Integer>
implements MutableColumnSourceGetDefaults.ForInt,
TestColumnSource<Integer> {
    private long lastAdditionTime;
    protected final Long2IntOpenHashMap data = new Long2IntOpenHashMap();
    protected Long2IntOpenHashMap prevData;
    private final UpdateCommitter<IntTestSource> prevFlusher = new UpdateCommitter((Object)this, this.updateGraph, IntTestSource::flushPrevious);

    public IntTestSource() {
        this((RowSet)RowSetFactory.empty(), (Chunk<Values>)IntChunk.getEmptyChunk());
    }

    public IntTestSource(RowSet rowSet, Chunk<Values> data) {
        super(Integer.TYPE);
        this.lastAdditionTime = this.updateGraph.clock().currentStep();
        this.add(rowSet, data);
        this.setDefaultReturnValue(this.data);
        this.prevData = this.data;
    }

    private void setDefaultReturnValue(Long2IntOpenHashMap data) {
        data.defaultReturnValue(Integer.MIN_VALUE);
    }

    public synchronized void checkIndex(RowSet rowSet) {
        Assert.eq((long)this.data.size(), (String)"data.size()", (long)rowSet.size(), (String)"rowSet.size()");
        RowSetBuilderRandom builder = RowSetFactory.builderRandom();
        this.data.keySet().forEach(arg_0 -> ((RowSetBuilderRandom)builder).addKey(arg_0));
        WritableRowSet dataRowSet = builder.build();
        Assert.equals((Object)dataRowSet, (String)"dataRowSet", (Object)rowSet, (String)"rowSet");
    }

    @Override
    public synchronized void add(RowSet rowSet, Chunk<Values> vs) {
        this.setGroupToRange(null);
        if (rowSet.size() != (long)vs.size()) {
            throw new IllegalArgumentException("Index=" + rowSet + ", data size=" + vs.size());
        }
        this.maybeInitializePrevForStep();
        if (vs.getChunkType() == ChunkType.Int) {
            final IntChunk vcs = vs.asIntChunk();
            rowSet.forAllRowKeys(new LongConsumer(){
                private final MutableInt ii = new MutableInt(0);

                @Override
                public void accept(long v) {
                    IntTestSource.this.data.put(v, vcs.get(this.ii.intValue()));
                    this.ii.increment();
                }
            });
        } else if (vs.getChunkType() == ChunkType.Object) {
            final ObjectChunk vcs = vs.asObjectChunk();
            rowSet.forAllRowKeys(new LongConsumer(){
                private final MutableInt ii = new MutableInt(0);

                @Override
                public void accept(long v) {
                    IntTestSource.this.data.put(v, TypeUtils.unbox((Integer)((Integer)vcs.get(this.ii.intValue()))));
                    this.ii.increment();
                }
            });
        } else {
            throw new IllegalArgumentException("Invalid chunk type for " + this.getClass() + ": " + vs.getChunkType());
        }
    }

    private void maybeInitializePrevForStep() {
        long currentStep = this.updateGraph.clock().currentStep();
        if (currentStep == this.lastAdditionTime) {
            return;
        }
        this.prevFlusher.maybeActivate();
        this.prevData = new Long2IntOpenHashMap((Long2IntMap)this.data);
        this.setDefaultReturnValue(this.prevData);
        this.lastAdditionTime = currentStep;
    }

    @Override
    public synchronized void remove(RowSet rowSet) {
        this.setGroupToRange(null);
        this.maybeInitializePrevForStep();
        rowSet.forAllRowKeys(arg_0 -> ((Long2IntOpenHashMap)this.data).remove(arg_0));
    }

    @Override
    public synchronized void shift(long startKeyInclusive, long endKeyInclusive, long shiftDelta) {
        long offset;
        this.maybeInitializePrevForStep();
        this.setGroupToRange(null);
        long dir = shiftDelta > 0L ? -1L : 1L;
        long len = endKeyInclusive - startKeyInclusive + 1L;
        long l = offset = dir < 0L ? len - 1L : 0L;
        while (dir < 0L ? offset >= 0L : offset < len) {
            if (this.data.containsKey(startKeyInclusive + offset)) {
                this.data.put(startKeyInclusive + offset + shiftDelta, this.data.remove(startKeyInclusive + offset));
            }
            offset += dir;
        }
    }

    public Integer get(long index) {
        return TypeUtils.box((int)this.getInt(index));
    }

    public synchronized int getInt(long index) {
        if (index == -1L) {
            return Integer.MIN_VALUE;
        }
        int retVal = this.data.get(index);
        if (retVal == Integer.MIN_VALUE && !this.data.containsKey(index)) {
            throw new IllegalStateException("Asking for a non-existent key: " + index);
        }
        return retVal;
    }

    public boolean isImmutable() {
        return false;
    }

    public Integer getPrev(long index) {
        return TypeUtils.box((int)this.getPrevInt(index));
    }

    public synchronized int getPrevInt(long index) {
        if (index == -1L) {
            return Integer.MIN_VALUE;
        }
        if (this.prevData == null) {
            return this.getInt(index);
        }
        int retVal = this.prevData.get(index);
        if (retVal == Integer.MIN_VALUE && !this.prevData.containsKey(index)) {
            throw new IllegalStateException("Asking for a non-existent previous key: " + index);
        }
        return retVal;
    }

    public static void flushPrevious(IntTestSource source) {
        source.prevData = null;
    }

    public void startTrackingPrevValues() {
    }
}

