/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.testutil.sources;

import io.deephaven.base.verify.Assert;
import io.deephaven.chunk.Chunk;
import io.deephaven.chunk.ChunkType;
import io.deephaven.chunk.LongChunk;
import io.deephaven.chunk.ObjectChunk;
import io.deephaven.chunk.attributes.Values;
import io.deephaven.engine.rowset.RowSet;
import io.deephaven.engine.rowset.RowSetBuilderRandom;
import io.deephaven.engine.rowset.RowSetFactory;
import io.deephaven.engine.rowset.WritableRowSet;
import io.deephaven.engine.table.impl.AbstractColumnSource;
import io.deephaven.engine.table.impl.MutableColumnSourceGetDefaults;
import io.deephaven.engine.testutil.sources.TestColumnSource;
import io.deephaven.engine.updategraph.UpdateCommitter;
import io.deephaven.util.type.TypeUtils;
import it.unimi.dsi.fastutil.longs.Long2LongMap;
import it.unimi.dsi.fastutil.longs.Long2LongOpenHashMap;
import java.util.function.LongConsumer;
import org.apache.commons.lang3.mutable.MutableInt;

public class LongTestSource
extends AbstractColumnSource<Long>
implements MutableColumnSourceGetDefaults.ForLong,
TestColumnSource<Long> {
    private long lastAdditionTime;
    protected final Long2LongOpenHashMap data = new Long2LongOpenHashMap();
    protected Long2LongOpenHashMap prevData;
    private final UpdateCommitter<LongTestSource> prevFlusher = new UpdateCommitter((Object)this, this.updateGraph, LongTestSource::flushPrevious);

    public LongTestSource() {
        this((RowSet)RowSetFactory.empty(), (Chunk<Values>)LongChunk.getEmptyChunk());
    }

    public LongTestSource(RowSet rowSet, Chunk<Values> data) {
        super(Long.TYPE);
        this.lastAdditionTime = this.updateGraph.clock().currentStep();
        this.add(rowSet, data);
        this.setDefaultReturnValue(this.data);
        this.prevData = this.data;
    }

    private void setDefaultReturnValue(Long2LongOpenHashMap data) {
        data.defaultReturnValue(Long.MIN_VALUE);
    }

    public synchronized void checkIndex(RowSet rowSet) {
        Assert.eq((long)this.data.size(), (String)"data.size()", (long)rowSet.size(), (String)"rowSet.size()");
        RowSetBuilderRandom builder = RowSetFactory.builderRandom();
        this.data.keySet().forEach(arg_0 -> ((RowSetBuilderRandom)builder).addKey(arg_0));
        WritableRowSet dataRowSet = builder.build();
        Assert.equals((Object)dataRowSet, (String)"dataRowSet", (Object)rowSet, (String)"rowSet");
    }

    @Override
    public synchronized void add(RowSet rowSet, Chunk<Values> vs) {
        this.setGroupToRange(null);
        if (rowSet.size() != (long)vs.size()) {
            throw new IllegalArgumentException("Index=" + rowSet + ", data size=" + vs.size());
        }
        this.maybeInitializePrevForStep();
        if (vs.getChunkType() == ChunkType.Long) {
            final LongChunk vcs = vs.asLongChunk();
            rowSet.forAllRowKeys(new LongConsumer(){
                private final MutableInt ii = new MutableInt(0);

                @Override
                public void accept(long v) {
                    LongTestSource.this.data.put(v, vcs.get(this.ii.intValue()));
                    this.ii.increment();
                }
            });
        } else if (vs.getChunkType() == ChunkType.Object) {
            final ObjectChunk vcs = vs.asObjectChunk();
            rowSet.forAllRowKeys(new LongConsumer(){
                private final MutableInt ii = new MutableInt(0);

                @Override
                public void accept(long v) {
                    LongTestSource.this.data.put(v, TypeUtils.unbox((Long)((Long)vcs.get(this.ii.intValue()))));
                    this.ii.increment();
                }
            });
        } else {
            throw new IllegalArgumentException("Invalid chunk type for " + this.getClass() + ": " + vs.getChunkType());
        }
    }

    private void maybeInitializePrevForStep() {
        long currentStep = this.updateGraph.clock().currentStep();
        if (currentStep == this.lastAdditionTime) {
            return;
        }
        this.prevFlusher.maybeActivate();
        this.prevData = new Long2LongOpenHashMap((Long2LongMap)this.data);
        this.setDefaultReturnValue(this.prevData);
        this.lastAdditionTime = currentStep;
    }

    @Override
    public synchronized void remove(RowSet rowSet) {
        this.setGroupToRange(null);
        this.maybeInitializePrevForStep();
        rowSet.forAllRowKeys(arg_0 -> ((Long2LongOpenHashMap)this.data).remove(arg_0));
    }

    @Override
    public synchronized void shift(long startKeyInclusive, long endKeyInclusive, long shiftDelta) {
        long offset;
        this.maybeInitializePrevForStep();
        this.setGroupToRange(null);
        long dir = shiftDelta > 0L ? -1L : 1L;
        long len = endKeyInclusive - startKeyInclusive + 1L;
        long l = offset = dir < 0L ? len - 1L : 0L;
        while (dir < 0L ? offset >= 0L : offset < len) {
            if (this.data.containsKey(startKeyInclusive + offset)) {
                this.data.put(startKeyInclusive + offset + shiftDelta, this.data.remove(startKeyInclusive + offset));
            }
            offset += dir;
        }
    }

    public Long get(long index) {
        return TypeUtils.box((long)this.getLong(index));
    }

    public synchronized long getLong(long index) {
        if (index == -1L) {
            return Long.MIN_VALUE;
        }
        long retVal = this.data.get(index);
        if (retVal == Long.MIN_VALUE && !this.data.containsKey(index)) {
            throw new IllegalStateException("Asking for a non-existent key: " + index);
        }
        return retVal;
    }

    public boolean isImmutable() {
        return false;
    }

    public Long getPrev(long index) {
        return TypeUtils.box((long)this.getPrevLong(index));
    }

    public synchronized long getPrevLong(long index) {
        if (index == -1L) {
            return Long.MIN_VALUE;
        }
        if (this.prevData == null) {
            return this.getLong(index);
        }
        long retVal = this.prevData.get(index);
        if (retVal == Long.MIN_VALUE && !this.prevData.containsKey(index)) {
            throw new IllegalStateException("Asking for a non-existent previous key: " + index);
        }
        return retVal;
    }

    public static void flushPrevious(LongTestSource source) {
        source.prevData = null;
    }

    public void startTrackingPrevValues() {
    }
}

