/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.testutil.sources;

import io.deephaven.base.verify.Assert;
import io.deephaven.chunk.Chunk;
import io.deephaven.chunk.ObjectChunk;
import io.deephaven.chunk.attributes.Values;
import io.deephaven.engine.rowset.RowSet;
import io.deephaven.engine.rowset.RowSetBuilderRandom;
import io.deephaven.engine.rowset.RowSetFactory;
import io.deephaven.engine.rowset.WritableRowSet;
import io.deephaven.engine.table.impl.AbstractColumnSource;
import io.deephaven.engine.table.impl.MutableColumnSourceGetDefaults;
import io.deephaven.engine.testutil.sources.TestColumnSource;
import io.deephaven.engine.updategraph.UpdateCommitter;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.function.LongConsumer;
import org.apache.commons.lang3.mutable.MutableInt;

public class ObjectTestSource<T>
extends AbstractColumnSource<T>
implements MutableColumnSourceGetDefaults.ForObject<T>,
TestColumnSource<T> {
    private long lastAdditionTime;
    protected final Long2ObjectOpenHashMap<T> data = new Long2ObjectOpenHashMap();
    protected Long2ObjectOpenHashMap<T> prevData;
    private final UpdateCommitter<ObjectTestSource> prevFlusher = new UpdateCommitter((Object)this, this.updateGraph, ObjectTestSource::flushPrevious);

    public ObjectTestSource(Class<T> type) {
        this(type, (RowSet)RowSetFactory.empty(), (Chunk<Values>)ObjectChunk.getEmptyChunk());
    }

    public ObjectTestSource(Class<T> type, RowSet rowSet, Chunk<Values> data) {
        super(type);
        this.add(rowSet, data);
        this.setDefaultReturnValue(this.data);
        this.prevData = this.data;
    }

    private void setDefaultReturnValue(Long2ObjectOpenHashMap<T> data) {
        data.defaultReturnValue(null);
    }

    public synchronized void checkIndex(RowSet rowSet) {
        Assert.eq((long)this.data.size(), (String)"data.size()", (long)rowSet.size(), (String)"rowSet.size()");
        RowSetBuilderRandom builder = RowSetFactory.builderRandom();
        this.data.keySet().forEach(arg_0 -> ((RowSetBuilderRandom)builder).addKey(arg_0));
        WritableRowSet dataRowSet = builder.build();
        Assert.equals((Object)dataRowSet, (String)"dataRowSet", (Object)rowSet, (String)"rowSet");
    }

    @Override
    public synchronized void add(RowSet rowSet, Chunk<Values> vs) {
        this.setGroupToRange(null);
        if (rowSet.size() != (long)vs.size()) {
            throw new IllegalArgumentException("rowSet=" + rowSet + ", data size=" + vs.size());
        }
        this.maybeInitializePrevForStep();
        final ObjectChunk vcs = vs.asObjectChunk();
        rowSet.forAllRowKeys(new LongConsumer(){
            private final MutableInt ii = new MutableInt(0);

            @Override
            public void accept(long v) {
                ObjectTestSource.this.data.put(v, vcs.get(this.ii.intValue()));
                this.ii.increment();
            }
        });
    }

    private void maybeInitializePrevForStep() {
        long currentStep = this.updateGraph.clock().currentStep();
        if (currentStep == this.lastAdditionTime) {
            return;
        }
        this.prevFlusher.maybeActivate();
        this.prevData = new Long2ObjectOpenHashMap(this.data);
        this.setDefaultReturnValue(this.prevData);
        this.lastAdditionTime = currentStep;
    }

    @Override
    public synchronized void remove(RowSet rowSet) {
        this.setGroupToRange(null);
        this.maybeInitializePrevForStep();
        rowSet.forAllRowKeys(arg_0 -> this.data.remove(arg_0));
    }

    @Override
    public synchronized void shift(long startKeyInclusive, long endKeyInclusive, long shiftDelta) {
        long offset;
        this.maybeInitializePrevForStep();
        this.setGroupToRange(null);
        long dir = shiftDelta > 0L ? -1L : 1L;
        long len = endKeyInclusive - startKeyInclusive + 1L;
        long l = offset = dir < 0L ? len - 1L : 0L;
        while (dir < 0L ? offset >= 0L : offset < len) {
            if (this.data.containsKey(startKeyInclusive + offset)) {
                this.data.put(startKeyInclusive + offset + shiftDelta, this.data.remove(startKeyInclusive + offset));
            }
            offset += dir;
        }
    }

    public synchronized T get(long index) {
        if (index == -1L) {
            return null;
        }
        Object retVal = this.data.get(index);
        if (retVal == null && !this.data.containsKey(index)) {
            throw new IllegalStateException("Asking for a non-existent key: " + index);
        }
        return (T)retVal;
    }

    public boolean isImmutable() {
        return false;
    }

    public synchronized T getPrev(long index) {
        if (index == -1L) {
            return null;
        }
        if (this.prevData == null) {
            return this.get(index);
        }
        Object retVal = this.prevData.get(index);
        if (retVal == null && !this.prevData.containsKey(index)) {
            throw new IllegalStateException("Asking for a non-existent previous key: " + index);
        }
        return (T)retVal;
    }

    public static void flushPrevious(ObjectTestSource source) {
        source.prevData = null;
    }

    public void startTrackingPrevValues() {
    }
}

