/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.testutil.testcase;

import io.deephaven.util.process.FatalErrorReporter;
import io.deephaven.util.process.ProcessEnvironment;
import io.deephaven.util.process.ShutdownManager;
import org.jetbrains.annotations.NotNull;

public class FakeProcessEnvironment
implements ProcessEnvironment {
    public static final ProcessEnvironment INSTANCE = new FakeProcessEnvironment();

    private FakeProcessEnvironment() {
    }

    public ShutdownManager getShutdownManager() {
        return FakeShutdownManager.INSTANCE;
    }

    public FatalErrorReporter getFatalErrorReporter() {
        return FakeFatalErrorReporter.INSTANCE;
    }

    public String getMainClassName() {
        return "UnitTest";
    }

    public void onStartup() {
        throw new UnsupportedOperationException();
    }

    public void onShutdown() {
        throw new UnsupportedOperationException();
    }

    private static final class FakeFatalErrorReporter
    implements FatalErrorReporter {
        private static final FatalErrorReporter INSTANCE = new FakeFatalErrorReporter();

        private FakeFatalErrorReporter() {
        }

        public void report(@NotNull String message, @NotNull Throwable throwable) {
            throw new FakeFatalException(message, throwable);
        }

        public void report(@NotNull String message) {
            throw new FakeFatalException(message);
        }

        public void reportAsync(@NotNull String message, @NotNull Throwable throwable) {
            this.report(message, throwable);
        }

        public void reportAsync(@NotNull String message) {
            this.report(message);
        }

        public void addInterceptor(@NotNull FatalErrorReporter.Interceptor interceptor) {
        }

        public void uncaughtException(@NotNull Thread t, @NotNull Throwable e) {
            this.report("Uncaught exception in thread " + t.getName(), e);
        }
    }

    public static final class FakeFatalException
    extends RuntimeException {
        public FakeFatalException(@NotNull String message, @NotNull Throwable throwable) {
            super(message, throwable);
        }

        public FakeFatalException(@NotNull String message) {
            super(message);
        }
    }

    private static final class FakeShutdownManager
    implements ShutdownManager {
        private static final ShutdownManager INSTANCE = new FakeShutdownManager();

        private FakeShutdownManager() {
        }

        public void addShutdownHookToRuntime() {
            throw new UnsupportedOperationException();
        }

        public void registerTask(@NotNull ShutdownManager.OrderingCategory orderingCategory, @NotNull ShutdownManager.Task task) {
            throw new UnsupportedOperationException();
        }

        public void deregisterTask(@NotNull ShutdownManager.OrderingCategory orderingCategory, @NotNull ShutdownManager.Task task) {
            throw new UnsupportedOperationException();
        }

        public void reset() {
        }

        public boolean tasksInvoked() {
            throw new UnsupportedOperationException();
        }

        public boolean maybeInvokeTasks() {
            throw new UnsupportedOperationException();
        }
    }
}

