/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.testutil.testcase;

import io.deephaven.base.testing.BaseArrayTestCase;
import io.deephaven.chunk.util.pools.ChunkPoolReleaseTracking;
import io.deephaven.configuration.Configuration;
import io.deephaven.engine.context.ExecutionContext;
import io.deephaven.engine.context.QueryCompiler;
import io.deephaven.engine.context.TestExecutionContext;
import io.deephaven.engine.liveness.LivenessScope;
import io.deephaven.engine.liveness.LivenessScopeStack;
import io.deephaven.engine.table.impl.QueryTable;
import io.deephaven.engine.table.impl.UpdateErrorReporter;
import io.deephaven.engine.table.impl.util.AsyncClientErrorNotifier;
import io.deephaven.engine.table.impl.util.AsyncErrorLogger;
import io.deephaven.engine.testutil.ColumnInfo;
import io.deephaven.engine.testutil.ControlledUpdateGraph;
import io.deephaven.engine.testutil.EvalNuggetInterface;
import io.deephaven.engine.testutil.GenerateTableUpdates;
import io.deephaven.engine.testutil.TstUtils;
import io.deephaven.engine.testutil.testcase.FakeProcessEnvironment;
import io.deephaven.engine.util.systemicmarking.SystemicObjectTracker;
import io.deephaven.util.ExceptionDetails;
import io.deephaven.util.SafeCloseable;
import io.deephaven.util.process.ProcessEnvironment;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import java.util.function.Supplier;
import junit.framework.TestCase;

public abstract class RefreshingTableTestCase
extends BaseArrayTestCase
implements UpdateErrorReporter {
    public static boolean printTableUpdates = Configuration.getInstance().getBooleanForClassWithDefault(RefreshingTableTestCase.class, "printTableUpdates", false);
    private static final boolean ENABLE_QUERY_COMPILER_LOGGING = Configuration.getInstance().getBooleanForClassWithDefault(RefreshingTableTestCase.class, "QueryCompile.logEnabled", false);
    private ProcessEnvironment oldProcessEnvironment;
    private boolean oldMemoize;
    private UpdateErrorReporter oldReporter;
    private boolean expectError = false;
    private SafeCloseable livenessScopeCloseable;
    private boolean oldLogEnabled;
    private boolean oldSerialSafe;
    private SafeCloseable executionContext;
    List<Throwable> errors;

    public static int scaleToDesiredTestLength(int maxIter) {
        return TstUtils.scaleToDesiredTestLength(maxIter);
    }

    public void setUp() throws Exception {
        super.setUp();
        this.oldProcessEnvironment = ProcessEnvironment.tryGet();
        ProcessEnvironment.set((ProcessEnvironment)FakeProcessEnvironment.INSTANCE, (boolean)true);
        this.executionContext = TestExecutionContext.createForUnitTests().open();
        ControlledUpdateGraph updateGraph = (ControlledUpdateGraph)ExecutionContext.getContext().getUpdateGraph().cast();
        updateGraph.enableUnitTestMode();
        updateGraph.resetForUnitTests(false);
        SystemicObjectTracker.markThreadSystemic();
        this.oldMemoize = QueryTable.setMemoizeResults((boolean)false);
        this.oldReporter = AsyncClientErrorNotifier.setReporter((UpdateErrorReporter)this);
        this.errors = null;
        this.livenessScopeCloseable = LivenessScopeStack.open((LivenessScope)new LivenessScope(true), (boolean)true);
        this.oldLogEnabled = QueryCompiler.setLogEnabled((boolean)ENABLE_QUERY_COMPILER_LOGGING);
        this.oldSerialSafe = updateGraph.setSerialTableOperationsSafe(true);
        AsyncErrorLogger.init();
        ChunkPoolReleaseTracking.enableStrict();
    }

    public void tearDown() throws Exception {
        ChunkPoolReleaseTracking.checkAndDisable();
        ControlledUpdateGraph updateGraph = (ControlledUpdateGraph)ExecutionContext.getContext().getUpdateGraph().cast();
        updateGraph.setSerialTableOperationsSafe(this.oldSerialSafe);
        QueryCompiler.setLogEnabled((boolean)this.oldLogEnabled);
        this.executionContext.close();
        this.livenessScopeCloseable.close();
        AsyncClientErrorNotifier.setReporter((UpdateErrorReporter)this.oldReporter);
        QueryTable.setMemoizeResults((boolean)this.oldMemoize);
        updateGraph.resetForUnitTests(true);
        if (this.oldProcessEnvironment == null) {
            ProcessEnvironment.clear();
        } else {
            ProcessEnvironment.set((ProcessEnvironment)this.oldProcessEnvironment, (boolean)true);
        }
        super.tearDown();
    }

    public void reportUpdateError(Throwable t) throws IOException {
        if (!this.expectError) {
            System.err.println("Received error notification: " + new ExceptionDetails(t).getFullStackTrace());
            TestCase.fail((String)t.getMessage());
        }
        if (this.errors == null) {
            this.errors = new ArrayList<Throwable>();
        }
        this.errors.add(t);
    }

    public List<Throwable> getUpdateErrors() {
        if (this.errors == null) {
            return Collections.emptyList();
        }
        return this.errors;
    }

    public boolean getExpectError() {
        return this.expectError;
    }

    public void setExpectError(boolean expectError) {
        this.expectError = expectError;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T allowingError(Supplier<T> function, Predicate<List<Throwable>> errorsAcceptable) {
        T retval;
        boolean original = this.getExpectError();
        try {
            this.setExpectError(true);
            retval = function.get();
        }
        finally {
            this.setExpectError(original);
        }
        if (this.errors != null && !errorsAcceptable.test(this.errors)) {
            TestCase.fail((String)("Unacceptable errors: " + this.errors));
        }
        return retval;
    }

    public void allowingError(Runnable function, Predicate<List<Throwable>> errorsAcceptable) {
        this.allowingError(() -> {
            function.run();
            return true;
        }, errorsAcceptable);
    }

    public static void simulateShiftAwareStep(int targetUpdateSize, Random random, QueryTable table, ColumnInfo[] columnInfo, EvalNuggetInterface[] en) {
        RefreshingTableTestCase.simulateShiftAwareStep("", targetUpdateSize, random, table, columnInfo, en);
    }

    public static void simulateShiftAwareStep(String ctxt, int targetUpdateSize, Random random, QueryTable table, ColumnInfo[] columnInfo, EvalNuggetInterface[] en) {
        RefreshingTableTestCase.simulateShiftAwareStep(GenerateTableUpdates.DEFAULT_PROFILE, ctxt, targetUpdateSize, random, table, columnInfo, en);
    }

    public static void simulateShiftAwareStep(GenerateTableUpdates.SimulationProfile simulationProfile, String ctxt, int targetUpdateSize, Random random, QueryTable table, ColumnInfo[] columnInfo, EvalNuggetInterface[] en) {
        ControlledUpdateGraph updateGraph = (ControlledUpdateGraph)ExecutionContext.getContext().getUpdateGraph().cast();
        updateGraph.runWithinUnitTestCycle(() -> GenerateTableUpdates.generateShiftAwareTableUpdates(simulationProfile, targetUpdateSize, random, table, columnInfo));
        TstUtils.validate(ctxt, en);
    }

    public class ErrorExpectation
    implements SafeCloseable {
        final boolean originalExpectError;

        public ErrorExpectation() {
            this.originalExpectError = RefreshingTableTestCase.this.expectError;
            RefreshingTableTestCase.this.expectError = true;
        }

        public void close() {
            RefreshingTableTestCase.this.expectError = this.originalExpectError;
        }
    }
}

