/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.csv;

import io.deephaven.base.Procedure;
import io.deephaven.chunk.ByteChunk;
import io.deephaven.chunk.CharChunk;
import io.deephaven.chunk.Chunk;
import io.deephaven.chunk.DoubleChunk;
import io.deephaven.chunk.FloatChunk;
import io.deephaven.chunk.IntChunk;
import io.deephaven.chunk.LongChunk;
import io.deephaven.chunk.ObjectChunk;
import io.deephaven.chunk.ShortChunk;
import io.deephaven.chunk.WritableByteChunk;
import io.deephaven.chunk.WritableChunk;
import io.deephaven.chunk.WritableIntChunk;
import io.deephaven.chunk.WritableLongChunk;
import io.deephaven.chunk.WritableShortChunk;
import io.deephaven.chunk.attributes.Values;
import io.deephaven.csv.ColumnNameLegalizer;
import io.deephaven.csv.CsvSpecs;
import io.deephaven.csv.DeephavenTimeZoneParser;
import io.deephaven.csv.reading.CsvReader;
import io.deephaven.csv.sinks.Sink;
import io.deephaven.csv.sinks.SinkFactory;
import io.deephaven.csv.sinks.Source;
import io.deephaven.csv.tokenization.Tokenizer;
import io.deephaven.csv.util.CsvReaderException;
import io.deephaven.datastructures.util.CollectionUtil;
import io.deephaven.engine.rowset.RowSequence;
import io.deephaven.engine.rowset.RowSequenceFactory;
import io.deephaven.engine.rowset.RowSetFactory;
import io.deephaven.engine.rowset.TrackingRowSet;
import io.deephaven.engine.rowset.TrackingWritableRowSet;
import io.deephaven.engine.table.ChunkSink;
import io.deephaven.engine.table.ChunkSource;
import io.deephaven.engine.table.ColumnSource;
import io.deephaven.engine.table.DataColumn;
import io.deephaven.engine.table.MatchPair;
import io.deephaven.engine.table.Table;
import io.deephaven.engine.table.TableDefinition;
import io.deephaven.engine.table.WritableColumnSource;
import io.deephaven.engine.table.impl.InMemoryTable;
import io.deephaven.engine.table.impl.perf.QueryPerformanceNugget;
import io.deephaven.engine.table.impl.perf.QueryPerformanceRecorder;
import io.deephaven.engine.table.impl.sources.ArrayBackedColumnSource;
import io.deephaven.engine.table.impl.sources.BooleanArraySource;
import io.deephaven.engine.table.impl.sources.ByteArraySource;
import io.deephaven.engine.table.impl.sources.CharacterArraySource;
import io.deephaven.engine.table.impl.sources.DateTimeArraySource;
import io.deephaven.engine.table.impl.sources.DoubleArraySource;
import io.deephaven.engine.table.impl.sources.FloatArraySource;
import io.deephaven.engine.table.impl.sources.IntegerArraySource;
import io.deephaven.engine.table.impl.sources.LongArraySource;
import io.deephaven.engine.table.impl.sources.ObjectArraySource;
import io.deephaven.engine.table.impl.sources.ShortArraySource;
import io.deephaven.engine.util.PathUtil;
import io.deephaven.engine.util.TableTools;
import io.deephaven.io.streams.BzipFileOutputStream;
import io.deephaven.time.DateTime;
import io.deephaven.time.TimeZone;
import io.deephaven.util.QueryConstants;
import io.deephaven.util.annotations.ScriptApi;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jetbrains.annotations.Nullable;

public class CsvTools {
    public static final int MAX_CSV_LINE_COUNT = 1000000;
    public static final boolean NULLS_AS_EMPTY_DEFAULT = true;

    public static CsvSpecs.Builder builder() {
        return CsvSpecs.builder().headerLegalizer((Function)ColumnNameLegalizer.INSTANCE).headerValidator((Predicate)ColumnNameLegalizer.INSTANCE).customTimeZoneParser((Tokenizer.CustomTimeZoneParser)new DeephavenTimeZoneParser());
    }

    @ScriptApi
    public static Table readCsv(String path) throws CsvReaderException {
        return CsvTools.readCsv(path, CsvTools.builder().build());
    }

    @ScriptApi
    public static Table readCsv(InputStream stream) throws CsvReaderException {
        return CsvTools.readCsv(stream, CsvTools.builder().build());
    }

    @ScriptApi
    public static Table readCsv(URL url) throws CsvReaderException {
        return CsvTools.readCsv(url, CsvTools.builder().build());
    }

    @ScriptApi
    public static Table readCsv(Path path) throws CsvReaderException {
        return CsvTools.readCsv(path, CsvTools.builder().build());
    }

    @ScriptApi
    public static Table readCsv(String path, CsvSpecs specs) throws CsvReaderException {
        block3: {
            URL url;
            try {
                url = new URL(path);
            }
            catch (MalformedURLException e) {
                break block3;
            }
            if (CsvTools.isStandardFile(url)) {
                return CsvTools.readCsv(Paths.get(url.getPath(), new String[0]), specs);
            }
            return CsvTools.readCsv(url, specs);
        }
        return CsvTools.readCsv(Paths.get(path, new String[0]), specs);
    }

    @ScriptApi
    public static Table readCsv(InputStream stream, CsvSpecs specs) throws CsvReaderException {
        CsvReader.Result result = CsvReader.read((CsvSpecs)specs, (InputStream)stream, (SinkFactory)CsvTools.makeMySinkFactory());
        LinkedHashMap<String, ColumnSource> columns = new LinkedHashMap<String, ColumnSource>(result.numCols());
        for (CsvReader.ResultColumn column : result) {
            columns.put(column.name(), (ColumnSource)column.data());
        }
        TableDefinition tableDef = TableDefinition.inferFrom(columns);
        TrackingWritableRowSet rowSet = RowSetFactory.flat((long)result.numRows()).toTracking();
        return InMemoryTable.from((TableDefinition)tableDef, (TrackingRowSet)rowSet, columns);
    }

    @ScriptApi
    public static Table readCsv(URL url, CsvSpecs specs) throws CsvReaderException {
        try {
            return CsvTools.readCsv(url.openStream(), specs);
        }
        catch (IOException inner) {
            throw new CsvReaderException("Caught exception", (Throwable)inner);
        }
    }

    @ScriptApi
    public static Table readCsv(Path path, CsvSpecs specs) throws CsvReaderException {
        try {
            return CsvTools.readCsv(PathUtil.open((Path)path), specs);
        }
        catch (IOException inner) {
            throw new CsvReaderException("Caught exception", (Throwable)inner);
        }
    }

    public static MatchPair[] renamesForHeaderless(Collection<String> columnNames) {
        MatchPair[] renames = new MatchPair[columnNames.size()];
        int ci = 0;
        for (String columnName : columnNames) {
            renames[ci] = new MatchPair(columnName, String.format("Column%d", ci + 1));
            ++ci;
        }
        return renames;
    }

    public static MatchPair[] renamesForHeaderless(String ... columnNames) {
        return CsvTools.renamesForHeaderless(Arrays.asList(columnNames));
    }

    @ScriptApi
    public static Table readHeaderlessCsv(String filePath, Collection<String> columnNames) throws CsvReaderException {
        return CsvTools.readCsv(filePath, CsvTools.builder().hasHeaderRow(false).build()).renameColumns(CsvTools.renamesForHeaderless(columnNames));
    }

    @ScriptApi
    public static Table readHeaderlessCsv(String filePath, String ... columnNames) throws CsvReaderException {
        return CsvTools.readCsv(filePath, CsvTools.builder().hasHeaderRow(false).build()).renameColumns(CsvTools.renamesForHeaderless(columnNames));
    }

    @Deprecated
    @ScriptApi
    public static Table readCsv(InputStream is, String format) throws CsvReaderException {
        CsvSpecs specs = CsvTools.fromLegacyFormat(format);
        if (specs == null) {
            throw new IllegalArgumentException(String.format("Unable to map legacy format '%s' into CsvSpecs", format));
        }
        return CsvTools.readCsv(is, specs);
    }

    @Deprecated
    @ScriptApi
    public static Table readCsv(InputStream is, char separator) throws CsvReaderException {
        return CsvTools.readCsv(is, CsvTools.builder().delimiter(separator).build());
    }

    private static boolean isStandardFile(URL url) {
        return "file".equals(url.getProtocol()) && url.getAuthority() == null && url.getQuery() == null && url.getRef() == null;
    }

    @ScriptApi
    public static void writeCsv(Table source, boolean compressed, String destPath, String ... columns) throws IOException {
        CsvTools.writeCsv(source, compressed, destPath, true, columns);
    }

    @ScriptApi
    public static void writeCsv(Table source, boolean compressed, String destPath, boolean nullsAsEmpty, String ... columns) throws IOException {
        CsvTools.writeCsv(source, destPath, compressed, TimeZone.TZ_DEFAULT, nullsAsEmpty, columns);
    }

    @ScriptApi
    public static void writeCsv(Table source, String destPath, String ... columns) throws IOException {
        CsvTools.writeCsv(source, destPath, true, columns);
    }

    @ScriptApi
    public static void writeCsv(Table source, String destPath, boolean nullsAsEmpty, String ... columns) throws IOException {
        CsvTools.writeCsv(source, destPath, false, TimeZone.TZ_DEFAULT, nullsAsEmpty, columns);
    }

    @ScriptApi
    public static void writeCsv(Table source, PrintStream out, String ... columns) throws IOException {
        CsvTools.writeCsv(source, out, true, columns);
    }

    @ScriptApi
    public static void writeCsv(Table source, PrintStream out, boolean nullsAsEmpty, String ... columns) throws IOException {
        PrintWriter printWriter = new PrintWriter(out);
        BufferedWriter bufferedWriter = new BufferedWriter(printWriter);
        CsvTools.writeCsv(source, (Writer)bufferedWriter, TimeZone.TZ_DEFAULT, null, nullsAsEmpty, ',', columns);
    }

    @ScriptApi
    public static void writeCsv(Table source, String destPath, boolean compressed, TimeZone timeZone, String ... columns) throws IOException {
        CsvTools.writeCsv(source, destPath, compressed, timeZone, null, true, ',', columns);
    }

    @ScriptApi
    public static void writeCsv(Table source, String destPath, boolean compressed, TimeZone timeZone, boolean nullsAsEmpty, String ... columns) throws IOException {
        CsvTools.writeCsv(source, destPath, compressed, timeZone, null, nullsAsEmpty, ',', columns);
    }

    @ScriptApi
    public static void writeCsv(Table source, String destPath, boolean compressed, TimeZone timeZone, boolean nullsAsEmpty, char separator, String ... columns) throws IOException {
        CsvTools.writeCsv(source, destPath, compressed, timeZone, null, nullsAsEmpty, separator, columns);
    }

    @ScriptApi
    public static void writeCsv(Table[] sources, String destPath, boolean compressed, TimeZone timeZone, String tableSeparator, String ... columns) throws IOException {
        CsvTools.writeCsv(sources, destPath, compressed, timeZone, tableSeparator, true, columns);
    }

    @ScriptApi
    public static void writeCsv(Table[] sources, String destPath, boolean compressed, TimeZone timeZone, String tableSeparator, boolean nullsAsEmpty, String ... columns) throws IOException {
        CsvTools.writeCsv(sources, destPath, compressed, timeZone, tableSeparator, ',', nullsAsEmpty, columns);
    }

    @ScriptApi
    public static void writeCsv(Table[] sources, String destPath, boolean compressed, TimeZone timeZone, String tableSeparator, char fieldSeparator, boolean nullsAsEmpty, String ... columns) throws IOException {
        BufferedWriter out;
        BufferedWriter bufferedWriter = out = compressed ? new BufferedWriter(new OutputStreamWriter((OutputStream)new BzipFileOutputStream(destPath + ".bz2"))) : new BufferedWriter(new FileWriter(destPath));
        if (columns.length == 0) {
            List columnNames = sources[0].getDefinition().getColumnNames();
            columns = columnNames.toArray(CollectionUtil.ZERO_LENGTH_STRING_ARRAY);
        }
        CsvTools.writeCsvHeader((Writer)out, fieldSeparator, columns);
        for (Table source : sources) {
            CsvTools.writeCsvContents(source, (Writer)out, timeZone, null, nullsAsEmpty, fieldSeparator, columns);
            out.write(tableSeparator);
        }
        out.close();
    }

    @ScriptApi
    public static void writeCsv(Table source, String destPath, boolean compressed, TimeZone timeZone, @Nullable Procedure.Binary<Long, Long> progress, String ... columns) throws IOException {
        CsvTools.writeCsv(source, destPath, compressed, timeZone, progress, true, columns);
    }

    @ScriptApi
    public static void writeCsv(Table source, String destPath, boolean compressed, TimeZone timeZone, @Nullable Procedure.Binary<Long, Long> progress, boolean nullsAsEmpty, String ... columns) throws IOException {
        CsvTools.writeCsv(source, destPath, compressed, timeZone, progress, nullsAsEmpty, ',', columns);
    }

    @ScriptApi
    public static void writeCsv(Table source, String destPath, boolean compressed, TimeZone timeZone, @Nullable Procedure.Binary<Long, Long> progress, boolean nullsAsEmpty, char separator, String ... columns) throws IOException {
        BufferedWriter out = compressed ? new BufferedWriter(new OutputStreamWriter((OutputStream)new BzipFileOutputStream(destPath + ".bz2"))) : new BufferedWriter(new FileWriter(destPath));
        CsvTools.writeCsv(source, (Writer)out, timeZone, progress, nullsAsEmpty, separator, columns);
    }

    @ScriptApi
    public static void writeCsv(Table source, Writer out, TimeZone timeZone, @Nullable Procedure.Binary<Long, Long> progress, boolean nullsAsEmpty, String ... columns) throws IOException {
        CsvTools.writeCsv(source, out, timeZone, progress, nullsAsEmpty, ',', columns);
    }

    @ScriptApi
    public static void writeCsv(Table source, Writer out, TimeZone timeZone, @Nullable Procedure.Binary<Long, Long> progress, boolean nullsAsEmpty, char separator, String ... columns) throws IOException {
        if (columns == null || columns.length == 0) {
            List columnNames = source.getDefinition().getColumnNames();
            columns = columnNames.toArray(CollectionUtil.ZERO_LENGTH_STRING_ARRAY);
        }
        CsvTools.writeCsvHeader(out, separator, columns);
        CsvTools.writeCsvContents(source, out, timeZone, progress, nullsAsEmpty, separator, columns);
        out.close();
    }

    @ScriptApi
    public static void writeCsvHeader(Writer out, String ... columns) throws IOException {
        CsvTools.writeCsvHeader(out, ',', columns);
    }

    @ScriptApi
    public static void writeCsvHeader(Writer out, char separator, String ... columns) throws IOException {
        for (int i = 0; i < columns.length; ++i) {
            String column = columns[i];
            if (i > 0) {
                out.write(separator);
            }
            out.write(column);
        }
    }

    @ScriptApi
    public static void writeCsvPaginate(Table source, String destPath, String filename) throws IOException {
        CsvTools.writeCsvPaginate(source, destPath, filename, true);
    }

    @ScriptApi
    public static void writeCsvPaginate(Table source, String destPath, String filename, boolean nullsAsEmpty) throws IOException {
        long fileCount = source.size() / 1000000L;
        if (fileCount > 0L) {
            for (long i = 0L; i <= fileCount; ++i) {
                CsvTools.writeToMultipleFiles(source, destPath, filename, i * 1000000L, nullsAsEmpty);
            }
        } else {
            CsvTools.writeCsv(source, destPath + filename + ".csv", nullsAsEmpty, new String[0]);
        }
    }

    @ScriptApi
    public static void writeToMultipleFiles(Table table, String path, String filename, long startLine) throws IOException {
        CsvTools.writeToMultipleFiles(table, path, filename, startLine, true);
    }

    @ScriptApi
    public static void writeToMultipleFiles(Table table, String path, String filename, long startLine, boolean nullsAsEmpty) throws IOException {
        Table part = table.getSubTable((TrackingRowSet)table.getRowSet().subSetByPositionRange(startLine, startLine + 1000000L).toTracking());
        String partFilename = path + filename + "-" + startLine + ".csv";
        CsvTools.writeCsv(part, partFilename, nullsAsEmpty, new String[0]);
    }

    @ScriptApi
    public static void writeCsvContents(Table source, Writer out, TimeZone timeZone, String ... colNames) throws IOException {
        CsvTools.writeCsvContents(source, out, timeZone, null, colNames);
    }

    @ScriptApi
    public static void writeCsvContents(Table source, Writer out, TimeZone timeZone, boolean nullsAsEmpty, String ... colNames) throws IOException {
        CsvTools.writeCsvContents(source, out, timeZone, null, nullsAsEmpty, colNames);
    }

    @ScriptApi
    public static void writeCsvContents(Table source, Writer out, TimeZone timeZone, @Nullable Procedure.Binary<Long, Long> progress, String ... colNames) throws IOException {
        CsvTools.writeCsvContents(source, out, timeZone, progress, true, colNames);
    }

    @ScriptApi
    public static void writeCsvContents(Table source, Writer out, TimeZone timeZone, @Nullable Procedure.Binary<Long, Long> progress, boolean nullsAsEmpty, String ... colNames) throws IOException {
        CsvTools.writeCsvContents(source, out, timeZone, progress, nullsAsEmpty, ',', colNames);
    }

    @ScriptApi
    public static void writeCsvContents(Table source, Writer out, TimeZone timeZone, @Nullable Procedure.Binary<Long, Long> progress, boolean nullsAsEmpty, char separator, String ... colNames) throws IOException {
        if (colNames.length == 0) {
            return;
        }
        DataColumn[] cols = new DataColumn[colNames.length];
        for (int c = 0; c < colNames.length; ++c) {
            cols[c] = source.getColumn(colNames[c]);
        }
        long size = cols[0].size();
        CsvTools.writeCsvContentsSeq(out, timeZone, cols, size, nullsAsEmpty, separator, progress);
    }

    protected static String separatorCsvEscape(String str, String separator) {
        if (str.contains("\"") || str.contains("\n") || str.contains(separator)) {
            return "\"" + str.replaceAll("\"", "\"\"") + "\"";
        }
        return str;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeCsvContentsSeq(Writer out, TimeZone timeZone, DataColumn[] cols, long size, boolean nullsAsEmpty, char separator, @Nullable Procedure.Binary<Long, Long> progress) throws IOException {
        QueryPerformanceNugget nugget = QueryPerformanceRecorder.getInstance().getNugget("CsvTools.writeCsvContentsSeq()");
        try {
            String separatorStr = String.valueOf(separator);
            for (long i = 0L; i < size; ++i) {
                for (int j = 0; j < cols.length; ++j) {
                    if (j > 0) {
                        out.write(separatorStr);
                    } else {
                        out.write("\n");
                    }
                    Object o = cols[j].get(i);
                    if (o instanceof String) {
                        out.write(CsvTools.separatorCsvEscape((String)o, separatorStr));
                        continue;
                    }
                    if (o instanceof DateTime) {
                        out.write(CsvTools.separatorCsvEscape(((DateTime)o).toString(timeZone), separatorStr));
                        continue;
                    }
                    out.write(nullsAsEmpty ? CsvTools.separatorCsvEscape(o == null ? "" : o.toString(), separatorStr) : CsvTools.separatorCsvEscape(TableTools.nullToNullString((Object)o), separatorStr));
                }
                if (progress == null) continue;
                progress.call((Object)i, (Object)size);
            }
        }
        finally {
            nugget.done();
        }
    }

    public static CsvSpecs fromLegacyFormat(String format) {
        CsvSpecs.Builder builder = CsvTools.builder();
        if (format == null) {
            return builder.build();
        }
        if (format.length() == 1) {
            return builder.delimiter(format.charAt(0)).build();
        }
        if ("TRIM".equals(format)) {
            return builder.trim(true).build();
        }
        if ("DEFAULT".equals(format)) {
            return builder.ignoreSurroundingSpaces(false).build();
        }
        if ("TDF".equals(format)) {
            return builder.delimiter('\t').build();
        }
        return null;
    }

    private static SinkFactory makeMySinkFactory() {
        return SinkFactory.of(MyByteSink::new, (Byte)QueryConstants.NULL_BYTE_BOXED, MyShortSink::new, (Short)QueryConstants.NULL_SHORT_BOXED, MyIntSink::new, (Integer)QueryConstants.NULL_INT_BOXED, MyLongSink::new, (Long)QueryConstants.NULL_LONG_BOXED, MyFloatSink::new, (Float)QueryConstants.NULL_FLOAT_BOXED, MyDoubleSink::new, (Double)QueryConstants.NULL_DOUBLE_BOXED, MyBooleanAsByteSink::new, MyCharSink::new, (Character)Character.valueOf('\uffff'), MyStringSink::new, null, MyDateTimeAsLongSink::new, (Long)Long.MIN_VALUE, MyDateTimeAsLongSink::new, (Long)Long.MIN_VALUE);
    }

    private static final class MyDateTimeAsLongSink
    extends MySinkBase<DateTime, long[]> {
        public MyDateTimeAsLongSink(int columnIndex) {
            super(new DateTimeArraySource(), Long.TYPE, LongChunk::chunkWrap);
        }

        @Override
        protected void nullFlagsToValues(long[] values, boolean[] isNull, int size) {
            for (int ii = 0; ii != size; ++ii) {
                if (!isNull[ii]) continue;
                values[ii] = Long.MIN_VALUE;
            }
        }
    }

    private static final class MyStringSink
    extends MySinkBase<String, String[]> {
        public MyStringSink(int columnIndex) {
            super(new ObjectArraySource(String.class), (Class<?>)null, ObjectChunk::chunkWrap);
        }

        @Override
        protected void nullFlagsToValues(String[] values, boolean[] isNull, int size) {
            for (int ii = 0; ii != size; ++ii) {
                if (!isNull[ii]) continue;
                values[ii] = null;
            }
        }
    }

    private static final class MyDoubleSink
    extends MySinkBase<Double, double[]> {
        public MyDoubleSink(int columnIndex) {
            super(new DoubleArraySource(), (Class<?>)null, DoubleChunk::chunkWrap);
        }

        @Override
        protected void nullFlagsToValues(double[] values, boolean[] isNull, int size) {
            for (int ii = 0; ii != size; ++ii) {
                if (!isNull[ii]) continue;
                values[ii] = -1.7976931348623157E308;
            }
        }
    }

    private static final class MyFloatSink
    extends MySinkBase<Float, float[]> {
        public MyFloatSink(int columnIndex) {
            super(new FloatArraySource(), (Class<?>)null, FloatChunk::chunkWrap);
        }

        @Override
        protected void nullFlagsToValues(float[] values, boolean[] isNull, int size) {
            for (int ii = 0; ii != size; ++ii) {
                if (!isNull[ii]) continue;
                values[ii] = -3.4028235E38f;
            }
        }
    }

    private static final class MyLongSink
    extends MySourceAndSinkBase<Long, long[]> {
        public MyLongSink(int columnIndex) {
            super(new LongArraySource(), (Class<?>)null, LongChunk::chunkWrap, WritableLongChunk::writableChunkWrap);
        }

        @Override
        protected void nullFlagsToValues(long[] values, boolean[] isNull, int size) {
            for (int ii = 0; ii != size; ++ii) {
                if (!isNull[ii]) continue;
                values[ii] = Long.MIN_VALUE;
            }
        }

        @Override
        protected void valuesToNullFlags(long[] values, boolean[] isNull, int size) {
            for (int ii = 0; ii < size; ++ii) {
                isNull[ii] = values[ii] == Long.MIN_VALUE;
            }
        }
    }

    private static final class MyIntSink
    extends MySourceAndSinkBase<Integer, int[]> {
        public MyIntSink(int columnIndex) {
            super(new IntegerArraySource(), (Class<?>)null, IntChunk::chunkWrap, WritableIntChunk::writableChunkWrap);
        }

        @Override
        protected void nullFlagsToValues(int[] values, boolean[] isNull, int size) {
            for (int ii = 0; ii != size; ++ii) {
                if (!isNull[ii]) continue;
                values[ii] = Integer.MIN_VALUE;
            }
        }

        @Override
        protected void valuesToNullFlags(int[] values, boolean[] isNull, int size) {
            for (int ii = 0; ii < size; ++ii) {
                isNull[ii] = values[ii] == Integer.MIN_VALUE;
            }
        }
    }

    private static final class MyShortSink
    extends MySourceAndSinkBase<Short, short[]> {
        public MyShortSink(int columnIndex) {
            super(new ShortArraySource(), (Class<?>)null, ShortChunk::chunkWrap, WritableShortChunk::writableChunkWrap);
        }

        @Override
        protected void nullFlagsToValues(short[] values, boolean[] isNull, int size) {
            for (int ii = 0; ii != size; ++ii) {
                if (!isNull[ii]) continue;
                values[ii] = Short.MIN_VALUE;
            }
        }

        @Override
        protected void valuesToNullFlags(short[] values, boolean[] isNull, int size) {
            for (int ii = 0; ii < size; ++ii) {
                isNull[ii] = values[ii] == Short.MIN_VALUE;
            }
        }
    }

    private static final class MyByteSink
    extends MySourceAndSinkBase<Byte, byte[]> {
        public MyByteSink(int columnIndex) {
            super(new ByteArraySource(), (Class<?>)null, ByteChunk::chunkWrap, WritableByteChunk::writableChunkWrap);
        }

        @Override
        protected void nullFlagsToValues(byte[] values, boolean[] isNull, int size) {
            for (int ii = 0; ii != size; ++ii) {
                if (!isNull[ii]) continue;
                values[ii] = -128;
            }
        }

        @Override
        protected void valuesToNullFlags(byte[] values, boolean[] isNull, int size) {
            for (int ii = 0; ii < size; ++ii) {
                isNull[ii] = values[ii] == -128;
            }
        }
    }

    private static final class MyBooleanAsByteSink
    extends MySinkBase<Boolean, byte[]> {
        public MyBooleanAsByteSink(int columnIndex) {
            super(new BooleanArraySource(), Byte.TYPE, ByteChunk::chunkWrap);
        }

        @Override
        protected void nullFlagsToValues(byte[] values, boolean[] isNull, int size) {
            for (int ii = 0; ii < size; ++ii) {
                if (!isNull[ii]) continue;
                values[ii] = -128;
            }
        }
    }

    private static final class MyCharSink
    extends MySinkBase<Character, char[]> {
        public MyCharSink(int columnIndex) {
            super(new CharacterArraySource(), (Class<?>)null, CharChunk::chunkWrap);
        }

        @Override
        protected void nullFlagsToValues(char[] values, boolean[] isNull, int size) {
            for (int ii = 0; ii < size; ++ii) {
                if (!isNull[ii]) continue;
                values[ii] = 65535;
            }
        }
    }

    private static abstract class MySourceAndSinkBase<TYPE, TARRAY>
    extends MySinkBase<TYPE, TARRAY>
    implements Source<TARRAY>,
    Sink<TARRAY> {
        private final MySinkBase.ChunkWrapInvoker<TARRAY, WritableChunk<? super Values>> writableChunkWrapInvoker;

        public MySourceAndSinkBase(ArrayBackedColumnSource<TYPE> result, Class<?> interpClass, MySinkBase.ChunkWrapInvoker<TARRAY, Chunk<? extends Values>> chunkWrapInvoker, MySinkBase.ChunkWrapInvoker<TARRAY, WritableChunk<? super Values>> writeableChunkWrapInvoker) {
            super(result, interpClass, chunkWrapInvoker);
            this.writableChunkWrapInvoker = writeableChunkWrapInvoker;
        }

        public final void read(TARRAY dest, boolean[] isNull, long srcBegin, long srcEnd) {
            if (srcBegin == srcEnd) {
                return;
            }
            int size = Math.toIntExact(srcEnd - srcBegin);
            try (ChunkSource.FillContext context = this.reinterpreted.makeFillContext(size);
                 RowSequence range = RowSequenceFactory.forRange((long)srcBegin, (long)(srcEnd - 1L));){
                WritableChunk<? super Values> chunk = this.writableChunkWrapInvoker.apply(dest, 0, size);
                this.reinterpreted.fillChunk(context, chunk, range);
            }
            this.valuesToNullFlags(dest, isNull, size);
        }

        protected abstract void valuesToNullFlags(TARRAY var1, boolean[] var2, int var3);
    }

    private static abstract class MySinkBase<TYPE, TARRAY>
    implements Sink<TARRAY> {
        protected final ArrayBackedColumnSource<TYPE> result;
        protected long resultSize;
        protected final WritableColumnSource<?> reinterpreted;
        protected final ChunkWrapInvoker<TARRAY, Chunk<? extends Values>> chunkWrapInvoker;

        public MySinkBase(ArrayBackedColumnSource<TYPE> result, Class<?> interpClass, ChunkWrapInvoker<TARRAY, Chunk<? extends Values>> chunkWrapInvoker) {
            this.result = result;
            this.resultSize = 0L;
            this.reinterpreted = interpClass != null ? (WritableColumnSource)result.reinterpret(interpClass) : result;
            this.chunkWrapInvoker = chunkWrapInvoker;
        }

        public final void write(TARRAY src, boolean[] isNull, long destBegin, long destEnd, boolean appending_unused) {
            if (destBegin == destEnd) {
                return;
            }
            int size = Math.toIntExact(destEnd - destBegin);
            this.nullFlagsToValues(src, isNull, size);
            this.reinterpreted.ensureCapacity(destEnd);
            this.resultSize = Math.max(this.resultSize, destEnd);
            try (ChunkSink.FillFromContext context = this.reinterpreted.makeFillFromContext(size);
                 RowSequence range = RowSequenceFactory.forRange((long)destBegin, (long)(destEnd - 1L));){
                Chunk<? extends Values> chunk = this.chunkWrapInvoker.apply(src, 0, size);
                this.reinterpreted.fillFromChunk(context, chunk, range);
            }
        }

        protected abstract void nullFlagsToValues(TARRAY var1, boolean[] var2, int var3);

        public ArrayBackedColumnSource<TYPE> result() {
            return this.result;
        }

        public Object getUnderlying() {
            return this.result;
        }

        public long resultSize() {
            return this.resultSize;
        }

        protected static interface ChunkWrapInvoker<TARRAY, TRESULT> {
            public TRESULT apply(TARRAY var1, int var2, int var3);
        }
    }
}

