/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.csv;

import gnu.trove.map.hash.TIntObjectHashMap;
import io.deephaven.csv.containers.ByteSlice;
import io.deephaven.csv.tokenization.RangeTests;
import io.deephaven.csv.tokenization.Tokenizer;
import io.deephaven.csv.util.MutableLong;
import io.deephaven.csv.util.MutableObject;
import io.deephaven.time.TimeZone;
import java.time.ZoneId;

public final class DeephavenTimeZoneParser
implements Tokenizer.CustomTimeZoneParser {
    private static final String DEEPHAVEN_TZ_PREFIX = "TZ_";
    private static final int MAX_DEEPHAVEN_TZ_LENGTH = 3;
    private static final TIntObjectHashMap<ZoneId> ZONE_ID_MAP = DeephavenTimeZoneParser.createZoneIdMap();
    private int lastTzKey = -1;
    private ZoneId lastZoneId = null;

    public boolean tryParse(ByteSlice bs, MutableObject<ZoneId> zoneId, MutableLong offsetSeconds) {
        if (bs.size() == 0 || bs.front() != 32) {
            return false;
        }
        int savedBegin = bs.begin();
        bs.setBegin(bs.begin() + 1);
        int tzKey = DeephavenTimeZoneParser.tryParseTzKey(bs);
        if (tzKey < 0) {
            bs.setBegin(savedBegin);
            return false;
        }
        if (tzKey != this.lastTzKey) {
            ZoneId res = (ZoneId)ZONE_ID_MAP.get(tzKey);
            if (res == null) {
                bs.setBegin(savedBegin);
                return false;
            }
            this.lastTzKey = tzKey;
            this.lastZoneId = res;
        }
        zoneId.setValue((Object)this.lastZoneId);
        offsetSeconds.setValue(0L);
        return true;
    }

    private static int tryParseTzKey(ByteSlice bs) {
        int current;
        int res = 0;
        for (current = bs.begin(); current != bs.end(); ++current) {
            if (current - bs.begin() > 3) {
                return -1;
            }
            char ch = RangeTests.toUpper((char)((char)bs.data()[current]));
            if (!RangeTests.isUpper((char)ch)) break;
            res = res * 26 + (ch - 65);
        }
        if (current - bs.begin() == 0) {
            return -1;
        }
        bs.setBegin(current);
        return res;
    }

    private static TIntObjectHashMap<ZoneId> createZoneIdMap() {
        TIntObjectHashMap zoneIdMap = new TIntObjectHashMap();
        for (TimeZone zone : TimeZone.values()) {
            String zname = zone.name();
            if (!zname.startsWith(DEEPHAVEN_TZ_PREFIX)) {
                throw new RuntimeException("Logic error: unexpected enum in DBTimeZone: " + zname);
            }
            String zSuffix = zname.substring(DEEPHAVEN_TZ_PREFIX.length());
            int zlen = zSuffix.length();
            if (zlen > 3) {
                throw new RuntimeException("Logic error: unexpectedly-long enum in DBTimeZone: " + zname);
            }
            byte[] data = new byte[zlen];
            for (int ii = 0; ii < zlen; ++ii) {
                char ch = zSuffix.charAt(ii);
                if (!RangeTests.isUpper((char)ch)) {
                    throw new RuntimeException("Logic error: unexpected character in DBTimeZone name: " + zname);
                }
                data[ii] = (byte)ch;
            }
            ByteSlice bs = new ByteSlice(data, 0, data.length);
            int tzKey = DeephavenTimeZoneParser.tryParseTzKey(bs);
            if (tzKey < 0) {
                throw new RuntimeException("Logic error: can't parse DBTimeZone as key: " + zname);
            }
            ZoneId zoneId = zone.getTimeZone().toTimeZone().toZoneId();
            zoneIdMap.put(tzKey, (Object)zoneId);
        }
        return zoneIdMap;
    }
}

