/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.kafka;

import io.deephaven.chunk.ChunkType;
import io.deephaven.chunk.WritableChunk;
import io.deephaven.stream.StreamConsumer;
import io.deephaven.stream.StreamPublisher;
import java.util.function.IntFunction;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

public class StreamPublisherImpl
implements StreamPublisher {
    private StreamConsumer streamConsumer;
    private WritableChunk[] chunks;
    private Supplier<WritableChunk[]> chunkFactory;
    private IntFunction<ChunkType> chunkTypeIntFunction;

    public void setChunkFactory(Supplier<WritableChunk[]> chunkFactory, IntFunction<ChunkType> chunkTypeIntFunction) {
        if (this.chunkFactory != null) {
            throw new IllegalStateException("Can not reset the chunkFactory for a StreamPublisherImpl");
        }
        this.chunkFactory = chunkFactory;
        this.chunkTypeIntFunction = chunkTypeIntFunction;
    }

    public void register(@NotNull StreamConsumer consumer) {
        if (this.streamConsumer != null) {
            throw new IllegalStateException("Can not register multiple StreamConsumers.");
        }
        this.streamConsumer = consumer;
    }

    public ChunkType chunkType(int index) {
        return this.chunkTypeIntFunction.apply(index);
    }

    public synchronized WritableChunk[] getChunks() {
        if (this.chunks == null) {
            this.chunks = this.chunkFactory.get();
        }
        return this.chunks;
    }

    public synchronized void flush() {
        if (this.chunks != null) {
            this.streamConsumer.accept(this.chunks);
            this.chunks = null;
        }
    }

    public synchronized long doLocked(LongSupplier fun) {
        return fun.getAsLong();
    }
}

