/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.kafka.ingest;

import io.deephaven.chunk.ChunkType;
import io.deephaven.engine.table.TableDefinition;
import io.deephaven.kafka.ingest.FieldCopier;
import io.deephaven.kafka.ingest.GenericRecordArrayFieldCopier;
import io.deephaven.kafka.ingest.GenericRecordBigDecimalFieldCopier;
import io.deephaven.kafka.ingest.GenericRecordBooleanFieldCopier;
import io.deephaven.kafka.ingest.GenericRecordByteFieldCopier;
import io.deephaven.kafka.ingest.GenericRecordCharFieldCopier;
import io.deephaven.kafka.ingest.GenericRecordDateTimeArrayFieldCopier;
import io.deephaven.kafka.ingest.GenericRecordDoubleFieldCopier;
import io.deephaven.kafka.ingest.GenericRecordFloatFieldCopier;
import io.deephaven.kafka.ingest.GenericRecordIntFieldCopier;
import io.deephaven.kafka.ingest.GenericRecordLongFieldCopier;
import io.deephaven.kafka.ingest.GenericRecordLongFieldCopierWithMultiplier;
import io.deephaven.kafka.ingest.GenericRecordObjectFieldCopier;
import io.deephaven.kafka.ingest.GenericRecordShortFieldCopier;
import io.deephaven.kafka.ingest.GenericRecordStringFieldCopier;
import io.deephaven.kafka.ingest.GenericRecordUtil;
import io.deephaven.kafka.ingest.MultiFieldChunkAdapter;
import io.deephaven.time.DateTime;
import java.math.BigDecimal;
import java.util.Map;
import java.util.function.IntFunction;
import java.util.regex.Pattern;
import org.apache.avro.LogicalType;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;

public class GenericRecordChunkAdapter
extends MultiFieldChunkAdapter {
    private GenericRecordChunkAdapter(TableDefinition definition, IntFunction<ChunkType> chunkTypeForIndex, Map<String, String> fieldNamesToColumnNames, Pattern separator, Schema schema, boolean allowNulls) {
        super(definition, chunkTypeForIndex, fieldNamesToColumnNames, allowNulls, (fieldPathStr, chunkType, dataType, componentType) -> GenericRecordChunkAdapter.makeFieldCopier(schema, fieldPathStr, separator, chunkType, dataType, componentType));
    }

    public static GenericRecordChunkAdapter make(TableDefinition definition, IntFunction<ChunkType> chunkTypeForIndex, Map<String, String> columns, Pattern separator, Schema schema, boolean allowNulls) {
        return new GenericRecordChunkAdapter(definition, chunkTypeForIndex, columns, separator, schema, allowNulls);
    }

    private static Schema getFieldSchema(Schema schema, String fieldPathStr, Pattern separator) {
        String[] fieldPath = GenericRecordUtil.getFieldPath(fieldPathStr, separator);
        Schema fieldSchema = GenericRecordUtil.getFieldSchema(schema, fieldPath);
        return fieldSchema;
    }

    private static LogicalType getLogicalType(Schema schema, String fieldPathStr, Pattern separator) {
        Schema fieldSchema = GenericRecordChunkAdapter.getFieldSchema(schema, fieldPathStr, separator);
        LogicalType logicalType = fieldSchema.getLogicalType();
        return logicalType;
    }

    private static LogicalType getArrayTypeLogicalType(Schema schema, String fieldPathStr, Pattern separator) {
        Schema fieldSchema = GenericRecordChunkAdapter.getFieldSchema(schema, fieldPathStr, separator);
        LogicalType logicalType = fieldSchema.getElementType().getLogicalType();
        return logicalType;
    }

    private static FieldCopier makeFieldCopier(Schema schema, String fieldPathStr, Pattern separator, ChunkType chunkType, Class<?> dataType, Class<?> componentType) {
        switch (chunkType) {
            case Char: {
                return new GenericRecordCharFieldCopier(fieldPathStr, separator, schema);
            }
            case Byte: {
                if (dataType == Boolean.class || dataType == Boolean.TYPE) {
                    return new GenericRecordBooleanFieldCopier(fieldPathStr, separator, schema);
                }
                return new GenericRecordByteFieldCopier(fieldPathStr, separator, schema);
            }
            case Short: {
                return new GenericRecordShortFieldCopier(fieldPathStr, separator, schema);
            }
            case Int: {
                return new GenericRecordIntFieldCopier(fieldPathStr, separator, schema);
            }
            case Long: {
                if (dataType == DateTime.class) {
                    LogicalType logicalType = GenericRecordChunkAdapter.getLogicalType(schema, fieldPathStr, separator);
                    if (logicalType == null) {
                        throw new IllegalArgumentException("Can not map field without a logical type to DateTime: field=" + fieldPathStr);
                    }
                    if (logicalType instanceof LogicalTypes.TimestampMillis) {
                        return new GenericRecordLongFieldCopierWithMultiplier(fieldPathStr, separator, schema, 1000000L);
                    }
                    if (logicalType instanceof LogicalTypes.TimestampMicros) {
                        return new GenericRecordLongFieldCopierWithMultiplier(fieldPathStr, separator, schema, 1000L);
                    }
                    throw new IllegalArgumentException("Can not map field with unknown logical type to DateTime: field=" + fieldPathStr + ", logical type=" + logicalType);
                }
                return new GenericRecordLongFieldCopier(fieldPathStr, separator, schema);
            }
            case Float: {
                return new GenericRecordFloatFieldCopier(fieldPathStr, separator, schema);
            }
            case Double: {
                return new GenericRecordDoubleFieldCopier(fieldPathStr, separator, schema);
            }
            case Object: {
                if (dataType == String.class) {
                    return new GenericRecordStringFieldCopier(fieldPathStr, separator, schema);
                }
                if (dataType == BigDecimal.class) {
                    String[] fieldPath = GenericRecordUtil.getFieldPath(fieldPathStr, separator);
                    Schema fieldSchema = GenericRecordUtil.getFieldSchema(schema, fieldPath);
                    LogicalType logicalType = fieldSchema.getLogicalType();
                    if (logicalType instanceof LogicalTypes.Decimal) {
                        LogicalTypes.Decimal decimalType = (LogicalTypes.Decimal)logicalType;
                        return new GenericRecordBigDecimalFieldCopier(fieldPathStr, separator, schema, decimalType.getPrecision(), decimalType.getScale());
                    }
                    throw new IllegalArgumentException("Can not map field with non matching logical type to BigDecimal: field=" + fieldPathStr + ", logical type=" + logicalType);
                }
                if (dataType.isArray()) {
                    if (DateTime.class.isAssignableFrom(componentType)) {
                        LogicalType logicalType = GenericRecordChunkAdapter.getArrayTypeLogicalType(schema, fieldPathStr, separator);
                        if (logicalType == null) {
                            throw new IllegalArgumentException("Can not map field without a logical type to DateTime[]: field=" + fieldPathStr);
                        }
                        if (logicalType instanceof LogicalTypes.TimestampMillis) {
                            return new GenericRecordDateTimeArrayFieldCopier(fieldPathStr, separator, schema, 1000000L);
                        }
                        if (logicalType instanceof LogicalTypes.TimestampMicros) {
                            return new GenericRecordDateTimeArrayFieldCopier(fieldPathStr, separator, schema, 1000L);
                        }
                        throw new IllegalArgumentException("Can not map field with unknown logical type to DateTime[]: field=" + fieldPathStr + ", logical type=" + logicalType);
                    }
                    return new GenericRecordArrayFieldCopier(fieldPathStr, separator, schema, componentType);
                }
                return new GenericRecordObjectFieldCopier(fieldPathStr, separator, schema);
            }
        }
        throw new IllegalArgumentException("Can not convert field of type " + dataType);
    }
}

