/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.kafka.ingest;

import io.deephaven.chunk.ObjectChunk;
import io.deephaven.chunk.WritableChunk;
import io.deephaven.chunk.WritableObjectChunk;
import io.deephaven.chunk.attributes.Values;
import io.deephaven.kafka.ingest.GenericRecordFieldCopier;
import io.deephaven.kafka.ingest.GenericRecordUtil;
import io.deephaven.time.DateTime;
import io.deephaven.time.DateTimeUtils;
import java.util.regex.Pattern;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericArray;
import org.apache.avro.generic.GenericRecord;

public class GenericRecordDateTimeArrayFieldCopier
extends GenericRecordFieldCopier {
    private final long multiplier;

    public GenericRecordDateTimeArrayFieldCopier(String fieldPathStr, Pattern separator, Schema schema, long multiplier) {
        super(fieldPathStr, separator, schema);
        this.multiplier = multiplier;
    }

    private static DateTime[] convertArray(GenericArray<?> ga, long multiplier) {
        int gaSize = ga.size();
        if (gaSize == 0) {
            return DateTimeUtils.ZERO_LENGTH_DATETIME_ARRAY;
        }
        DateTime[] out = new DateTime[ga.size()];
        int i = 0;
        for (Object o : ga) {
            out[i] = new DateTime(multiplier * (Long)o);
            ++i;
        }
        return out;
    }

    @Override
    public void copyField(ObjectChunk<Object, Values> inputChunk, WritableChunk<Values> publisherChunk, int sourceOffset, int destOffset, int length) {
        WritableObjectChunk output = publisherChunk.asWritableObjectChunk();
        for (int ii = 0; ii < length; ++ii) {
            GenericRecord record = (GenericRecord)inputChunk.get(ii + sourceOffset);
            GenericArray genericArray = (GenericArray)GenericRecordUtil.getPath(record, this.fieldPath);
            if (genericArray == null) {
                output.set(ii + destOffset, null);
                continue;
            }
            output.set(ii + destOffset, (Object)GenericRecordDateTimeArrayFieldCopier.convertArray(genericArray, this.multiplier));
        }
    }
}

