/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.kafka.ingest;

import io.deephaven.chunk.ObjectChunk;
import io.deephaven.chunk.WritableChunk;
import io.deephaven.chunk.WritableLongChunk;
import io.deephaven.chunk.attributes.Values;
import io.deephaven.kafka.ingest.GenericRecordFieldCopier;
import io.deephaven.kafka.ingest.GenericRecordUtil;
import io.deephaven.util.type.TypeUtils;
import java.util.regex.Pattern;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;

public class GenericRecordLongFieldCopier
extends GenericRecordFieldCopier {
    public GenericRecordLongFieldCopier(String fieldPathStr, Pattern separator, Schema schema) {
        super(fieldPathStr, separator, schema);
    }

    @Override
    public void copyField(ObjectChunk<Object, Values> inputChunk, WritableChunk<Values> publisherChunk, int sourceOffset, int destOffset, int length) {
        WritableLongChunk output = publisherChunk.asWritableLongChunk();
        for (int ii = 0; ii < length; ++ii) {
            GenericRecord record = (GenericRecord)inputChunk.get(ii + sourceOffset);
            Long value = (Long)GenericRecordUtil.getPath(record, this.fieldPath);
            output.set(ii + destOffset, TypeUtils.unbox((Long)value));
        }
    }
}

