/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.kafka.ingest;

import io.deephaven.kafka.KafkaSchemaUtils;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;

public class GenericRecordUtil {
    public static int[] getFieldPath(String fieldName, Pattern separator, Schema schema) {
        if (fieldName == null) {
            return null;
        }
        String[] strFieldPath = separator.split(fieldName);
        int[] fieldPath = new int[strFieldPath.length];
        Schema currSchema = schema;
        int i = 0;
        while (true) {
            if (currSchema.isUnion()) {
                List unionTypes = currSchema.getTypes();
                String errMsg = ": only union schemas of two elements where one is NULL are supported";
                if (unionTypes.size() != 2) {
                    throw new IllegalArgumentException(GenericRecordUtil.formatUnionSchema(currSchema) + ": only union schemas of two elements where one is NULL are supported");
                }
                Schema unionType0 = (Schema)unionTypes.get(0);
                Schema unionType1 = (Schema)unionTypes.get(1);
                if (unionType0.getType() == Schema.Type.NULL) {
                    currSchema = unionType1;
                } else if (unionType1.getType() == Schema.Type.NULL) {
                    currSchema = unionType0;
                } else {
                    throw new IllegalArgumentException(GenericRecordUtil.formatUnionSchema(currSchema) + ": only union schemas of two elements where one is NULL are supported");
                }
            }
            Schema.Field currField = currSchema.getField(strFieldPath[i]);
            fieldPath[i] = currField.pos();
            if (++i == fieldPath.length) break;
            currSchema = currField.schema();
        }
        return fieldPath;
    }

    public static String[] getFieldPath(String fieldName, Pattern separator) {
        if (fieldName == null) {
            return null;
        }
        return separator.split(fieldName);
    }

    public static Object getPath(GenericRecord record, int[] fieldPath) {
        int i;
        if (record == null) {
            return null;
        }
        GenericRecord parentRecord = record;
        for (i = 0; i < fieldPath.length - 1; ++i) {
            if ((parentRecord = (GenericRecord)parentRecord.get(fieldPath[i])) != null) continue;
            return null;
        }
        return parentRecord.get(fieldPath[i]);
    }

    public static Schema getFieldSchema(Schema schema, String[] fieldPath) {
        Schema s = schema;
        for (int i = 0; i < fieldPath.length; ++i) {
            String fieldName = fieldPath[i];
            Schema.Field field = s.getField(fieldName);
            if (field == null) {
                String partialFieldName = Arrays.toString(Arrays.copyOf(fieldPath, i + 1));
                throw new IllegalArgumentException("Can't find field for path " + partialFieldName);
            }
            s = KafkaSchemaUtils.getEffectiveSchema(fieldName, field.schema());
        }
        return s;
    }

    private static String formatUnionSchema(Schema schema) {
        List unionTypes = schema.getTypes();
        StringBuilder sb = new StringBuilder("Union schema ");
        sb.append("name=").append(schema.getFullName());
        sb.append(" with ").append(unionTypes.size()).append(" elements [");
        int i = 0;
        for (Schema element : unionTypes) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append("(");
            sb.append("name=").append(element.getName());
            sb.append(", ");
            sb.append("type=").append(element.getType().toString());
            sb.append(")");
        }
        sb.append("]");
        return sb.toString();
    }
}

