/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.kafka.ingest;

import com.fasterxml.jackson.core.JsonPointer;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import io.deephaven.UncheckedDeephavenException;
import io.deephaven.time.DateTime;
import io.deephaven.time.DateTimeUtils;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonNodeUtil {
    private static final ObjectMapper objectMapper = new ObjectMapper().setNodeFactory(JsonNodeFactory.withExactBigDecimals((boolean)true)).configure(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS, true);

    public static JsonNode makeJsonNode(String json) {
        try {
            return objectMapper.readTree(json);
        }
        catch (JsonProcessingException ex) {
            throw new UncheckedDeephavenException("Failed to parse JSON string.", (Throwable)ex);
        }
    }

    private static JsonNode checkAllowMissingOrNull(JsonNode node, @NotNull String key, boolean allowMissingKeys, boolean allowNullValues) {
        JsonNode tmpNode = node == null ? null : node.get(key);
        JsonNodeUtil.checkNode(key, tmpNode, allowMissingKeys, allowNullValues);
        return tmpNode;
    }

    private static JsonNode checkAllowMissingOrNull(JsonNode node, @NotNull JsonPointer ptr, boolean allowMissingKeys, boolean allowNullValues) {
        JsonNode tmpNode = node == null ? null : node.at(ptr);
        JsonNodeUtil.checkNode(ptr, tmpNode, allowMissingKeys, allowNullValues);
        return tmpNode;
    }

    private static void checkNode(Object key, JsonNode node, boolean allowMissingKeys, boolean allowNullValues) {
        if (!allowMissingKeys && (node == null || node.isMissingNode())) {
            throw new IllegalArgumentException(String.format("Key '%s' not found in the record, and allowMissingKeys is false.", key));
        }
        if (!allowNullValues && JsonNodeUtil.isNullOrMissingField(node)) {
            throw new IllegalArgumentException(String.format("Value for '%s' is null or missing in the record, and allowNullValues is false.", key));
        }
    }

    private static boolean isNullOrMissingField(JsonNode node) {
        return node == null || node.isNull() || node.isMissingNode();
    }

    public static int getInt(@NotNull JsonNode node, @NotNull String key, boolean allowMissingKeys, boolean allowNullValues) {
        JsonNode tmpNode = JsonNodeUtil.checkAllowMissingOrNull(node, key, allowMissingKeys, allowNullValues);
        return JsonNodeUtil.getInt(tmpNode);
    }

    public static int getInt(@NotNull JsonNode node, @NotNull JsonPointer ptr, boolean allowMissingKeys, boolean allowNullValues) {
        JsonNode tmpNode = JsonNodeUtil.checkAllowMissingOrNull(node, ptr, allowMissingKeys, allowNullValues);
        return JsonNodeUtil.getInt(tmpNode);
    }

    public static int getInt(JsonNode node) {
        return JsonNodeUtil.isNullOrMissingField(node) ? Integer.MIN_VALUE : node.asInt();
    }

    @Nullable
    public static Integer getBoxedInt(@NotNull JsonNode node, @NotNull String key, boolean allowMissingKeys, boolean allowNullValues) {
        JsonNode tmpNode = JsonNodeUtil.checkAllowMissingOrNull(node, key, allowMissingKeys, allowNullValues);
        return JsonNodeUtil.getBoxedInt(tmpNode);
    }

    @Nullable
    public static Integer getBoxedInt(JsonNode node) {
        return JsonNodeUtil.isNullOrMissingField(node) ? null : Integer.valueOf(node.asInt());
    }

    public static short getShort(@NotNull JsonNode node, @NotNull String key, boolean allowMissingKeys, boolean allowNullValues) {
        JsonNode tmpNode = JsonNodeUtil.checkAllowMissingOrNull(node, key, allowMissingKeys, allowNullValues);
        return JsonNodeUtil.getShort(tmpNode);
    }

    public static short getShort(@NotNull JsonNode node, @NotNull JsonPointer ptr, boolean allowMissingKeys, boolean allowNullValues) {
        JsonNode tmpNode = JsonNodeUtil.checkAllowMissingOrNull(node, ptr, allowMissingKeys, allowNullValues);
        return JsonNodeUtil.getShort(tmpNode);
    }

    public static short getShort(JsonNode node) {
        return JsonNodeUtil.isNullOrMissingField(node) ? (short)Short.MIN_VALUE : (short)node.asInt();
    }

    @Nullable
    public static Short getBoxedShort(@NotNull JsonNode node, @NotNull String key, boolean allowMissingKeys, boolean allowNullValues) {
        JsonNode tmpNode = JsonNodeUtil.checkAllowMissingOrNull(node, key, allowMissingKeys, allowNullValues);
        return JsonNodeUtil.getBoxedShort(tmpNode);
    }

    @Nullable
    public static Short getBoxedShort(JsonNode node) {
        return JsonNodeUtil.isNullOrMissingField(node) ? null : Short.valueOf((short)node.asInt());
    }

    public static long getLong(@NotNull JsonNode node, @NotNull String key, boolean allowMissingKeys, boolean allowNullValues) {
        JsonNode tmpNode = JsonNodeUtil.checkAllowMissingOrNull(node, key, allowMissingKeys, allowNullValues);
        return JsonNodeUtil.getLong(tmpNode);
    }

    public static long getLong(@NotNull JsonNode node, @NotNull JsonPointer ptr, boolean allowMissingKeys, boolean allowNullValues) {
        JsonNode tmpNode = JsonNodeUtil.checkAllowMissingOrNull(node, ptr, allowMissingKeys, allowNullValues);
        return JsonNodeUtil.getLong(tmpNode);
    }

    public static long getLong(JsonNode node) {
        return JsonNodeUtil.isNullOrMissingField(node) ? Long.MIN_VALUE : node.asLong();
    }

    @Nullable
    public static Long getBoxedLong(@NotNull JsonNode node, @NotNull String key, boolean allowMissingKeys, boolean allowNullValues) {
        JsonNode tmpNode = JsonNodeUtil.checkAllowMissingOrNull(node, key, allowMissingKeys, allowNullValues);
        return JsonNodeUtil.getBoxedLong(tmpNode);
    }

    @Nullable
    public static Long getBoxedLong(JsonNode node) {
        return JsonNodeUtil.isNullOrMissingField(node) ? null : Long.valueOf(node.asLong());
    }

    public static double getDouble(@NotNull JsonNode node, @NotNull String key, boolean allowMissingKeys, boolean allowNullValues) {
        JsonNode tmpNode = JsonNodeUtil.checkAllowMissingOrNull(node, key, allowMissingKeys, allowNullValues);
        return JsonNodeUtil.getDouble(tmpNode);
    }

    public static double getDouble(@NotNull JsonNode node, @NotNull JsonPointer ptr, boolean allowMissingKeys, boolean allowNullValues) {
        JsonNode tmpNode = JsonNodeUtil.checkAllowMissingOrNull(node, ptr, allowMissingKeys, allowNullValues);
        return JsonNodeUtil.getDouble(tmpNode);
    }

    public static double getDouble(JsonNode node) {
        return JsonNodeUtil.isNullOrMissingField(node) ? -1.7976931348623157E308 : node.asDouble();
    }

    @Nullable
    public static Double getBoxedDouble(@NotNull JsonNode node, @NotNull String key, boolean allowMissingKeys, boolean allowNullValues) {
        JsonNode tmpNode = JsonNodeUtil.checkAllowMissingOrNull(node, key, allowMissingKeys, allowNullValues);
        return JsonNodeUtil.getBoxedDouble(tmpNode);
    }

    @Nullable
    public static Double getBoxedDouble(JsonNode node) {
        return JsonNodeUtil.isNullOrMissingField(node) ? null : Double.valueOf(node.asDouble());
    }

    public static float getFloat(@NotNull JsonNode node, @NotNull String key, boolean allowMissingKeys, boolean allowNullValues) {
        JsonNode tmpNode = JsonNodeUtil.checkAllowMissingOrNull(node, key, allowMissingKeys, allowNullValues);
        return JsonNodeUtil.getFloat(tmpNode);
    }

    public static float getFloat(@NotNull JsonNode node, @NotNull JsonPointer ptr, boolean allowMissingKeys, boolean allowNullValues) {
        JsonNode tmpNode = JsonNodeUtil.checkAllowMissingOrNull(node, ptr, allowMissingKeys, allowNullValues);
        return JsonNodeUtil.getFloat(tmpNode);
    }

    public static float getFloat(JsonNode node) {
        return JsonNodeUtil.isNullOrMissingField(node) ? -3.4028235E38f : (float)node.asDouble();
    }

    @Nullable
    public static Float getBoxedFloat(@NotNull JsonNode node, @NotNull String key, boolean allowMissingKeys, boolean allowNullValues) {
        JsonNode tmpNode = JsonNodeUtil.checkAllowMissingOrNull(node, key, allowMissingKeys, allowNullValues);
        return JsonNodeUtil.getBoxedFloat(tmpNode);
    }

    @Nullable
    public static Float getBoxedFloat(JsonNode node) {
        return JsonNodeUtil.isNullOrMissingField(node) ? null : Float.valueOf((float)node.asDouble());
    }

    public static byte getByte(@NotNull JsonNode node, @NotNull String key, boolean allowMissingKeys, boolean allowNullValues) {
        JsonNode tmpNode = JsonNodeUtil.checkAllowMissingOrNull(node, key, allowMissingKeys, allowNullValues);
        return JsonNodeUtil.getByte(tmpNode);
    }

    public static byte getByte(@NotNull JsonNode node, @NotNull JsonPointer ptr, boolean allowMissingKeys, boolean allowNullValues) {
        JsonNode tmpNode = JsonNodeUtil.checkAllowMissingOrNull(node, ptr, allowMissingKeys, allowNullValues);
        return JsonNodeUtil.getByte(tmpNode);
    }

    public static byte getByte(JsonNode node) {
        if (JsonNodeUtil.isNullOrMissingField(node)) {
            return -128;
        }
        byte[] bytes = node.asText().getBytes();
        if (bytes.length == 0) {
            return -128;
        }
        return bytes[0];
    }

    @Nullable
    public static Byte getBoxedByte(@NotNull JsonNode node, @NotNull String key, boolean allowMissingKeys, boolean allowNullValues) {
        JsonNode tmpNode = JsonNodeUtil.checkAllowMissingOrNull(node, key, allowMissingKeys, allowNullValues);
        return JsonNodeUtil.getBoxedByte(tmpNode);
    }

    @Nullable
    public static Byte getBoxedByte(JsonNode node) {
        if (JsonNodeUtil.isNullOrMissingField(node)) {
            return null;
        }
        byte[] bytes = node.asText().getBytes();
        if (bytes.length == 0) {
            return null;
        }
        return bytes[0];
    }

    public static char getChar(@NotNull JsonNode node, @NotNull String key, boolean allowMissingKeys, boolean allowNullValues) {
        JsonNode tmpNode = JsonNodeUtil.checkAllowMissingOrNull(node, key, allowMissingKeys, allowNullValues);
        return JsonNodeUtil.getChar(tmpNode);
    }

    public static char getChar(@NotNull JsonNode node, @NotNull JsonPointer ptr, boolean allowMissingKeys, boolean allowNullValues) {
        JsonNode tmpNode = JsonNodeUtil.checkAllowMissingOrNull(node, ptr, allowMissingKeys, allowNullValues);
        return JsonNodeUtil.getChar(tmpNode);
    }

    public static char getChar(JsonNode node) {
        if (JsonNodeUtil.isNullOrMissingField(node)) {
            return '\uffff';
        }
        String s = node.asText();
        if (s.isEmpty()) {
            return '\uffff';
        }
        return s.charAt(0);
    }

    @Nullable
    public static Character getBoxedChar(@NotNull JsonNode node, @NotNull String key, boolean allowMissingKeys, boolean allowNullValues) {
        JsonNode tmpNode = JsonNodeUtil.checkAllowMissingOrNull(node, key, allowMissingKeys, allowNullValues);
        return JsonNodeUtil.getBoxedChar(tmpNode);
    }

    @Nullable
    public static Character getBoxedChar(JsonNode tmpNode) {
        if (JsonNodeUtil.isNullOrMissingField(tmpNode)) {
            return null;
        }
        String s = tmpNode.asText();
        if (s.isEmpty()) {
            return null;
        }
        return Character.valueOf(s.charAt(0));
    }

    @Nullable
    public static String getString(@NotNull JsonNode node, @NotNull String key, boolean allowMissingKeys, boolean allowNullValues) {
        JsonNode tmpNode = JsonNodeUtil.checkAllowMissingOrNull(node, key, allowMissingKeys, allowNullValues);
        return JsonNodeUtil.getString(tmpNode);
    }

    @Nullable
    public static String getString(@NotNull JsonNode node, @NotNull JsonPointer ptr, boolean allowMissingKeys, boolean allowNullValues) {
        JsonNode tmpNode = JsonNodeUtil.checkAllowMissingOrNull(node, ptr, allowMissingKeys, allowNullValues);
        return JsonNodeUtil.getString(tmpNode);
    }

    @Nullable
    public static String getString(JsonNode node) {
        if (JsonNodeUtil.isNullOrMissingField(node)) {
            return null;
        }
        return node.isValueNode() ? node.asText() : node.toString();
    }

    public static Boolean getBoolean(@NotNull JsonNode node, @NotNull String key, boolean allowMissingKeys, boolean allowNullValues) {
        JsonNode tmpNode = JsonNodeUtil.checkAllowMissingOrNull(node, key, allowMissingKeys, allowNullValues);
        return JsonNodeUtil.getBoolean(tmpNode);
    }

    public static Boolean getBoolean(@NotNull JsonNode node, @NotNull JsonPointer ptr, boolean allowMissingKeys, boolean allowNullValues) {
        JsonNode tmpNode = JsonNodeUtil.checkAllowMissingOrNull(node, ptr, allowMissingKeys, allowNullValues);
        return JsonNodeUtil.getBoolean(tmpNode);
    }

    @Nullable
    public static Boolean getBoolean(JsonNode node) {
        return JsonNodeUtil.isNullOrMissingField(node) ? null : Boolean.valueOf(node.asBoolean());
    }

    public static BigInteger getBigInteger(@NotNull JsonNode node, @NotNull String key, boolean allowMissingKeys, boolean allowNullValues) {
        JsonNode tmpNode = JsonNodeUtil.checkAllowMissingOrNull(node, key, allowMissingKeys, allowNullValues);
        return JsonNodeUtil.getBigInteger(tmpNode);
    }

    public static BigInteger getBigInteger(@NotNull JsonNode node, @NotNull JsonPointer ptr, boolean allowMissingKeys, boolean allowNullValues) {
        JsonNode tmpNode = JsonNodeUtil.checkAllowMissingOrNull(node, ptr, allowMissingKeys, allowNullValues);
        return JsonNodeUtil.getBigInteger(tmpNode);
    }

    @Nullable
    public static BigInteger getBigInteger(JsonNode node) {
        return JsonNodeUtil.isNullOrMissingField(node) ? null : node.bigIntegerValue();
    }

    @Nullable
    public static BigDecimal getBigDecimal(@NotNull JsonNode node, @NotNull String key, boolean allowMissingKeys, boolean allowNullValues) {
        JsonNode tmpNode = JsonNodeUtil.checkAllowMissingOrNull(node, key, allowMissingKeys, allowNullValues);
        return JsonNodeUtil.getBigDecimal(tmpNode);
    }

    @Nullable
    public static BigDecimal getBigDecimal(@NotNull JsonNode node, @NotNull JsonPointer ptr, boolean allowMissingKeys, boolean allowNullValues) {
        JsonNode tmpNode = JsonNodeUtil.checkAllowMissingOrNull(node, ptr, allowMissingKeys, allowNullValues);
        return JsonNodeUtil.getBigDecimal(tmpNode);
    }

    @Nullable
    public static BigDecimal getBigDecimal(JsonNode node) {
        return JsonNodeUtil.isNullOrMissingField(node) ? null : node.decimalValue();
    }

    @Nullable
    public static Object getValue(@NotNull JsonNode node, @NotNull String key, boolean allowMissingKeys, boolean allowNullValues) {
        JsonNode tmpNode = JsonNodeUtil.checkAllowMissingOrNull(node, key, allowMissingKeys, allowNullValues);
        return JsonNodeUtil.getValue(tmpNode);
    }

    @Nullable
    public static Object getValue(JsonNode node) {
        return JsonNodeUtil.isNullOrMissingField(node) ? null : node;
    }

    @Nullable
    public static DateTime getDateTime(@NotNull JsonNode node, @NotNull String key, boolean allowMissingKeys, boolean allowNullValues) {
        JsonNode tmpNode = JsonNodeUtil.checkAllowMissingOrNull(node, key, allowMissingKeys, allowNullValues);
        return JsonNodeUtil.getDateTime(tmpNode);
    }

    @Nullable
    public static DateTime getDateTime(@NotNull JsonNode node, @NotNull JsonPointer ptr, boolean allowMissingKeys, boolean allowNullValues) {
        JsonNode tmpNode = JsonNodeUtil.checkAllowMissingOrNull(node, ptr, allowMissingKeys, allowNullValues);
        return JsonNodeUtil.getDateTime(tmpNode);
    }

    @Nullable
    public static DateTime getDateTime(JsonNode node) {
        if (JsonNodeUtil.isNullOrMissingField(node)) {
            return null;
        }
        if (node.isLong() || node.isInt()) {
            long value = node.asLong();
            return DateTimeUtils.autoEpochToTime((long)value);
        }
        return DateTimeUtils.convertDateTime((String)node.asText());
    }
}

