/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.kafka.ingest;

import gnu.trove.map.hash.TObjectIntHashMap;
import io.deephaven.chunk.ChunkType;
import io.deephaven.chunk.ObjectChunk;
import io.deephaven.chunk.WritableChunk;
import io.deephaven.chunk.attributes.Values;
import io.deephaven.engine.table.ColumnDefinition;
import io.deephaven.engine.table.TableDefinition;
import io.deephaven.kafka.ingest.FieldCopier;
import io.deephaven.kafka.ingest.KafkaIngesterException;
import io.deephaven.kafka.ingest.KeyOrValueProcessor;
import java.util.List;
import java.util.Map;
import java.util.function.IntFunction;

public class MultiFieldChunkAdapter
implements KeyOrValueProcessor {
    private final boolean allowNulls;
    private final int[] chunkOffsets;
    private final FieldCopier[] fieldCopiers;

    protected MultiFieldChunkAdapter(TableDefinition definition, IntFunction<ChunkType> chunkTypeForIndex, Map<String, String> fieldNamesToColumnNames, boolean allowNulls, FieldCopier.Factory fieldCopierFactory) {
        this.allowNulls = allowNulls;
        String[] columnNames = definition.getColumnNamesArray();
        List columns = definition.getColumns();
        TObjectIntHashMap deephavenColumnNameToIndex = new TObjectIntHashMap(columnNames.length, 0.5f, -1);
        for (int ii = 0; ii < columnNames.length; ++ii) {
            deephavenColumnNameToIndex.put((Object)columnNames[ii], ii);
        }
        this.chunkOffsets = new int[fieldNamesToColumnNames.size()];
        this.fieldCopiers = new FieldCopier[fieldNamesToColumnNames.size()];
        int col = 0;
        for (Map.Entry<String, String> fieldToColumn : fieldNamesToColumnNames.entrySet()) {
            String columnName = fieldToColumn.getValue();
            int deephavenColumnIndex = deephavenColumnNameToIndex.get((Object)columnName);
            if (deephavenColumnIndex == deephavenColumnNameToIndex.getNoEntryValue()) {
                throw new IllegalArgumentException("Column not found in Deephaven table: " + deephavenColumnIndex);
            }
            this.chunkOffsets[col] = deephavenColumnIndex;
            ColumnDefinition colDef = (ColumnDefinition)columns.get(deephavenColumnIndex);
            this.fieldCopiers[col++] = fieldCopierFactory.make(fieldToColumn.getKey(), chunkTypeForIndex.apply(deephavenColumnIndex), colDef.getDataType(), colDef.getComponentType());
        }
    }

    @Override
    public void handleChunk(ObjectChunk<Object, Values> inputChunk, WritableChunk<Values>[] publisherChunks) {
        if (!this.allowNulls) {
            for (int ii = 0; ii < inputChunk.size(); ++ii) {
                if (inputChunk.get(ii) != null) continue;
                throw new KafkaIngesterException("Null records are not permitted");
            }
        }
        for (int cc = 0; cc < this.chunkOffsets.length; ++cc) {
            WritableChunk<Values> publisherChunk = publisherChunks[this.chunkOffsets[cc]];
            int existingSize = publisherChunk.size();
            publisherChunk.setSize(existingSize + inputChunk.size());
            this.fieldCopiers[cc].copyField(inputChunk, publisherChunk, 0, existingSize, inputChunk.size());
        }
    }
}

