/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.kafka;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.deephaven.api.ColumnName;
import io.deephaven.engine.table.Table;
import io.deephaven.kafka.KafkaPublishOptions;
import io.deephaven.kafka.KafkaTools;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Properties;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="KafkaPublishOptions", generator="Immutables")
@Immutable
final class ImmutableKafkaPublishOptions
extends KafkaPublishOptions {
    private final Table table;
    @Nullable
    private final String topic;
    @Nullable
    private final Integer partition;
    private final Properties config;
    private final KafkaTools.Produce.KeyOrValueSpec keySpec;
    private final KafkaTools.Produce.KeyOrValueSpec valueSpec;
    private final boolean lastBy;
    private final boolean publishInitial;
    @Nullable
    private final ColumnName topicColumn;
    @Nullable
    private final ColumnName partitionColumn;
    @Nullable
    private final ColumnName timestampColumn;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableKafkaPublishOptions(Builder builder) {
        this.table = builder.table;
        this.topic = builder.topic;
        this.partition = builder.partition;
        this.config = builder.config;
        this.topicColumn = builder.topicColumn;
        this.partitionColumn = builder.partitionColumn;
        this.timestampColumn = builder.timestampColumn;
        if (builder.keySpecIsSet()) {
            this.initShim.keySpec(builder.keySpec);
        }
        if (builder.valueSpecIsSet()) {
            this.initShim.valueSpec(builder.valueSpec);
        }
        if (builder.lastByIsSet()) {
            this.initShim.lastBy(builder.lastBy);
        }
        if (builder.publishInitialIsSet()) {
            this.initShim.publishInitial(builder.publishInitial);
        }
        this.keySpec = this.initShim.keySpec();
        this.valueSpec = this.initShim.valueSpec();
        this.lastBy = this.initShim.lastBy();
        this.publishInitial = this.initShim.publishInitial();
        this.initShim = null;
    }

    @Override
    public Table table() {
        return this.table;
    }

    @Override
    @Nullable
    public String topic() {
        return this.topic;
    }

    @Override
    public OptionalInt partition() {
        return this.partition != null ? OptionalInt.of(this.partition) : OptionalInt.empty();
    }

    @Override
    public Properties config() {
        return this.config;
    }

    @Override
    public KafkaTools.Produce.KeyOrValueSpec keySpec() {
        InitShim shim = this.initShim;
        return shim != null ? shim.keySpec() : this.keySpec;
    }

    @Override
    public KafkaTools.Produce.KeyOrValueSpec valueSpec() {
        InitShim shim = this.initShim;
        return shim != null ? shim.valueSpec() : this.valueSpec;
    }

    @Override
    public boolean lastBy() {
        InitShim shim = this.initShim;
        return shim != null ? shim.lastBy() : this.lastBy;
    }

    @Override
    public boolean publishInitial() {
        InitShim shim = this.initShim;
        return shim != null ? shim.publishInitial() : this.publishInitial;
    }

    @Override
    public Optional<ColumnName> topicColumn() {
        return Optional.ofNullable(this.topicColumn);
    }

    @Override
    public Optional<ColumnName> partitionColumn() {
        return Optional.ofNullable(this.partitionColumn);
    }

    @Override
    public Optional<ColumnName> timestampColumn() {
        return Optional.ofNullable(this.timestampColumn);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableKafkaPublishOptions && this.equalTo(0, (ImmutableKafkaPublishOptions)another);
    }

    private boolean equalTo(int synthetic, ImmutableKafkaPublishOptions another) {
        return this.table.equals(another.table) && Objects.equals(this.topic, another.topic) && Objects.equals(this.partition, another.partition) && this.config.equals(another.config) && this.keySpec.equals(another.keySpec) && this.valueSpec.equals(another.valueSpec) && this.lastBy == another.lastBy && this.publishInitial == another.publishInitial && Objects.equals(this.topicColumn, another.topicColumn) && Objects.equals(this.partitionColumn, another.partitionColumn) && Objects.equals(this.timestampColumn, another.timestampColumn);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.getClass().hashCode();
        h += (h << 5) + this.table.hashCode();
        h += (h << 5) + Objects.hashCode(this.topic);
        h += (h << 5) + Objects.hashCode(this.partition);
        h += (h << 5) + this.config.hashCode();
        h += (h << 5) + this.keySpec.hashCode();
        h += (h << 5) + this.valueSpec.hashCode();
        h += (h << 5) + Boolean.hashCode(this.lastBy);
        h += (h << 5) + Boolean.hashCode(this.publishInitial);
        h += (h << 5) + Objects.hashCode(this.topicColumn);
        h += (h << 5) + Objects.hashCode(this.partitionColumn);
        h += (h << 5) + Objects.hashCode(this.timestampColumn);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("KafkaPublishOptions{");
        builder.append("table=").append(this.table);
        if (this.topic != null) {
            builder.append(", ");
            builder.append("topic=").append(this.topic);
        }
        if (this.partition != null) {
            builder.append(", ");
            builder.append("partition=").append(this.partition);
        }
        builder.append(", ");
        builder.append("config=").append(this.config);
        builder.append(", ");
        builder.append("keySpec=").append(this.keySpec);
        builder.append(", ");
        builder.append("valueSpec=").append(this.valueSpec);
        builder.append(", ");
        builder.append("lastBy=").append(this.lastBy);
        builder.append(", ");
        builder.append("publishInitial=").append(this.publishInitial);
        if (this.topicColumn != null) {
            builder.append(", ");
            builder.append("topicColumn=").append(this.topicColumn);
        }
        if (this.partitionColumn != null) {
            builder.append(", ");
            builder.append("partitionColumn=").append(this.partitionColumn);
        }
        if (this.timestampColumn != null) {
            builder.append(", ");
            builder.append("timestampColumn=").append(this.timestampColumn);
        }
        return builder.append("}").toString();
    }

    private static ImmutableKafkaPublishOptions validate(ImmutableKafkaPublishOptions instance) {
        instance.checkTimestampColumn();
        instance.checkPartitionColumn();
        instance.checkTopicColumn();
        instance.checkTopic();
        instance.checkLastBy();
        instance.checkPublishInitial();
        instance.checkNotBothIgnore();
        return instance;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="KafkaPublishOptions", generator="Immutables")
    @NotThreadSafe
    public static final class Builder
    implements KafkaPublishOptions.Builder {
        private static final long INIT_BIT_TABLE = 1L;
        private static final long INIT_BIT_CONFIG = 2L;
        private static final long OPT_BIT_TOPIC = 1L;
        private static final long OPT_BIT_PARTITION = 2L;
        private static final long OPT_BIT_KEY_SPEC = 4L;
        private static final long OPT_BIT_VALUE_SPEC = 8L;
        private static final long OPT_BIT_LAST_BY = 16L;
        private static final long OPT_BIT_PUBLISH_INITIAL = 32L;
        private static final long OPT_BIT_TOPIC_COLUMN = 64L;
        private static final long OPT_BIT_PARTITION_COLUMN = 128L;
        private static final long OPT_BIT_TIMESTAMP_COLUMN = 256L;
        private long initBits = 3L;
        private long optBits;
        @Nullable
        private Table table;
        @Nullable
        private String topic;
        @Nullable
        private Integer partition;
        @Nullable
        private Properties config;
        @Nullable
        private KafkaTools.Produce.KeyOrValueSpec keySpec;
        @Nullable
        private KafkaTools.Produce.KeyOrValueSpec valueSpec;
        private boolean lastBy;
        private boolean publishInitial;
        @Nullable
        private ColumnName topicColumn;
        @Nullable
        private ColumnName partitionColumn;
        @Nullable
        private ColumnName timestampColumn;

        private Builder() {
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder table(Table table) {
            Builder.checkNotIsSet(this.tableIsSet(), "table");
            this.table = Objects.requireNonNull(table, "table");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder topic(@Nullable String topic) {
            Builder.checkNotIsSet(this.topicIsSet(), "topic");
            this.topic = topic;
            this.optBits |= 1L;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder partition(int partition) {
            Builder.checkNotIsSet(this.partitionIsSet(), "partition");
            this.partition = partition;
            this.optBits |= 2L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder partition(OptionalInt partition) {
            Builder.checkNotIsSet(this.partitionIsSet(), "partition");
            this.partition = partition.isPresent() ? Integer.valueOf(partition.getAsInt()) : null;
            this.optBits |= 2L;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder config(Properties config) {
            Builder.checkNotIsSet(this.configIsSet(), "config");
            this.config = Objects.requireNonNull(config, "config");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder keySpec(KafkaTools.Produce.KeyOrValueSpec keySpec) {
            Builder.checkNotIsSet(this.keySpecIsSet(), "keySpec");
            this.keySpec = Objects.requireNonNull(keySpec, "keySpec");
            this.optBits |= 4L;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder valueSpec(KafkaTools.Produce.KeyOrValueSpec valueSpec) {
            Builder.checkNotIsSet(this.valueSpecIsSet(), "valueSpec");
            this.valueSpec = Objects.requireNonNull(valueSpec, "valueSpec");
            this.optBits |= 8L;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder lastBy(boolean lastBy) {
            Builder.checkNotIsSet(this.lastByIsSet(), "lastBy");
            this.lastBy = lastBy;
            this.optBits |= 0x10L;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder publishInitial(boolean publishInitial) {
            Builder.checkNotIsSet(this.publishInitialIsSet(), "publishInitial");
            this.publishInitial = publishInitial;
            this.optBits |= 0x20L;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder topicColumn(ColumnName topicColumn) {
            Builder.checkNotIsSet(this.topicColumnIsSet(), "topicColumn");
            this.topicColumn = Objects.requireNonNull(topicColumn, "topicColumn");
            this.optBits |= 0x40L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder topicColumn(Optional<? extends ColumnName> topicColumn) {
            Builder.checkNotIsSet(this.topicColumnIsSet(), "topicColumn");
            this.topicColumn = topicColumn.orElse(null);
            this.optBits |= 0x40L;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder partitionColumn(ColumnName partitionColumn) {
            Builder.checkNotIsSet(this.partitionColumnIsSet(), "partitionColumn");
            this.partitionColumn = Objects.requireNonNull(partitionColumn, "partitionColumn");
            this.optBits |= 0x80L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder partitionColumn(Optional<? extends ColumnName> partitionColumn) {
            Builder.checkNotIsSet(this.partitionColumnIsSet(), "partitionColumn");
            this.partitionColumn = partitionColumn.orElse(null);
            this.optBits |= 0x80L;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder timestampColumn(ColumnName timestampColumn) {
            Builder.checkNotIsSet(this.timestampColumnIsSet(), "timestampColumn");
            this.timestampColumn = Objects.requireNonNull(timestampColumn, "timestampColumn");
            this.optBits |= 0x100L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder timestampColumn(Optional<? extends ColumnName> timestampColumn) {
            Builder.checkNotIsSet(this.timestampColumnIsSet(), "timestampColumn");
            this.timestampColumn = timestampColumn.orElse(null);
            this.optBits |= 0x100L;
            return this;
        }

        @Override
        public ImmutableKafkaPublishOptions build() {
            this.checkRequiredAttributes();
            return ImmutableKafkaPublishOptions.validate(new ImmutableKafkaPublishOptions(this));
        }

        private boolean topicIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean partitionIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean keySpecIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean valueSpecIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private boolean lastByIsSet() {
            return (this.optBits & 0x10L) != 0L;
        }

        private boolean publishInitialIsSet() {
            return (this.optBits & 0x20L) != 0L;
        }

        private boolean topicColumnIsSet() {
            return (this.optBits & 0x40L) != 0L;
        }

        private boolean partitionColumnIsSet() {
            return (this.optBits & 0x80L) != 0L;
        }

        private boolean timestampColumnIsSet() {
            return (this.optBits & 0x100L) != 0L;
        }

        private boolean tableIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean configIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private static void checkNotIsSet(boolean isSet, String name) {
            if (isSet) {
                throw new IllegalStateException("Builder of KafkaPublishOptions is strict, attribute is already set: ".concat(name));
            }
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.tableIsSet()) {
                attributes.add("table");
            }
            if (!this.configIsSet()) {
                attributes.add("config");
            }
            return "Cannot build KafkaPublishOptions, some of required attributes are not set " + attributes;
        }
    }

    @Generated(from="KafkaPublishOptions", generator="Immutables")
    private final class InitShim {
        private byte keySpecBuildStage = 0;
        private KafkaTools.Produce.KeyOrValueSpec keySpec;
        private byte valueSpecBuildStage = 0;
        private KafkaTools.Produce.KeyOrValueSpec valueSpec;
        private byte lastByBuildStage = 0;
        private boolean lastBy;
        private byte publishInitialBuildStage = 0;
        private boolean publishInitial;

        private InitShim() {
        }

        KafkaTools.Produce.KeyOrValueSpec keySpec() {
            if (this.keySpecBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.keySpecBuildStage == 0) {
                this.keySpecBuildStage = (byte)-1;
                this.keySpec = Objects.requireNonNull(ImmutableKafkaPublishOptions.super.keySpec(), "keySpec");
                this.keySpecBuildStage = 1;
            }
            return this.keySpec;
        }

        void keySpec(KafkaTools.Produce.KeyOrValueSpec keySpec) {
            this.keySpec = keySpec;
            this.keySpecBuildStage = 1;
        }

        KafkaTools.Produce.KeyOrValueSpec valueSpec() {
            if (this.valueSpecBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.valueSpecBuildStage == 0) {
                this.valueSpecBuildStage = (byte)-1;
                this.valueSpec = Objects.requireNonNull(ImmutableKafkaPublishOptions.super.valueSpec(), "valueSpec");
                this.valueSpecBuildStage = 1;
            }
            return this.valueSpec;
        }

        void valueSpec(KafkaTools.Produce.KeyOrValueSpec valueSpec) {
            this.valueSpec = valueSpec;
            this.valueSpecBuildStage = 1;
        }

        boolean lastBy() {
            if (this.lastByBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.lastByBuildStage == 0) {
                this.lastByBuildStage = (byte)-1;
                this.lastBy = ImmutableKafkaPublishOptions.super.lastBy();
                this.lastByBuildStage = 1;
            }
            return this.lastBy;
        }

        void lastBy(boolean lastBy) {
            this.lastBy = lastBy;
            this.lastByBuildStage = 1;
        }

        boolean publishInitial() {
            if (this.publishInitialBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.publishInitialBuildStage == 0) {
                this.publishInitialBuildStage = (byte)-1;
                this.publishInitial = ImmutableKafkaPublishOptions.super.publishInitial();
                this.publishInitialBuildStage = 1;
            }
            return this.publishInitial;
        }

        void publishInitial(boolean publishInitial) {
            this.publishInitial = publishInitial;
            this.publishInitialBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.keySpecBuildStage == -1) {
                attributes.add("keySpec");
            }
            if (this.valueSpecBuildStage == -1) {
                attributes.add("valueSpec");
            }
            if (this.lastByBuildStage == -1) {
                attributes.add("lastBy");
            }
            if (this.publishInitialBuildStage == -1) {
                attributes.add("publishInitial");
            }
            return "Cannot build KafkaPublishOptions, attribute initializers form cycle " + attributes;
        }
    }
}

