/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.kafka;

import io.deephaven.annotations.BuildableStyle;
import io.deephaven.api.ColumnName;
import io.deephaven.engine.table.Table;
import io.deephaven.kafka.ImmutableKafkaPublishOptions;
import io.deephaven.kafka.KafkaTools;
import java.time.Instant;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Properties;
import javax.annotation.Nullable;
import org.immutables.value.Value;

@Value.Immutable
@BuildableStyle
public abstract class KafkaPublishOptions {
    public static Builder builder() {
        return ImmutableKafkaPublishOptions.builder();
    }

    public abstract Table table();

    @Nullable
    public abstract String topic();

    public abstract OptionalInt partition();

    public abstract Properties config();

    @Value.Default
    public KafkaTools.Produce.KeyOrValueSpec keySpec() {
        return KafkaTools.Produce.ignoreSpec();
    }

    @Value.Default
    public KafkaTools.Produce.KeyOrValueSpec valueSpec() {
        return KafkaTools.Produce.ignoreSpec();
    }

    @Value.Default
    public boolean lastBy() {
        return false;
    }

    @Value.Default
    public boolean publishInitial() {
        return true;
    }

    public abstract Optional<ColumnName> topicColumn();

    public abstract Optional<ColumnName> partitionColumn();

    public abstract Optional<ColumnName> timestampColumn();

    @Value.Check
    final void checkNotBothIgnore() {
        if (KafkaTools.Produce.isIgnore(this.keySpec()) && KafkaTools.Produce.isIgnore(this.valueSpec())) {
            throw new IllegalArgumentException("keySpec and valueSpec can't both be ignore specs");
        }
    }

    @Value.Check
    final void checkPublishInitial() {
        if (!this.publishInitial() && !this.table().isRefreshing()) {
            throw new IllegalArgumentException("publishInitial==false && table.isRefreshing() == false");
        }
    }

    @Value.Check
    final void checkLastBy() {
        if (this.lastBy() && KafkaTools.Produce.isIgnore(this.keySpec())) {
            throw new IllegalArgumentException("Must set a non-ignore keySpec when lastBy() == true");
        }
    }

    @Value.Check
    final void checkTopic() {
        if (this.topic() == null && this.topicColumn().isEmpty()) {
            throw new IllegalArgumentException("Must set topic or topicColumn (or both)");
        }
    }

    @Value.Check
    final void checkTopicColumn() {
        if (this.topicColumn().isPresent()) {
            this.table().getDefinition().checkHasColumn(this.topicColumn().get().name(), CharSequence.class);
        }
    }

    @Value.Check
    final void checkPartitionColumn() {
        if (this.partitionColumn().isPresent()) {
            this.table().getDefinition().checkHasColumn(this.partitionColumn().get().name(), Integer.TYPE);
        }
    }

    @Value.Check
    final void checkTimestampColumn() {
        if (this.timestampColumn().isPresent()) {
            this.table().getDefinition().checkHasColumn(this.timestampColumn().get().name(), Instant.class);
        }
    }

    public static interface Builder {
        public Builder table(Table var1);

        public Builder topic(String var1);

        public Builder partition(int var1);

        public Builder config(Properties var1);

        public Builder keySpec(KafkaTools.Produce.KeyOrValueSpec var1);

        public Builder valueSpec(KafkaTools.Produce.KeyOrValueSpec var1);

        public Builder lastBy(boolean var1);

        public Builder publishInitial(boolean var1);

        public Builder topicColumn(ColumnName var1);

        public Builder partitionColumn(ColumnName var1);

        public Builder timestampColumn(ColumnName var1);

        public KafkaPublishOptions build();
    }
}

