/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.kafka;

import com.google.protobuf.Descriptors;
import com.google.protobuf.DynamicMessage;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.Parser;
import io.deephaven.kafka.protobuf.Protocol;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.utils.ByteUtils;

class ProtobufDeserializers {
    ProtobufDeserializers() {
    }

    static <T extends Message> Deserializer<T> of(Protocol protocol, Parser<T> parser) {
        if (protocol == Protocol.serdes()) {
            return new Serdes<T>(ParseFrom.of(parser));
        }
        if (protocol == Protocol.raw()) {
            return new Raw<T>(ParseFrom.of(parser));
        }
        throw new IllegalStateException("Unexpected protocol: " + protocol);
    }

    static Deserializer<DynamicMessage> of(Protocol protocol, Descriptors.Descriptor descriptor) {
        if (protocol == Protocol.serdes()) {
            return new Serdes<DynamicMessage>(ParseFrom.of(descriptor));
        }
        if (protocol == Protocol.raw()) {
            return new Raw<DynamicMessage>(ParseFrom.of(descriptor));
        }
        throw new IllegalStateException("Unexpected protocol: " + protocol);
    }

    private static final class Serdes<T extends Message>
    implements Deserializer<T> {
        private static final byte MAGIC_BYTE = 0;
        private static final int MAGIC_SIZE = 1;
        private static final int SCHEMA_ID_SIZE = 4;
        private static final int MESSAGE_IX_MIN_SIZE = 1;
        private static final int MESSAGE_IX_OFFSET = 5;
        private static final int SERDES_MIN_SIZE = 6;
        private final ParseFrom<T> parser;

        Serdes(ParseFrom<T> parser) {
            this.parser = Objects.requireNonNull(parser);
        }

        public T deserialize(String topic, byte[] data) {
            if (data == null) {
                return null;
            }
            if (data.length < 6) {
                throw new SerializationException(String.format("Not serdes protocol, expected at least %d bytes", 6));
            }
            if (data[0] != 0) {
                throw new SerializationException("Not serdes protocol, magic byte is incorrect");
            }
            int protobufOffset = Serdes.protobufOffset(data);
            try {
                return this.parser.parseFrom(data, protobufOffset, data.length - protobufOffset);
            }
            catch (InvalidProtocolBufferException e) {
                throw new SerializationException((Throwable)e);
            }
        }

        private static int protobufOffset(byte[] data) {
            ByteBuffer bb = ByteBuffer.wrap(data, 5, data.length - 5);
            int numMessageIxs = ByteUtils.readVarint((ByteBuffer)bb);
            for (int i = 0; i < numMessageIxs; ++i) {
                ByteUtils.readVarint((ByteBuffer)bb);
            }
            return bb.position();
        }
    }

    private static final class Raw<T extends Message>
    implements Deserializer<T> {
        private final ParseFrom<T> parser;

        Raw(ParseFrom<T> parser) {
            this.parser = Objects.requireNonNull(parser);
        }

        public T deserialize(String topic, byte[] data) {
            if (data == null) {
                return null;
            }
            try {
                return this.parser.parseFrom(data, 0, data.length);
            }
            catch (InvalidProtocolBufferException e) {
                throw new SerializationException((Throwable)e);
            }
        }
    }

    private static interface ParseFrom<T extends Message> {
        public static <T extends Message> ParseFrom<T> of(Parser<T> parser) {
            return (arg_0, arg_1, arg_2) -> parser.parseFrom(arg_0, arg_1, arg_2);
        }

        public static ParseFrom<DynamicMessage> of(Descriptors.Descriptor descriptor) {
            return (data, offset, len) -> ((DynamicMessage.Builder)DynamicMessage.newBuilder((Descriptors.Descriptor)descriptor).mergeFrom(data, offset, len)).build();
        }

        public T parseFrom(byte[] var1, int var2, int var3) throws InvalidProtocolBufferException;
    }
}

