/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.kafka;

import io.confluent.kafka.schemaregistry.SchemaProvider;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.deephaven.UncheckedDeephavenException;
import io.deephaven.engine.table.ColumnDefinition;
import io.deephaven.engine.table.Table;
import io.deephaven.engine.table.TableDefinition;
import io.deephaven.kafka.KafkaTools;
import io.deephaven.kafka.ingest.KeyOrValueProcessor;
import io.deephaven.kafka.publish.KeyOrValueSerializer;
import io.deephaven.kafka.publish.SimpleKeyOrValueSerializer;
import io.deephaven.util.mutable.MutableInt;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serializer;
import org.jetbrains.annotations.NotNull;

class RawImpl {
    RawImpl() {
    }

    static final class RawProduce
    extends KafkaTools.Produce.KeyOrValueSpec {
        private final String columnName;
        private final Supplier<Serializer<?>> supplier;

        public RawProduce(String columnName, Class<? extends Serializer<?>> serializer) {
            this(columnName, () -> {
                try {
                    return (Serializer)serializer.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                    throw new UncheckedDeephavenException((Throwable)e);
                }
            });
        }

        public RawProduce(String columnName, Supplier<Serializer<?>> supplier) {
            this.columnName = Objects.requireNonNull(columnName);
            this.supplier = Objects.requireNonNull(supplier);
        }

        @Override
        public Optional<SchemaProvider> getSchemaProvider() {
            return Optional.empty();
        }

        @Override
        Serializer<?> getSerializer(SchemaRegistryClient schemaRegistryClient, TableDefinition definition) {
            return this.supplier.get();
        }

        @Override
        String[] getColumnNames(@NotNull Table t, SchemaRegistryClient schemaRegistryClient) {
            return new String[]{this.columnName};
        }

        @Override
        KeyOrValueSerializer<?> getKeyOrValueSerializer(@NotNull Table t, @NotNull String[] columnNames) {
            return new SimpleKeyOrValueSerializer(t, this.columnName);
        }
    }

    static final class RawConsume
    extends KafkaTools.Consume.KeyOrValueSpec {
        private final ColumnDefinition<?> cd;
        private final Supplier<Deserializer<?>> supplier;

        public RawConsume(ColumnDefinition<?> cd, Class<? extends Deserializer<?>> deserializerClass) {
            this(cd, () -> {
                try {
                    return (Deserializer)deserializerClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                    throw new UncheckedDeephavenException((Throwable)e);
                }
            });
        }

        public RawConsume(ColumnDefinition<?> cd, Supplier<Deserializer<?>> supplier) {
            this.cd = Objects.requireNonNull(cd);
            this.supplier = Objects.requireNonNull(supplier);
        }

        @Override
        public Optional<SchemaProvider> getSchemaProvider() {
            return Optional.empty();
        }

        @Override
        protected Deserializer<?> getDeserializer(KafkaTools.KeyOrValue keyOrValue, SchemaRegistryClient schemaRegistryClient, Map<String, ?> configs) {
            return this.supplier.get();
        }

        @Override
        protected KafkaTools.KeyOrValueIngestData getIngestData(KafkaTools.KeyOrValue keyOrValue, SchemaRegistryClient schemaRegistryClient, Map<String, ?> configs, MutableInt nextColumnIndexMut, List<ColumnDefinition<?>> columnDefinitionsOut) {
            KafkaTools.KeyOrValueIngestData data = new KafkaTools.KeyOrValueIngestData();
            data.simpleColumnIndex = nextColumnIndexMut.getAndIncrement();
            columnDefinitionsOut.add(this.cd);
            return data;
        }

        @Override
        protected KeyOrValueProcessor getProcessor(TableDefinition tableDef, KafkaTools.KeyOrValueIngestData data) {
            return null;
        }
    }
}

