/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.kafka;

import io.deephaven.function.ToByteFunction;
import io.deephaven.function.ToLongFunction;
import io.deephaven.function.ToObjectFunction;
import io.deephaven.function.ToPrimitiveFunction;
import io.deephaven.function.TypedFunction;
import io.deephaven.kafka.UnboxTransform;
import io.deephaven.qst.type.ArrayType;
import io.deephaven.qst.type.BoxedBooleanType;
import io.deephaven.qst.type.BoxedByteType;
import io.deephaven.qst.type.BoxedCharType;
import io.deephaven.qst.type.BoxedDoubleType;
import io.deephaven.qst.type.BoxedFloatType;
import io.deephaven.qst.type.BoxedIntType;
import io.deephaven.qst.type.BoxedLongType;
import io.deephaven.qst.type.BoxedShortType;
import io.deephaven.qst.type.BoxedType;
import io.deephaven.qst.type.CustomType;
import io.deephaven.qst.type.GenericType;
import io.deephaven.qst.type.InstantType;
import io.deephaven.qst.type.StringType;
import io.deephaven.time.DateTimeUtils;
import io.deephaven.util.BooleanUtils;
import java.time.Instant;
import java.util.Objects;

class ToChunkTypeTransform {
    private static final ToByteFunction<Boolean> BOOLEAN_AS_BYTE = BooleanUtils::booleanAsByte;
    private static final ToLongFunction<Instant> EPOCH_NANOS = DateTimeUtils::epochNanos;

    ToChunkTypeTransform() {
    }

    public static <T> TypedFunction<T> of(TypedFunction<T> f) {
        return FunctionVisitor.of(f);
    }

    public static <T> TypedFunction<T> of(ToPrimitiveFunction<T> f) {
        return f;
    }

    public static <T> TypedFunction<T> of(ToObjectFunction<T, ?> f) {
        return ObjectFunctionVisitor.of(f);
    }

    public static <T> ToByteFunction<T> unboxBooleanAsByte(ToObjectFunction<T, Boolean> f) {
        return f.mapToByte(BOOLEAN_AS_BYTE);
    }

    public static <T> ToLongFunction<T> toEpochNanos(ToObjectFunction<T, Instant> f) {
        return f.mapToLong(EPOCH_NANOS);
    }

    private static class ObjectFunctionVisitor<T>
    implements GenericType.Visitor<TypedFunction<T>>,
    BoxedType.Visitor<TypedFunction<T>> {
        private final ToObjectFunction<T, ?> f;

        public static <T> TypedFunction<T> of(ToObjectFunction<T, ?> f) {
            return (TypedFunction)f.returnType().walk(new ObjectFunctionVisitor<T>(f));
        }

        private ObjectFunctionVisitor(ToObjectFunction<T, ?> f) {
            this.f = Objects.requireNonNull(f);
        }

        public TypedFunction<T> visit(BoxedType<?> boxedType) {
            return (TypedFunction)boxedType.walk((BoxedType.Visitor)this);
        }

        public TypedFunction<T> visit(InstantType instantType) {
            return ToChunkTypeTransform.toEpochNanos(this.f.cast((GenericType)instantType));
        }

        public TypedFunction<T> visit(StringType stringType) {
            return this.f;
        }

        public TypedFunction<T> visit(ArrayType<?, ?> arrayType) {
            return this.f;
        }

        public TypedFunction<T> visit(CustomType<?> customType) {
            return this.f;
        }

        public TypedFunction<T> visit(BoxedBooleanType booleanType) {
            return ToChunkTypeTransform.unboxBooleanAsByte(this.f.cast((GenericType)booleanType));
        }

        public TypedFunction<T> visit(BoxedByteType byteType) {
            return UnboxTransform.unboxByte(this.f.cast((GenericType)byteType));
        }

        public TypedFunction<T> visit(BoxedCharType charType) {
            return UnboxTransform.unboxChar(this.f.cast((GenericType)charType));
        }

        public TypedFunction<T> visit(BoxedShortType shortType) {
            return UnboxTransform.unboxShort(this.f.cast((GenericType)shortType));
        }

        public TypedFunction<T> visit(BoxedIntType intType) {
            return UnboxTransform.unboxInt(this.f.cast((GenericType)intType));
        }

        public TypedFunction<T> visit(BoxedLongType longType) {
            return UnboxTransform.unboxLong(this.f.cast((GenericType)longType));
        }

        public TypedFunction<T> visit(BoxedFloatType floatType) {
            return UnboxTransform.unboxFloat(this.f.cast((GenericType)floatType));
        }

        public TypedFunction<T> visit(BoxedDoubleType doubleType) {
            return UnboxTransform.unboxDouble(this.f.cast((GenericType)doubleType));
        }
    }

    private static class FunctionVisitor<T>
    implements TypedFunction.Visitor<T, TypedFunction<T>> {
        public static <T> TypedFunction<T> of(TypedFunction<T> f) {
            return (TypedFunction)f.walk(new FunctionVisitor<T>());
        }

        private FunctionVisitor() {
        }

        public TypedFunction<T> visit(ToPrimitiveFunction<T> f) {
            return ToChunkTypeTransform.of(f);
        }

        public TypedFunction<T> visit(ToObjectFunction<T, ?> f) {
            return ToChunkTypeTransform.of(f);
        }
    }
}

