/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.kafka;

import io.deephaven.function.ToByteFunction;
import io.deephaven.function.ToCharFunction;
import io.deephaven.function.ToDoubleFunction;
import io.deephaven.function.ToFloatFunction;
import io.deephaven.function.ToIntFunction;
import io.deephaven.function.ToLongFunction;
import io.deephaven.function.ToObjectFunction;
import io.deephaven.function.ToPrimitiveFunction;
import io.deephaven.function.ToShortFunction;
import io.deephaven.function.TypedFunction;
import io.deephaven.qst.type.ArrayType;
import io.deephaven.qst.type.BoxedBooleanType;
import io.deephaven.qst.type.BoxedByteType;
import io.deephaven.qst.type.BoxedCharType;
import io.deephaven.qst.type.BoxedDoubleType;
import io.deephaven.qst.type.BoxedFloatType;
import io.deephaven.qst.type.BoxedIntType;
import io.deephaven.qst.type.BoxedLongType;
import io.deephaven.qst.type.BoxedShortType;
import io.deephaven.qst.type.BoxedType;
import io.deephaven.qst.type.CustomType;
import io.deephaven.qst.type.GenericType;
import io.deephaven.qst.type.InstantType;
import io.deephaven.qst.type.StringType;
import io.deephaven.util.type.TypeUtils;
import java.util.Objects;
import java.util.Optional;

class UnboxTransform {
    private static final ToByteFunction<Byte> UNBOX_BYTE = TypeUtils::unbox;
    private static final ToCharFunction<Character> UNBOX_CHAR = TypeUtils::unbox;
    private static final ToShortFunction<Short> UNBOX_SHORT = TypeUtils::unbox;
    private static final ToIntFunction<Integer> UNBOX_INT = TypeUtils::unbox;
    private static final ToLongFunction<Long> UNBOX_LONG = TypeUtils::unbox;
    private static final ToFloatFunction<Float> UNBOX_FLOAT = TypeUtils::unbox;
    private static final ToDoubleFunction<Double> UNBOX_DOULE = TypeUtils::unbox;

    UnboxTransform() {
    }

    public static <T> Optional<ToPrimitiveFunction<T>> of(TypedFunction<T> f) {
        return UnboxFunctionVisitor.of(f);
    }

    public static <T> Optional<ToPrimitiveFunction<T>> of(ToObjectFunction<T, ?> f) {
        return UnboxObjectFunctionVisitor.of(f);
    }

    public static <T> ToByteFunction<T> unboxByte(ToObjectFunction<T, Byte> f) {
        return f.mapToByte(UNBOX_BYTE);
    }

    public static <T> ToCharFunction<T> unboxChar(ToObjectFunction<T, Character> f) {
        return f.mapToChar(UNBOX_CHAR);
    }

    public static <T> ToShortFunction<T> unboxShort(ToObjectFunction<T, Short> f) {
        return f.mapToShort(UNBOX_SHORT);
    }

    public static <T> ToIntFunction<T> unboxInt(ToObjectFunction<T, Integer> f) {
        return f.mapToInt(UNBOX_INT);
    }

    public static <T> ToLongFunction<T> unboxLong(ToObjectFunction<T, Long> f) {
        return f.mapToLong(UNBOX_LONG);
    }

    public static <T> ToFloatFunction<T> unboxFloat(ToObjectFunction<T, Float> f) {
        return f.mapToFloat(UNBOX_FLOAT);
    }

    public static <T> ToDoubleFunction<T> unboxDouble(ToObjectFunction<T, Double> f) {
        return f.mapToDouble(UNBOX_DOULE);
    }

    private static class UnboxObjectFunctionVisitor<T>
    implements GenericType.Visitor<ToPrimitiveFunction<T>>,
    BoxedType.Visitor<ToPrimitiveFunction<T>> {
        private final ToObjectFunction<T, ?> f;

        public static <T> Optional<ToPrimitiveFunction<T>> of(ToObjectFunction<T, ?> f) {
            return Optional.ofNullable((ToPrimitiveFunction)f.returnType().walk(new UnboxObjectFunctionVisitor<T>(f)));
        }

        public UnboxObjectFunctionVisitor(ToObjectFunction<T, ?> f) {
            this.f = Objects.requireNonNull(f);
        }

        public ToPrimitiveFunction<T> visit(BoxedType<?> boxedType) {
            return (ToPrimitiveFunction)boxedType.walk((BoxedType.Visitor)this);
        }

        public ToPrimitiveFunction<T> visit(StringType stringType) {
            return null;
        }

        public ToPrimitiveFunction<T> visit(InstantType instantType) {
            return null;
        }

        public ToPrimitiveFunction<T> visit(ArrayType<?, ?> arrayType) {
            return null;
        }

        public ToPrimitiveFunction<T> visit(CustomType<?> customType) {
            return null;
        }

        public ToPrimitiveFunction<T> visit(BoxedBooleanType booleanType) {
            return null;
        }

        public ToPrimitiveFunction<T> visit(BoxedByteType byteType) {
            return UnboxTransform.unboxByte(this.f.cast((GenericType)byteType));
        }

        public ToPrimitiveFunction<T> visit(BoxedCharType charType) {
            return UnboxTransform.unboxChar(this.f.cast((GenericType)charType));
        }

        public ToPrimitiveFunction<T> visit(BoxedShortType shortType) {
            return UnboxTransform.unboxShort(this.f.cast((GenericType)shortType));
        }

        public ToPrimitiveFunction<T> visit(BoxedIntType intType) {
            return UnboxTransform.unboxInt(this.f.cast((GenericType)intType));
        }

        public ToPrimitiveFunction<T> visit(BoxedLongType longType) {
            return UnboxTransform.unboxLong(this.f.cast((GenericType)longType));
        }

        public ToPrimitiveFunction<T> visit(BoxedFloatType floatType) {
            return UnboxTransform.unboxFloat(this.f.cast((GenericType)floatType));
        }

        public ToPrimitiveFunction<T> visit(BoxedDoubleType doubleType) {
            return UnboxTransform.unboxDouble(this.f.cast((GenericType)doubleType));
        }
    }

    private static enum UnboxFunctionVisitor implements TypedFunction.Visitor<Object, ToPrimitiveFunction<Object>>
    {
        INSTANCE;


        public static <T> Optional<ToPrimitiveFunction<T>> of(TypedFunction<T> f) {
            return Optional.ofNullable((ToPrimitiveFunction)f.walk((TypedFunction.Visitor)INSTANCE));
        }

        public ToPrimitiveFunction<Object> visit(ToPrimitiveFunction<Object> f) {
            return f;
        }

        public ToPrimitiveFunction<Object> visit(ToObjectFunction<Object, ?> f) {
            return UnboxTransform.of(f).orElse(null);
        }
    }
}

