/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.kafka.ingest;

import io.deephaven.chunk.ObjectChunk;
import io.deephaven.chunk.WritableChunk;
import io.deephaven.chunk.attributes.Values;
import io.deephaven.kafka.ingest.FieldCopier;
import io.deephaven.processor.ObjectProcessor;
import java.util.List;
import java.util.Objects;

final class FieldCopierProcessorImpl
implements FieldCopier {
    private final ObjectProcessor<Object> processor;

    FieldCopierProcessorImpl(ObjectProcessor<Object> processor) {
        this.processor = Objects.requireNonNull(processor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void copyField(ObjectChunk<Object, Values> inputChunk, WritableChunk<Values> publisherChunk, int sourceOffset, int destOffset, int length) {
        int originalSize = publisherChunk.size();
        publisherChunk.setSize(destOffset);
        try {
            this.processor.processAll(inputChunk.slice(sourceOffset, length), List.of(publisherChunk));
        }
        finally {
            publisherChunk.setSize(originalSize);
        }
    }
}

