/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.kafka.ingest;

import io.deephaven.chunk.ObjectChunk;
import io.deephaven.chunk.WritableChunk;
import io.deephaven.chunk.WritableObjectChunk;
import io.deephaven.chunk.attributes.Values;
import io.deephaven.kafka.ingest.GenericRecordFieldCopier;
import io.deephaven.kafka.ingest.GenericRecordUtil;
import io.deephaven.util.type.ArrayTypeUtils;
import java.lang.reflect.Array;
import java.util.regex.Pattern;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericArray;
import org.apache.avro.generic.GenericRecord;

public class GenericRecordArrayFieldCopier
extends GenericRecordFieldCopier {
    private final ArrayConverter arrayConverter;

    public GenericRecordArrayFieldCopier(String fieldPathStr, Pattern separator, Schema schema, Class<?> componentType) {
        super(fieldPathStr, separator, schema);
        this.arrayConverter = ArrayConverter.makeFor(componentType);
    }

    private static <T> T[] convertObjectArray(GenericArray<?> ga, T[] emptyArray, Class<T> componentType) {
        int gaSize = ga.size();
        if (gaSize == 0) {
            return emptyArray;
        }
        Object[] out = (Object[])Array.newInstance(componentType, ga.size());
        int i = 0;
        for (Object o : ga) {
            out[i] = componentType.cast(o);
            ++i;
        }
        return out;
    }

    @Override
    public void copyField(ObjectChunk<Object, Values> inputChunk, WritableChunk<Values> publisherChunk, int sourceOffset, int destOffset, int length) {
        WritableObjectChunk output = publisherChunk.asWritableObjectChunk();
        for (int ii = 0; ii < length; ++ii) {
            GenericRecord record = (GenericRecord)inputChunk.get(ii + sourceOffset);
            GenericArray genericArray = (GenericArray)GenericRecordUtil.getPath(record, this.fieldPath);
            if (genericArray == null) {
                output.set(ii + destOffset, null);
                continue;
            }
            output.set(ii + destOffset, this.arrayConverter.convert(genericArray));
        }
    }

    private static interface ArrayConverter {
        public Object convert(GenericArray<?> var1);

        public static ArrayConverter makeFor(Class<?> componentType) {
            if (componentType.equals(Byte.TYPE)) {
                return ga -> {
                    int gaSize = ga.size();
                    if (gaSize == 0) {
                        return ArrayTypeUtils.EMPTY_BYTE_ARRAY;
                    }
                    byte[] out = new byte[gaSize];
                    int i = 0;
                    for (Object o : ga) {
                        out[i] = o == null ? -128 : (int)((Byte)o).byteValue();
                        ++i;
                    }
                    return out;
                };
            }
            if (componentType.equals(Integer.TYPE)) {
                return ga -> {
                    int gaSize = ga.size();
                    if (gaSize == 0) {
                        return ArrayTypeUtils.EMPTY_INT_ARRAY;
                    }
                    int[] out = new int[gaSize];
                    int i = 0;
                    for (Object o : ga) {
                        out[i] = o == null ? Integer.MIN_VALUE : (Integer)o;
                        ++i;
                    }
                    return out;
                };
            }
            if (componentType.equals(Long.TYPE)) {
                return ga -> {
                    int gaSize = ga.size();
                    if (gaSize == 0) {
                        return ArrayTypeUtils.EMPTY_LONG_ARRAY;
                    }
                    long[] out = new long[gaSize];
                    int i = 0;
                    for (Object o : ga) {
                        out[i] = o == null ? Long.MIN_VALUE : (Long)o;
                        ++i;
                    }
                    return out;
                };
            }
            if (componentType.equals(Float.TYPE)) {
                return ga -> {
                    int gaSize = ga.size();
                    if (gaSize == 0) {
                        return ArrayTypeUtils.EMPTY_FLOAT_ARRAY;
                    }
                    float[] out = new float[gaSize];
                    int i = 0;
                    for (Object o : ga) {
                        out[i] = o == null ? -3.4028235E38f : ((Float)o).floatValue();
                        ++i;
                    }
                    return out;
                };
            }
            if (componentType.equals(Double.TYPE)) {
                return ga -> {
                    int gaSize = ga.size();
                    if (gaSize == 0) {
                        return ArrayTypeUtils.EMPTY_DOUBLE_ARRAY;
                    }
                    double[] out = new double[gaSize];
                    int i = 0;
                    for (Object o : ga) {
                        out[i] = o == null ? -1.7976931348623157E308 : (Double)o;
                        ++i;
                    }
                    return out;
                };
            }
            if (componentType.equals(Boolean.TYPE)) {
                return ga -> GenericRecordArrayFieldCopier.convertObjectArray(ga, ArrayTypeUtils.EMPTY_BOOLEANBOXED_ARRAY, Boolean.TYPE);
            }
            if (componentType.equals(String.class)) {
                return ga -> GenericRecordArrayFieldCopier.convertObjectArray(ga, ArrayTypeUtils.EMPTY_STRING_ARRAY, String.class);
            }
            return ga -> GenericRecordArrayFieldCopier.convertObjectArray(ga, ArrayTypeUtils.EMPTY_OBJECT_ARRAY, Object.class);
        }
    }
}

