/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.kafka.ingest;

import com.fasterxml.jackson.databind.JsonNode;
import io.deephaven.UncheckedDeephavenException;
import io.deephaven.chunk.ChunkType;
import io.deephaven.engine.table.TableDefinition;
import io.deephaven.kafka.ingest.FieldCopier;
import io.deephaven.kafka.ingest.JsonNodeBooleanFieldCopier;
import io.deephaven.kafka.ingest.JsonNodeByteFieldCopier;
import io.deephaven.kafka.ingest.JsonNodeCharFieldCopier;
import io.deephaven.kafka.ingest.JsonNodeDoubleFieldCopier;
import io.deephaven.kafka.ingest.JsonNodeFloatFieldCopier;
import io.deephaven.kafka.ingest.JsonNodeInstantFieldCopier;
import io.deephaven.kafka.ingest.JsonNodeIntFieldCopier;
import io.deephaven.kafka.ingest.JsonNodeJsonNodeFieldCopier;
import io.deephaven.kafka.ingest.JsonNodeLongFieldCopier;
import io.deephaven.kafka.ingest.JsonNodeShortFieldCopier;
import io.deephaven.kafka.ingest.JsonNodeStringFieldCopier;
import io.deephaven.kafka.ingest.MultiFieldChunkAdapter;
import java.time.Instant;
import java.util.Map;
import java.util.function.IntFunction;

public class JsonNodeChunkAdapter
extends MultiFieldChunkAdapter {
    private JsonNodeChunkAdapter(TableDefinition definition, IntFunction<ChunkType> chunkTypeForIndex, Map<String, String> jsonPointerStrToColumnNames, boolean allowNulls) {
        super(definition, chunkTypeForIndex, jsonPointerStrToColumnNames, allowNulls, JsonNodeChunkAdapter::makeFieldCopier);
    }

    public static JsonNodeChunkAdapter make(TableDefinition definition, IntFunction<ChunkType> chunkTypeForIndex, Map<String, String> jsonPointerStrToColumnNames, boolean allowNulls) {
        return new JsonNodeChunkAdapter(definition, chunkTypeForIndex, jsonPointerStrToColumnNames, allowNulls);
    }

    private static FieldCopier makeFieldCopier(String fieldName, ChunkType chunkType, Class<?> dataType, Class<?> componentType) {
        switch (chunkType) {
            case Char: {
                return new JsonNodeCharFieldCopier(fieldName);
            }
            case Byte: {
                if (dataType == Boolean.class) {
                    return new JsonNodeBooleanFieldCopier(fieldName);
                }
                return new JsonNodeByteFieldCopier(fieldName);
            }
            case Short: {
                return new JsonNodeShortFieldCopier(fieldName);
            }
            case Int: {
                return new JsonNodeIntFieldCopier(fieldName);
            }
            case Long: {
                if (dataType == Instant.class) {
                    return new JsonNodeInstantFieldCopier(fieldName);
                }
                return new JsonNodeLongFieldCopier(fieldName);
            }
            case Float: {
                return new JsonNodeFloatFieldCopier(fieldName);
            }
            case Double: {
                return new JsonNodeDoubleFieldCopier(fieldName);
            }
            case Object: {
                if (dataType == String.class) {
                    return new JsonNodeStringFieldCopier(fieldName);
                }
                if (dataType.isAssignableFrom(JsonNode.class)) {
                    return new JsonNodeJsonNodeFieldCopier(fieldName);
                }
                throw new UncheckedDeephavenException("Type " + dataType.getSimpleName() + " not supported for JSON");
            }
        }
        throw new IllegalArgumentException("Can not convert field of type " + dataType);
    }
}

