/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.kafka.ingest;

import com.fasterxml.jackson.core.JsonPointer;
import com.fasterxml.jackson.databind.JsonNode;
import io.deephaven.chunk.ObjectChunk;
import io.deephaven.chunk.WritableChunk;
import io.deephaven.chunk.WritableLongChunk;
import io.deephaven.chunk.attributes.Values;
import io.deephaven.kafka.ingest.FieldCopier;
import io.deephaven.kafka.ingest.JsonNodeUtil;
import io.deephaven.time.DateTimeUtils;
import java.time.Instant;

public class JsonNodeInstantFieldCopier
implements FieldCopier {
    private final JsonPointer fieldPointer;

    public JsonNodeInstantFieldCopier(String fieldPointerStr) {
        this.fieldPointer = JsonPointer.compile((String)fieldPointerStr);
    }

    @Override
    public void copyField(ObjectChunk<Object, Values> inputChunk, WritableChunk<Values> publisherChunk, int sourceOffset, int destOffset, int length) {
        WritableLongChunk output = publisherChunk.asWritableLongChunk();
        for (int ii = 0; ii < length; ++ii) {
            JsonNode node = (JsonNode)inputChunk.get(ii + sourceOffset);
            Instant instant = JsonNodeUtil.getInstant(node, this.fieldPointer, true, true);
            output.set(ii + destOffset, DateTimeUtils.epochNanos((Instant)instant));
        }
    }
}

