/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.kafka.ingest;

import com.fasterxml.jackson.core.JsonPointer;
import com.fasterxml.jackson.databind.JsonNode;
import io.deephaven.chunk.ObjectChunk;
import io.deephaven.chunk.WritableChunk;
import io.deephaven.chunk.WritableObjectChunk;
import io.deephaven.chunk.attributes.Values;
import io.deephaven.kafka.ingest.FieldCopier;

public class JsonNodeJsonNodeFieldCopier
implements FieldCopier {
    private final JsonPointer fieldPointer;

    public JsonNodeJsonNodeFieldCopier(String fieldPointerStr) {
        this.fieldPointer = JsonPointer.compile((String)fieldPointerStr);
    }

    @Override
    public void copyField(ObjectChunk<Object, Values> inputChunk, WritableChunk<Values> publisherChunk, int sourceOffset, int destOffset, int length) {
        WritableObjectChunk output = publisherChunk.asWritableObjectChunk();
        for (int ii = 0; ii < length; ++ii) {
            JsonNode baseNode = (JsonNode)inputChunk.get(ii + sourceOffset);
            JsonNode node = baseNode == null ? null : baseNode.at(this.fieldPointer);
            output.set(ii + destOffset, (Object)node);
        }
    }
}

