/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.kafka.ingest;

import com.fasterxml.jackson.core.JsonPointer;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import io.deephaven.UncheckedDeephavenException;
import io.deephaven.time.DateTimeUtils;
import io.deephaven.util.type.TypeUtils;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Instant;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonNodeUtil {
    private static final ObjectMapper DEFAULT_OBJECT_MAPPER = new ObjectMapper().setNodeFactory(JsonNodeFactory.withExactBigDecimals((boolean)true)).configure(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS, true);

    public static JsonNode makeJsonNode(ObjectMapper mapper, String json) {
        try {
            return mapper != null ? mapper.readTree(json) : DEFAULT_OBJECT_MAPPER.readTree(json);
        }
        catch (JsonProcessingException ex) {
            throw new UncheckedDeephavenException("Failed to parse JSON string.", (Throwable)ex);
        }
    }

    private static JsonNode checkAllowMissingOrNull(JsonNode node, @NotNull String key, boolean allowMissingKeys, boolean allowNullValues) {
        JsonNode tmpNode = node == null ? null : node.get(key);
        JsonNodeUtil.checkNode(key, tmpNode, allowMissingKeys, allowNullValues);
        return tmpNode;
    }

    private static JsonNode checkAllowMissingOrNull(JsonNode node, @NotNull JsonPointer ptr, boolean allowMissingKeys, boolean allowNullValues) {
        JsonNode tmpNode = node == null ? null : node.at(ptr);
        JsonNodeUtil.checkNode(ptr, tmpNode, allowMissingKeys, allowNullValues);
        return tmpNode;
    }

    private static void checkNode(Object key, JsonNode node, boolean allowMissingKeys, boolean allowNullValues) {
        if (!allowMissingKeys && (node == null || node.isMissingNode())) {
            throw new IllegalArgumentException(String.format("Key '%s' not found in the record, and allowMissingKeys is false.", key));
        }
        if (!allowNullValues && JsonNodeUtil.isNullOrMissingField(node)) {
            throw new IllegalArgumentException(String.format("Value for '%s' is null or missing in the record, and allowNullValues is false.", key));
        }
    }

    private static boolean isNullOrMissingField(JsonNode node) {
        return node == null || node.isNull() || node.isMissingNode();
    }

    public static int getInt(@NotNull JsonNode node, @NotNull String key, boolean allowMissingKeys, boolean allowNullValues) {
        return JsonNodeUtil.getInt(JsonNodeUtil.checkAllowMissingOrNull(node, key, allowMissingKeys, allowNullValues));
    }

    public static int getInt(@NotNull JsonNode node, @NotNull JsonPointer ptr, boolean allowMissingKeys, boolean allowNullValues) {
        return JsonNodeUtil.getInt(JsonNodeUtil.checkAllowMissingOrNull(node, ptr, allowMissingKeys, allowNullValues));
    }

    public static int getInt(JsonNode node) {
        return JsonNodeUtil.isNullOrMissingField(node) ? Integer.MIN_VALUE : node.asInt();
    }

    @Nullable
    public static Integer getBoxedInt(@NotNull JsonNode node, @NotNull String key, boolean allowMissingKeys, boolean allowNullValues) {
        return TypeUtils.box((int)JsonNodeUtil.getInt(node, key, allowMissingKeys, allowNullValues));
    }

    @Nullable
    public static Integer getBoxedInt(JsonNode node) {
        return TypeUtils.box((int)JsonNodeUtil.getInt(node));
    }

    public static short getShort(@NotNull JsonNode node, @NotNull String key, boolean allowMissingKeys, boolean allowNullValues) {
        return JsonNodeUtil.getShort(JsonNodeUtil.checkAllowMissingOrNull(node, key, allowMissingKeys, allowNullValues));
    }

    public static short getShort(@NotNull JsonNode node, @NotNull JsonPointer ptr, boolean allowMissingKeys, boolean allowNullValues) {
        return JsonNodeUtil.getShort(JsonNodeUtil.checkAllowMissingOrNull(node, ptr, allowMissingKeys, allowNullValues));
    }

    public static short getShort(JsonNode node) {
        return JsonNodeUtil.isNullOrMissingField(node) ? (short)Short.MIN_VALUE : (short)node.asInt();
    }

    @Nullable
    public static Short getBoxedShort(@NotNull JsonNode node, @NotNull String key, boolean allowMissingKeys, boolean allowNullValues) {
        return TypeUtils.box((short)JsonNodeUtil.getShort(node, key, allowMissingKeys, allowNullValues));
    }

    @Nullable
    public static Short getBoxedShort(JsonNode node) {
        return TypeUtils.box((short)JsonNodeUtil.getShort(node));
    }

    public static long getLong(@NotNull JsonNode node, @NotNull String key, boolean allowMissingKeys, boolean allowNullValues) {
        return JsonNodeUtil.getLong(JsonNodeUtil.checkAllowMissingOrNull(node, key, allowMissingKeys, allowNullValues));
    }

    public static long getLong(@NotNull JsonNode node, @NotNull JsonPointer ptr, boolean allowMissingKeys, boolean allowNullValues) {
        return JsonNodeUtil.getLong(JsonNodeUtil.checkAllowMissingOrNull(node, ptr, allowMissingKeys, allowNullValues));
    }

    public static long getLong(JsonNode node) {
        return JsonNodeUtil.isNullOrMissingField(node) ? Long.MIN_VALUE : node.asLong();
    }

    @Nullable
    public static Long getBoxedLong(@NotNull JsonNode node, @NotNull String key, boolean allowMissingKeys, boolean allowNullValues) {
        return TypeUtils.box((long)JsonNodeUtil.getLong(node, key, allowMissingKeys, allowNullValues));
    }

    @Nullable
    public static Long getBoxedLong(JsonNode node) {
        return TypeUtils.box((long)JsonNodeUtil.getLong(node));
    }

    public static double getDouble(@NotNull JsonNode node, @NotNull String key, boolean allowMissingKeys, boolean allowNullValues) {
        return JsonNodeUtil.getDouble(JsonNodeUtil.checkAllowMissingOrNull(node, key, allowMissingKeys, allowNullValues));
    }

    public static double getDouble(@NotNull JsonNode node, @NotNull JsonPointer ptr, boolean allowMissingKeys, boolean allowNullValues) {
        return JsonNodeUtil.getDouble(JsonNodeUtil.checkAllowMissingOrNull(node, ptr, allowMissingKeys, allowNullValues));
    }

    public static double getDouble(JsonNode node) {
        return JsonNodeUtil.isNullOrMissingField(node) ? -1.7976931348623157E308 : node.asDouble();
    }

    @Nullable
    public static Double getBoxedDouble(@NotNull JsonNode node, @NotNull String key, boolean allowMissingKeys, boolean allowNullValues) {
        return TypeUtils.box((double)JsonNodeUtil.getDouble(node, key, allowMissingKeys, allowNullValues));
    }

    @Nullable
    public static Double getBoxedDouble(JsonNode node) {
        return TypeUtils.box((double)JsonNodeUtil.getDouble(node));
    }

    public static float getFloat(@NotNull JsonNode node, @NotNull String key, boolean allowMissingKeys, boolean allowNullValues) {
        return JsonNodeUtil.getFloat(JsonNodeUtil.checkAllowMissingOrNull(node, key, allowMissingKeys, allowNullValues));
    }

    public static float getFloat(@NotNull JsonNode node, @NotNull JsonPointer ptr, boolean allowMissingKeys, boolean allowNullValues) {
        return JsonNodeUtil.getFloat(JsonNodeUtil.checkAllowMissingOrNull(node, ptr, allowMissingKeys, allowNullValues));
    }

    public static float getFloat(JsonNode node) {
        return JsonNodeUtil.isNullOrMissingField(node) ? -3.4028235E38f : (float)node.asDouble();
    }

    @Nullable
    public static Float getBoxedFloat(@NotNull JsonNode node, @NotNull String key, boolean allowMissingKeys, boolean allowNullValues) {
        return TypeUtils.box((float)JsonNodeUtil.getFloat(node, key, allowMissingKeys, allowNullValues));
    }

    @Nullable
    public static Float getBoxedFloat(JsonNode node) {
        return TypeUtils.box((float)JsonNodeUtil.getFloat(node));
    }

    public static byte getByte(@NotNull JsonNode node, @NotNull String key, boolean allowMissingKeys, boolean allowNullValues) {
        return JsonNodeUtil.getByte(JsonNodeUtil.checkAllowMissingOrNull(node, key, allowMissingKeys, allowNullValues));
    }

    public static byte getByte(@NotNull JsonNode node, @NotNull JsonPointer ptr, boolean allowMissingKeys, boolean allowNullValues) {
        return JsonNodeUtil.getByte(JsonNodeUtil.checkAllowMissingOrNull(node, ptr, allowMissingKeys, allowNullValues));
    }

    public static byte getByte(JsonNode node) {
        if (JsonNodeUtil.isNullOrMissingField(node)) {
            return -128;
        }
        return (byte)node.asInt();
    }

    @Nullable
    public static Byte getBoxedByte(@NotNull JsonNode node, @NotNull String key, boolean allowMissingKeys, boolean allowNullValues) {
        return TypeUtils.box((byte)JsonNodeUtil.getByte(node, key, allowMissingKeys, allowNullValues));
    }

    @Nullable
    public static Byte getBoxedByte(JsonNode node) {
        return TypeUtils.box((byte)JsonNodeUtil.getByte(node));
    }

    public static char getChar(@NotNull JsonNode node, @NotNull String key, boolean allowMissingKeys, boolean allowNullValues) {
        return JsonNodeUtil.getChar(JsonNodeUtil.checkAllowMissingOrNull(node, key, allowMissingKeys, allowNullValues));
    }

    public static char getChar(@NotNull JsonNode node, @NotNull JsonPointer ptr, boolean allowMissingKeys, boolean allowNullValues) {
        return JsonNodeUtil.getChar(JsonNodeUtil.checkAllowMissingOrNull(node, ptr, allowMissingKeys, allowNullValues));
    }

    public static char getChar(JsonNode node) {
        if (JsonNodeUtil.isNullOrMissingField(node)) {
            return '\uffff';
        }
        if (node.isNumber()) {
            return (char)node.numberValue().intValue();
        }
        String s = node.asText();
        if (s.isEmpty()) {
            return '\uffff';
        }
        return s.charAt(0);
    }

    @Nullable
    public static Character getBoxedChar(@NotNull JsonNode node, @NotNull String key, boolean allowMissingKeys, boolean allowNullValues) {
        return TypeUtils.box((char)JsonNodeUtil.getChar(node, key, allowMissingKeys, allowNullValues));
    }

    @Nullable
    public static Character getBoxedChar(JsonNode node) {
        return TypeUtils.box((char)JsonNodeUtil.getChar(node));
    }

    @Nullable
    public static String getString(@NotNull JsonNode node, @NotNull String key, boolean allowMissingKeys, boolean allowNullValues) {
        return JsonNodeUtil.getString(JsonNodeUtil.checkAllowMissingOrNull(node, key, allowMissingKeys, allowNullValues));
    }

    @Nullable
    public static String getString(@NotNull JsonNode node, @NotNull JsonPointer ptr, boolean allowMissingKeys, boolean allowNullValues) {
        return JsonNodeUtil.getString(JsonNodeUtil.checkAllowMissingOrNull(node, ptr, allowMissingKeys, allowNullValues));
    }

    @Nullable
    public static String getString(JsonNode node) {
        if (JsonNodeUtil.isNullOrMissingField(node)) {
            return null;
        }
        return node.isValueNode() ? node.asText() : node.toString();
    }

    public static Boolean getBoolean(@NotNull JsonNode node, @NotNull String key, boolean allowMissingKeys, boolean allowNullValues) {
        return JsonNodeUtil.getBoolean(JsonNodeUtil.checkAllowMissingOrNull(node, key, allowMissingKeys, allowNullValues));
    }

    public static Boolean getBoolean(@NotNull JsonNode node, @NotNull JsonPointer ptr, boolean allowMissingKeys, boolean allowNullValues) {
        return JsonNodeUtil.getBoolean(JsonNodeUtil.checkAllowMissingOrNull(node, ptr, allowMissingKeys, allowNullValues));
    }

    @Nullable
    public static Boolean getBoolean(JsonNode node) {
        return JsonNodeUtil.isNullOrMissingField(node) ? null : Boolean.valueOf(node.asBoolean());
    }

    public static BigInteger getBigInteger(@NotNull JsonNode node, @NotNull String key, boolean allowMissingKeys, boolean allowNullValues) {
        return JsonNodeUtil.getBigInteger(JsonNodeUtil.checkAllowMissingOrNull(node, key, allowMissingKeys, allowNullValues));
    }

    public static BigInteger getBigInteger(@NotNull JsonNode node, @NotNull JsonPointer ptr, boolean allowMissingKeys, boolean allowNullValues) {
        return JsonNodeUtil.getBigInteger(JsonNodeUtil.checkAllowMissingOrNull(node, ptr, allowMissingKeys, allowNullValues));
    }

    @Nullable
    public static BigInteger getBigInteger(JsonNode node) {
        return JsonNodeUtil.isNullOrMissingField(node) ? null : node.bigIntegerValue();
    }

    @Nullable
    public static BigDecimal getBigDecimal(@NotNull JsonNode node, @NotNull String key, boolean allowMissingKeys, boolean allowNullValues) {
        return JsonNodeUtil.getBigDecimal(JsonNodeUtil.checkAllowMissingOrNull(node, key, allowMissingKeys, allowNullValues));
    }

    @Nullable
    public static BigDecimal getBigDecimal(@NotNull JsonNode node, @NotNull JsonPointer ptr, boolean allowMissingKeys, boolean allowNullValues) {
        return JsonNodeUtil.getBigDecimal(JsonNodeUtil.checkAllowMissingOrNull(node, ptr, allowMissingKeys, allowNullValues));
    }

    @Nullable
    public static BigDecimal getBigDecimal(JsonNode node) {
        return JsonNodeUtil.isNullOrMissingField(node) ? null : node.decimalValue();
    }

    @Nullable
    public static Object getValue(@NotNull JsonNode node, @NotNull String key, boolean allowMissingKeys, boolean allowNullValues) {
        return JsonNodeUtil.getValue(JsonNodeUtil.checkAllowMissingOrNull(node, key, allowMissingKeys, allowNullValues));
    }

    @Nullable
    public static Object getValue(JsonNode node) {
        return JsonNodeUtil.isNullOrMissingField(node) ? null : node;
    }

    @Nullable
    public static Instant getInstant(@NotNull JsonNode node, @NotNull String key, boolean allowMissingKeys, boolean allowNullValues) {
        return JsonNodeUtil.getInstant(JsonNodeUtil.checkAllowMissingOrNull(node, key, allowMissingKeys, allowNullValues));
    }

    @Nullable
    public static Instant getInstant(@NotNull JsonNode node, @NotNull JsonPointer ptr, boolean allowMissingKeys, boolean allowNullValues) {
        return JsonNodeUtil.getInstant(JsonNodeUtil.checkAllowMissingOrNull(node, ptr, allowMissingKeys, allowNullValues));
    }

    @Nullable
    public static Instant getInstant(JsonNode node) {
        if (JsonNodeUtil.isNullOrMissingField(node)) {
            return null;
        }
        if (node.isLong() || node.isInt()) {
            long value = node.asLong();
            return DateTimeUtils.epochAutoToInstant((long)value);
        }
        return DateTimeUtils.parseInstant((String)node.asText());
    }
}

