/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.kafka.protobuf;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.deephaven.kafka.protobuf.DescriptorSchemaRegistry;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="DescriptorSchemaRegistry", generator="Immutables")
@Immutable
final class ImmutableDescriptorSchemaRegistry
extends DescriptorSchemaRegistry {
    private final String subject;
    @Nullable
    private final Integer version;
    @Nullable
    private final String messageName;

    private ImmutableDescriptorSchemaRegistry(Builder builder) {
        this.subject = builder.subject;
        this.version = builder.version;
        this.messageName = builder.messageName;
    }

    @Override
    public String subject() {
        return this.subject;
    }

    @Override
    public OptionalInt version() {
        return this.version != null ? OptionalInt.of(this.version) : OptionalInt.empty();
    }

    @Override
    public Optional<String> messageName() {
        return Optional.ofNullable(this.messageName);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableDescriptorSchemaRegistry && this.equalTo(0, (ImmutableDescriptorSchemaRegistry)another);
    }

    private boolean equalTo(int synthetic, ImmutableDescriptorSchemaRegistry another) {
        return this.subject.equals(another.subject) && Objects.equals(this.version, another.version) && Objects.equals(this.messageName, another.messageName);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.getClass().hashCode();
        h += (h << 5) + this.subject.hashCode();
        h += (h << 5) + Objects.hashCode(this.version);
        h += (h << 5) + Objects.hashCode(this.messageName);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("DescriptorSchemaRegistry{");
        builder.append("subject=").append(this.subject);
        if (this.version != null) {
            builder.append(", ");
            builder.append("version=").append(this.version);
        }
        if (this.messageName != null) {
            builder.append(", ");
            builder.append("messageName=").append(this.messageName);
        }
        return builder.append("}").toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="DescriptorSchemaRegistry", generator="Immutables")
    @NotThreadSafe
    public static final class Builder
    implements DescriptorSchemaRegistry.Builder {
        private static final long INIT_BIT_SUBJECT = 1L;
        private static final long OPT_BIT_VERSION = 1L;
        private static final long OPT_BIT_MESSAGE_NAME = 2L;
        private long initBits = 1L;
        private long optBits;
        @Nullable
        private String subject;
        @Nullable
        private Integer version;
        @Nullable
        private String messageName;

        private Builder() {
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder subject(String subject) {
            Builder.checkNotIsSet(this.subjectIsSet(), "subject");
            this.subject = Objects.requireNonNull(subject, "subject");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder version(int version) {
            Builder.checkNotIsSet(this.versionIsSet(), "version");
            this.version = version;
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder version(OptionalInt version) {
            Builder.checkNotIsSet(this.versionIsSet(), "version");
            this.version = version.isPresent() ? Integer.valueOf(version.getAsInt()) : null;
            this.optBits |= 1L;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder messageName(String messageName) {
            Builder.checkNotIsSet(this.messageNameIsSet(), "messageName");
            this.messageName = Objects.requireNonNull(messageName, "messageName");
            this.optBits |= 2L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder messageName(Optional<String> messageName) {
            Builder.checkNotIsSet(this.messageNameIsSet(), "messageName");
            this.messageName = messageName.orElse(null);
            this.optBits |= 2L;
            return this;
        }

        @Override
        public ImmutableDescriptorSchemaRegistry build() {
            this.checkRequiredAttributes();
            return new ImmutableDescriptorSchemaRegistry(this);
        }

        private boolean versionIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean messageNameIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean subjectIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private static void checkNotIsSet(boolean isSet, String name) {
            if (isSet) {
                throw new IllegalStateException("Builder of DescriptorSchemaRegistry is strict, attribute is already set: ".concat(name));
            }
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.subjectIsSet()) {
                attributes.add("subject");
            }
            return "Cannot build DescriptorSchemaRegistry, some of required attributes are not set " + attributes;
        }
    }
}

