/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.kafka.protobuf;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.deephaven.kafka.protobuf.DescriptorProvider;
import io.deephaven.kafka.protobuf.ProtobufConsumeOptions;
import io.deephaven.kafka.protobuf.Protocol;
import io.deephaven.protobuf.ProtobufDescriptorParserOptions;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ProtobufConsumeOptions", generator="Immutables")
@Immutable
final class ImmutableProtobufConsumeOptions
extends ProtobufConsumeOptions {
    private final DescriptorProvider descriptorProvider;
    private final Protocol protocol;
    private final ProtobufDescriptorParserOptions parserOptions;
    private final ProtobufConsumeOptions.FieldPathToColumnName pathToColumnName;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableProtobufConsumeOptions(Builder builder) {
        this.descriptorProvider = builder.descriptorProvider;
        if (builder.protocolIsSet()) {
            this.initShim.protocol(builder.protocol);
        }
        if (builder.parserOptionsIsSet()) {
            this.initShim.parserOptions(builder.parserOptions);
        }
        if (builder.pathToColumnNameIsSet()) {
            this.initShim.pathToColumnName(builder.pathToColumnName);
        }
        this.protocol = this.initShim.protocol();
        this.parserOptions = this.initShim.parserOptions();
        this.pathToColumnName = this.initShim.pathToColumnName();
        this.initShim = null;
    }

    @Override
    public DescriptorProvider descriptorProvider() {
        return this.descriptorProvider;
    }

    @Override
    public Protocol protocol() {
        InitShim shim = this.initShim;
        return shim != null ? shim.protocol() : this.protocol;
    }

    @Override
    public ProtobufDescriptorParserOptions parserOptions() {
        InitShim shim = this.initShim;
        return shim != null ? shim.parserOptions() : this.parserOptions;
    }

    @Override
    public ProtobufConsumeOptions.FieldPathToColumnName pathToColumnName() {
        InitShim shim = this.initShim;
        return shim != null ? shim.pathToColumnName() : this.pathToColumnName;
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableProtobufConsumeOptions && this.equalTo(0, (ImmutableProtobufConsumeOptions)another);
    }

    private boolean equalTo(int synthetic, ImmutableProtobufConsumeOptions another) {
        return this.descriptorProvider.equals(another.descriptorProvider) && this.protocol.equals(another.protocol) && this.parserOptions.equals(another.parserOptions) && this.pathToColumnName.equals(another.pathToColumnName);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.getClass().hashCode();
        h += (h << 5) + this.descriptorProvider.hashCode();
        h += (h << 5) + this.protocol.hashCode();
        h += (h << 5) + this.parserOptions.hashCode();
        h += (h << 5) + this.pathToColumnName.hashCode();
        return h;
    }

    public String toString() {
        return "ProtobufConsumeOptions{descriptorProvider=" + this.descriptorProvider + ", protocol=" + this.protocol + ", parserOptions=" + this.parserOptions + ", pathToColumnName=" + this.pathToColumnName + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ProtobufConsumeOptions", generator="Immutables")
    @NotThreadSafe
    public static final class Builder
    implements ProtobufConsumeOptions.Builder {
        private static final long INIT_BIT_DESCRIPTOR_PROVIDER = 1L;
        private static final long OPT_BIT_PROTOCOL = 1L;
        private static final long OPT_BIT_PARSER_OPTIONS = 2L;
        private static final long OPT_BIT_PATH_TO_COLUMN_NAME = 4L;
        private long initBits = 1L;
        private long optBits;
        @Nullable
        private DescriptorProvider descriptorProvider;
        @Nullable
        private Protocol protocol;
        @Nullable
        private ProtobufDescriptorParserOptions parserOptions;
        @Nullable
        private ProtobufConsumeOptions.FieldPathToColumnName pathToColumnName;

        private Builder() {
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder descriptorProvider(DescriptorProvider descriptorProvider) {
            Builder.checkNotIsSet(this.descriptorProviderIsSet(), "descriptorProvider");
            this.descriptorProvider = Objects.requireNonNull(descriptorProvider, "descriptorProvider");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder protocol(Protocol protocol) {
            Builder.checkNotIsSet(this.protocolIsSet(), "protocol");
            this.protocol = Objects.requireNonNull(protocol, "protocol");
            this.optBits |= 1L;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder parserOptions(ProtobufDescriptorParserOptions parserOptions) {
            Builder.checkNotIsSet(this.parserOptionsIsSet(), "parserOptions");
            this.parserOptions = Objects.requireNonNull(parserOptions, "parserOptions");
            this.optBits |= 2L;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder pathToColumnName(ProtobufConsumeOptions.FieldPathToColumnName pathToColumnName) {
            Builder.checkNotIsSet(this.pathToColumnNameIsSet(), "pathToColumnName");
            this.pathToColumnName = Objects.requireNonNull(pathToColumnName, "pathToColumnName");
            this.optBits |= 4L;
            return this;
        }

        @Override
        public ImmutableProtobufConsumeOptions build() {
            this.checkRequiredAttributes();
            return new ImmutableProtobufConsumeOptions(this);
        }

        private boolean protocolIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean parserOptionsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean pathToColumnNameIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean descriptorProviderIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private static void checkNotIsSet(boolean isSet, String name) {
            if (isSet) {
                throw new IllegalStateException("Builder of ProtobufConsumeOptions is strict, attribute is already set: ".concat(name));
            }
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.descriptorProviderIsSet()) {
                attributes.add("descriptorProvider");
            }
            return "Cannot build ProtobufConsumeOptions, some of required attributes are not set " + attributes;
        }
    }

    @Generated(from="ProtobufConsumeOptions", generator="Immutables")
    private final class InitShim {
        private byte protocolBuildStage = 0;
        private Protocol protocol;
        private byte parserOptionsBuildStage = 0;
        private ProtobufDescriptorParserOptions parserOptions;
        private byte pathToColumnNameBuildStage = 0;
        private ProtobufConsumeOptions.FieldPathToColumnName pathToColumnName;

        private InitShim() {
        }

        Protocol protocol() {
            if (this.protocolBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.protocolBuildStage == 0) {
                this.protocolBuildStage = (byte)-1;
                this.protocol = Objects.requireNonNull(ImmutableProtobufConsumeOptions.super.protocol(), "protocol");
                this.protocolBuildStage = 1;
            }
            return this.protocol;
        }

        void protocol(Protocol protocol) {
            this.protocol = protocol;
            this.protocolBuildStage = 1;
        }

        ProtobufDescriptorParserOptions parserOptions() {
            if (this.parserOptionsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.parserOptionsBuildStage == 0) {
                this.parserOptionsBuildStage = (byte)-1;
                this.parserOptions = Objects.requireNonNull(ImmutableProtobufConsumeOptions.super.parserOptions(), "parserOptions");
                this.parserOptionsBuildStage = 1;
            }
            return this.parserOptions;
        }

        void parserOptions(ProtobufDescriptorParserOptions parserOptions) {
            this.parserOptions = parserOptions;
            this.parserOptionsBuildStage = 1;
        }

        ProtobufConsumeOptions.FieldPathToColumnName pathToColumnName() {
            if (this.pathToColumnNameBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.pathToColumnNameBuildStage == 0) {
                this.pathToColumnNameBuildStage = (byte)-1;
                this.pathToColumnName = Objects.requireNonNull(ImmutableProtobufConsumeOptions.super.pathToColumnName(), "pathToColumnName");
                this.pathToColumnNameBuildStage = 1;
            }
            return this.pathToColumnName;
        }

        void pathToColumnName(ProtobufConsumeOptions.FieldPathToColumnName pathToColumnName) {
            this.pathToColumnName = pathToColumnName;
            this.pathToColumnNameBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.protocolBuildStage == -1) {
                attributes.add("protocol");
            }
            if (this.parserOptionsBuildStage == -1) {
                attributes.add("parserOptions");
            }
            if (this.pathToColumnNameBuildStage == -1) {
                attributes.add("pathToColumnName");
            }
            return "Cannot build ProtobufConsumeOptions, attribute initializers form cycle " + attributes;
        }
    }
}

