/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.kafka.publish;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.deephaven.base.clock.Clock;
import io.deephaven.chunk.ByteChunk;
import io.deephaven.chunk.CharChunk;
import io.deephaven.chunk.Chunk;
import io.deephaven.chunk.DoubleChunk;
import io.deephaven.chunk.FloatChunk;
import io.deephaven.chunk.IntChunk;
import io.deephaven.chunk.LongChunk;
import io.deephaven.chunk.ObjectChunk;
import io.deephaven.chunk.ShortChunk;
import io.deephaven.chunk.WritableObjectChunk;
import io.deephaven.chunk.attributes.Values;
import io.deephaven.engine.rowset.RowSequence;
import io.deephaven.engine.table.ChunkSource;
import io.deephaven.engine.table.ColumnSource;
import io.deephaven.engine.table.Table;
import io.deephaven.engine.util.string.StringUtils;
import io.deephaven.kafka.publish.KafkaPublisherException;
import io.deephaven.kafka.publish.KeyOrValueSerializer;
import io.deephaven.util.SafeCloseable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class JsonKeyOrValueSerializer
implements KeyOrValueSerializer<String> {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private final ObjectNode emptyObjectNode;
    private final Table source;
    protected final String nestedObjectDelimiter;
    protected final boolean outputNulls;
    protected final List<JSONFieldProcessor> fieldProcessors = new ArrayList<JSONFieldProcessor>();

    public JsonKeyOrValueSerializer(Table source, String[] columnNames, String[] fieldNames, String timestampFieldName, String nestedObjectDelimiter, boolean outputNulls) {
        this.source = source;
        this.nestedObjectDelimiter = nestedObjectDelimiter;
        this.outputNulls = outputNulls;
        this.makeFieldProcessors(columnNames, fieldNames);
        if (!StringUtils.isNullOrEmpty((String)timestampFieldName)) {
            this.fieldProcessors.add(new TimestampFieldProcessor(timestampFieldName));
        }
        this.emptyObjectNode = OBJECT_MAPPER.createObjectNode();
        if (nestedObjectDelimiter != null) {
            for (JSONFieldProcessor fieldProcessor : this.fieldProcessors) {
                String[] processorFieldNames = fieldProcessor.fieldName.split(nestedObjectDelimiter);
                ObjectNode node = this.emptyObjectNode;
                for (int i = 1; i < processorFieldNames.length; ++i) {
                    ObjectNode child = (ObjectNode)node.get(processorFieldNames[i - 1]);
                    if (child == null) {
                        child = OBJECT_MAPPER.createObjectNode();
                        node.set(processorFieldNames[i - 1], (JsonNode)child);
                    }
                    node = child;
                }
            }
        }
    }

    private JSONFieldProcessor makeByteFieldProcessor(String fieldName, ColumnSource<?> chunkSource) {
        return new JSONFieldProcessorImpl<ByteChunk<Values>>(fieldName, chunkSource){

            @Override
            void outputField(int ii, ObjectNode node, ByteChunk<Values> inputChunk) {
                byte raw = inputChunk.get(ii);
                if (raw == -128) {
                    if (JsonKeyOrValueSerializer.this.outputNulls) {
                        node.putNull(this.childNodeFieldName);
                    }
                } else {
                    node.set(this.childNodeFieldName, (JsonNode)node.numberNode(raw));
                }
            }
        };
    }

    private JSONFieldProcessor makeCharFieldProcessor(String fieldName, ColumnSource<?> chunkSource) {
        return new JSONFieldProcessorImpl<CharChunk<Values>>(fieldName, chunkSource){

            @Override
            void outputField(int ii, ObjectNode node, CharChunk<Values> inputChunk) {
                char raw = inputChunk.get(ii);
                if (raw == '\uffff') {
                    if (JsonKeyOrValueSerializer.this.outputNulls) {
                        node.putNull(this.childNodeFieldName);
                    }
                } else {
                    node.put(this.childNodeFieldName, String.valueOf(raw));
                }
            }
        };
    }

    private JSONFieldProcessor makeShortFieldProcessor(String fieldName, ColumnSource<?> chunkSource) {
        return new JSONFieldProcessorImpl<ShortChunk<Values>>(fieldName, chunkSource){

            @Override
            void outputField(int ii, ObjectNode node, ShortChunk<Values> inputChunk) {
                short raw = inputChunk.get(ii);
                if (raw == Short.MIN_VALUE) {
                    if (JsonKeyOrValueSerializer.this.outputNulls) {
                        node.putNull(this.childNodeFieldName);
                    }
                } else {
                    node.put(this.childNodeFieldName, raw);
                }
            }
        };
    }

    private JSONFieldProcessor makeIntFieldProcessor(String fieldName, ColumnSource<?> chunkSource) {
        return new JSONFieldProcessorImpl<IntChunk<Values>>(fieldName, chunkSource){

            @Override
            void outputField(int ii, ObjectNode node, IntChunk<Values> inputChunk) {
                int raw = inputChunk.get(ii);
                if (raw == Integer.MIN_VALUE) {
                    if (JsonKeyOrValueSerializer.this.outputNulls) {
                        node.putNull(this.childNodeFieldName);
                    }
                } else {
                    node.put(this.childNodeFieldName, raw);
                }
            }
        };
    }

    private JSONFieldProcessor makeLongFieldProcessor(String fieldName, ColumnSource<?> chunkSource) {
        return new JSONFieldProcessorImpl<LongChunk<Values>>(fieldName, chunkSource){

            @Override
            void outputField(int ii, ObjectNode node, LongChunk<Values> inputChunk) {
                long raw = inputChunk.get(ii);
                if (raw == Long.MIN_VALUE) {
                    if (JsonKeyOrValueSerializer.this.outputNulls) {
                        node.putNull(this.childNodeFieldName);
                    }
                } else {
                    node.put(this.childNodeFieldName, raw);
                }
            }
        };
    }

    private JSONFieldProcessor makeFloatFieldProcessor(String fieldName, ColumnSource<?> chunkSource) {
        return new JSONFieldProcessorImpl<FloatChunk<Values>>(fieldName, chunkSource){

            @Override
            void outputField(int ii, ObjectNode node, FloatChunk<Values> inputChunk) {
                float raw = inputChunk.get(ii);
                if (raw == -3.4028235E38f) {
                    if (JsonKeyOrValueSerializer.this.outputNulls) {
                        node.putNull(this.childNodeFieldName);
                    }
                } else {
                    node.put(this.childNodeFieldName, raw);
                }
            }
        };
    }

    private JSONFieldProcessor makeDoubleFieldProcessor(String fieldName, ColumnSource<?> chunkSource) {
        return new JSONFieldProcessorImpl<DoubleChunk<Values>>(fieldName, chunkSource){

            @Override
            void outputField(int ii, ObjectNode node, DoubleChunk<Values> inputChunk) {
                double raw = inputChunk.get(ii);
                if (raw == -1.7976931348623157E308) {
                    if (JsonKeyOrValueSerializer.this.outputNulls) {
                        node.putNull(this.childNodeFieldName);
                    }
                } else {
                    node.put(this.childNodeFieldName, raw);
                }
            }
        };
    }

    private <T> JSONFieldProcessor makeObjectFieldProcessor(String fieldName, ColumnSource<?> chunkSource, final PutFun<T> putFun) {
        return new JSONFieldProcessorImpl<ObjectChunk<T, Values>>(fieldName, chunkSource){

            @Override
            void outputField(int ii, ObjectNode node, ObjectChunk<T, Values> inputChunk) {
                Object raw = inputChunk.get(ii);
                if (raw == null) {
                    if (JsonKeyOrValueSerializer.this.outputNulls) {
                        node.putNull(this.childNodeFieldName);
                    }
                } else {
                    putFun.put(node, this.childNodeFieldName, raw);
                }
            }
        };
    }

    private JSONFieldProcessor makeToStringFieldProcessor(String fieldName, ColumnSource<?> chunkSource) {
        return this.makeObjectFieldProcessor(fieldName, chunkSource, (node, childNodeFieldName, raw) -> node.put(childNodeFieldName, Objects.toString(raw)));
    }

    private JSONFieldProcessor makeBooleanFieldProcessor(String fieldName, ColumnSource<?> chunkSource) {
        return this.makeObjectFieldProcessor(fieldName, chunkSource, ObjectNode::put);
    }

    private JSONFieldProcessor makeBigIntegerFieldProcessor(String fieldName, ColumnSource<?> chunkSource) {
        return this.makeObjectFieldProcessor(fieldName, chunkSource, ObjectNode::put);
    }

    private JSONFieldProcessor makeBigDecimalFieldProcessor(String fieldName, ColumnSource<?> chunkSource) {
        return this.makeObjectFieldProcessor(fieldName, chunkSource, ObjectNode::put);
    }

    void makeFieldProcessors(String[] columnNames, String[] fieldNames) {
        if (fieldNames != null && fieldNames.length != columnNames.length) {
            throw new IllegalArgumentException("fieldNames.length (" + fieldNames.length + ") != columnNames.length (" + columnNames.length + ")");
        }
        for (int i = 0; i < columnNames.length; ++i) {
            String columnName = columnNames[i];
            try {
                if (fieldNames == null) {
                    this.makeFieldProcessor(columnName, columnName);
                    continue;
                }
                this.makeFieldProcessor(columnName, fieldNames[i]);
                continue;
            }
            catch (RuntimeException e) {
                throw new IllegalArgumentException("Unknown column name " + columnName + " for table", e);
            }
        }
    }

    private void makeFieldProcessor(String columnName, String fieldName) {
        ColumnSource src = this.source.getColumnSource(columnName);
        Class type = src.getType();
        if (type == Byte.TYPE) {
            this.fieldProcessors.add(this.makeByteFieldProcessor(fieldName, src));
        } else if (type == Character.TYPE) {
            this.fieldProcessors.add(this.makeCharFieldProcessor(fieldName, src));
        } else if (type == Short.TYPE) {
            this.fieldProcessors.add(this.makeShortFieldProcessor(fieldName, src));
        } else if (type == Integer.TYPE) {
            this.fieldProcessors.add(this.makeIntFieldProcessor(fieldName, src));
        } else if (type == Long.TYPE) {
            this.fieldProcessors.add(this.makeLongFieldProcessor(fieldName, src));
        } else if (type == Float.TYPE) {
            this.fieldProcessors.add(this.makeFloatFieldProcessor(fieldName, src));
        } else if (type == Double.TYPE) {
            this.fieldProcessors.add(this.makeDoubleFieldProcessor(fieldName, src));
        } else if (type == Boolean.class) {
            this.fieldProcessors.add(this.makeBooleanFieldProcessor(fieldName, src));
        } else if (type == BigDecimal.class) {
            this.fieldProcessors.add(this.makeBigDecimalFieldProcessor(fieldName, src));
        } else if (type == BigInteger.class) {
            this.fieldProcessors.add(this.makeBigIntegerFieldProcessor(fieldName, src));
        } else {
            this.fieldProcessors.add(this.makeToStringFieldProcessor(fieldName, src));
        }
    }

    @Override
    public ObjectChunk<String, Values> handleChunk(KeyOrValueSerializer.Context context, RowSequence toProcess, boolean previous) {
        int position;
        JsonContext jsonContext = (JsonContext)context;
        jsonContext.outputChunk.setSize(0);
        jsonContext.jsonChunk.setSize(toProcess.intSize());
        for (position = 0; position < toProcess.intSize(); ++position) {
            jsonContext.jsonChunk.set(position, (Object)this.emptyObjectNode.deepCopy());
        }
        for (int ii = 0; ii < this.fieldProcessors.size(); ++ii) {
            this.fieldProcessors.get(ii).processField(jsonContext.fieldContexts[ii], jsonContext.jsonChunk, toProcess, previous);
        }
        for (position = 0; position < toProcess.intSize(); ++position) {
            try {
                jsonContext.outputChunk.add((Object)OBJECT_MAPPER.writeValueAsString(jsonContext.jsonChunk.get(position)));
                continue;
            }
            catch (JsonProcessingException e) {
                throw new KafkaPublisherException("Failed to write JSON message", e);
            }
        }
        return jsonContext.outputChunk;
    }

    @Override
    public KeyOrValueSerializer.Context makeContext(int size) {
        return new JsonContext(size);
    }

    private final class JsonContext
    implements KeyOrValueSerializer.Context {
        private final WritableObjectChunk<String, Values> outputChunk;
        private final WritableObjectChunk<ObjectNode, Values> jsonChunk;
        private final FieldContext[] fieldContexts;

        public JsonContext(int size) {
            this.outputChunk = WritableObjectChunk.makeWritableChunk((int)size);
            this.jsonChunk = WritableObjectChunk.makeWritableChunk((int)size);
            this.fieldContexts = new FieldContext[JsonKeyOrValueSerializer.this.fieldProcessors.size()];
            for (int ii = 0; ii < JsonKeyOrValueSerializer.this.fieldProcessors.size(); ++ii) {
                this.fieldContexts[ii] = JsonKeyOrValueSerializer.this.fieldProcessors.get(ii).makeContext(size);
            }
        }

        public void close() {
            this.outputChunk.close();
            this.jsonChunk.close();
            SafeCloseable.closeAll((AutoCloseable[])this.fieldContexts);
        }
    }

    private class TimestampFieldProcessor
    extends JSONFieldProcessor {
        public TimestampFieldProcessor(String fieldName) {
            super(fieldName);
        }

        @Override
        FieldContext makeContext(int size) {
            return null;
        }

        @Override
        public void processField(FieldContext fieldContext, WritableObjectChunk<ObjectNode, Values> jsonChunk, RowSequence keys, boolean isRemoval) {
            String nanosString = String.valueOf(Clock.system().currentTimeNanos());
            for (int ii = 0; ii < jsonChunk.size(); ++ii) {
                this.getChildNode((ObjectNode)jsonChunk.get(ii)).put(this.childNodeFieldName, nanosString);
            }
        }
    }

    @FunctionalInterface
    static interface PutFun<T> {
        public void put(ObjectNode var1, String var2, T var3);
    }

    abstract class JSONFieldProcessorImpl<ChunkType extends Chunk<Values>>
    extends JSONFieldProcessor {
        private final ColumnSource<?> chunkSource;

        public JSONFieldProcessorImpl(String fieldName, ColumnSource<?> chunkSource) {
            super(fieldName);
            this.chunkSource = chunkSource;
        }

        @Override
        FieldContext makeContext(int size) {
            return new ContextImpl(size);
        }

        abstract void outputField(int var1, ObjectNode var2, ChunkType var3);

        @Override
        void processField(FieldContext fieldContext, WritableObjectChunk<ObjectNode, Values> jsonChunk, RowSequence keys, boolean previous) {
            ContextImpl contextImpl = (ContextImpl)fieldContext;
            Chunk inputChunk = previous ? this.chunkSource.getPrevChunk(contextImpl.getContext, keys) : this.chunkSource.getChunk(contextImpl.getContext, keys);
            for (int ii = 0; ii < inputChunk.size(); ++ii) {
                ObjectNode node = this.getChildNode((ObjectNode)jsonChunk.get(ii));
                this.outputField(ii, node, inputChunk);
            }
        }

        private class ContextImpl
        implements FieldContext {
            ChunkSource.GetContext getContext;

            ContextImpl(int size) {
                this.getContext = JSONFieldProcessorImpl.this.chunkSource.makeGetContext(size);
            }

            public void close() {
                this.getContext.close();
            }
        }
    }

    abstract class JSONFieldProcessor {
        final String fieldName;
        protected final String[] fieldNames;
        protected final String childNodeFieldName;

        public JSONFieldProcessor(String fieldName) {
            this.fieldName = fieldName;
            if (JsonKeyOrValueSerializer.this.nestedObjectDelimiter != null) {
                this.fieldNames = fieldName.split(JsonKeyOrValueSerializer.this.nestedObjectDelimiter);
                this.childNodeFieldName = this.fieldNames[this.fieldNames.length - 1];
            } else {
                this.fieldNames = new String[]{fieldName};
                this.childNodeFieldName = fieldName;
            }
        }

        protected ObjectNode getChildNode(ObjectNode root) {
            ObjectNode child = root;
            for (int i = 0; i < this.fieldNames.length - 1; ++i) {
                child = (ObjectNode)child.get(this.fieldNames[i]);
            }
            return child;
        }

        abstract FieldContext makeContext(int var1);

        abstract void processField(FieldContext var1, WritableObjectChunk<ObjectNode, Values> var2, RowSequence var3, boolean var4);
    }

    private static interface FieldContext
    extends SafeCloseable {
    }
}

